/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.item;

import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import me.desht.pneumaticcraft.PneumaticCraftRepressurized;
import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.api.client.IFOVModifierItem;
import me.desht.pneumaticcraft.api.item.IInventoryItem;
import me.desht.pneumaticcraft.api.item.IItemRegistry;
import me.desht.pneumaticcraft.api.item.IPressurizable;
import me.desht.pneumaticcraft.api.item.IUpgradeAcceptor;
import me.desht.pneumaticcraft.common.GuiHandler;
import me.desht.pneumaticcraft.common.inventory.ContainerMinigunMagazine;
import me.desht.pneumaticcraft.common.inventory.handler.BaseItemStackHandler;
import me.desht.pneumaticcraft.common.item.IChargingStationGUIHolderItem;
import me.desht.pneumaticcraft.common.item.ItemGunAmmo;
import me.desht.pneumaticcraft.common.item.ItemMachineUpgrade;
import me.desht.pneumaticcraft.common.item.ItemPressurizable;
import me.desht.pneumaticcraft.common.item.Itemss;
import me.desht.pneumaticcraft.common.minigun.Minigun;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketPlaySound;
import me.desht.pneumaticcraft.common.util.NBTUtil;
import me.desht.pneumaticcraft.common.util.UpgradableItemUtils;
import me.desht.pneumaticcraft.lib.Log;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;

public class ItemMinigun
extends ItemPressurizable
implements IChargingStationGUIHolderItem,
IUpgradeAcceptor,
IFOVModifierItem,
IInventoryItem {
    public static final int MAGAZINE_SIZE = 4;
    private static Set<Item> applicableUpgrades;
    private static final String NBT_MAGAZINE = "Magazine";
    public static final String NBT_LOCKED_SLOT = "LockedSlot";
    private static final int[] MAX_UPGRADES;

    private static void setMaxUpgrades(IItemRegistry.EnumUpgrade upgrade, int max) {
        ItemMinigun.MAX_UPGRADES[upgrade.ordinal()] = max;
    }

    public ItemMinigun() {
        super("minigun", 30000, 3000);
    }

    public static MagazineHandler getMagazine(ItemStack stack) {
        if (stack.func_77973_b() instanceof ItemMinigun) {
            return new MagazineHandler(stack);
        }
        return null;
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int slot, boolean currentItem) {
        super.func_77663_a(stack, world, entity, slot, currentItem);
        EntityPlayer player = (EntityPlayer)entity;
        Minigun minigun = this.getMinigun(stack, player);
        if (!currentItem) {
            minigun.setMinigunSoundCounter(-1);
            minigun.setMinigunSpeed(0.0);
            minigun.setMinigunActivated(false);
            minigun.setMinigunTriggerTimeOut(0);
        } else {
            minigun.update(player.field_70165_t, player.field_70163_u, player.field_70161_v);
        }
        if (world.field_72995_K && currentItem && minigun.getMinigunSpeed() > 0.0) {
            PneumaticCraftRepressurized.proxy.suppressItemEquipAnimation();
        }
        if (!world.field_72995_K && slot >= 0 && slot <= 8) {
            this.handleAmmoRepair(stack, world, minigun);
        }
    }

    private void handleAmmoRepair(ItemStack stack, World world, Minigun minigun) {
        if (minigun.getPlayer().field_71070_bA instanceof ContainerMinigunMagazine) {
            return;
        }
        int itemLife = minigun.getUpgrades(IItemRegistry.EnumUpgrade.ITEM_LIFE);
        if (itemLife > 0) {
            IPressurizable p = (IPressurizable)stack.func_77973_b();
            MagazineHandler handler = ItemMinigun.getMagazine(stack);
            boolean repaired = false;
            for (int i = 0; i < handler.getSlots() && (double)p.getPressure(stack) > 0.1; ++i) {
                ItemStack ammo = handler.getStackInSlot(i);
                if (!(ammo.func_77973_b() instanceof ItemGunAmmo) || ammo.func_77952_i() <= 0 || world.func_82737_E() % (long)(475 - itemLife * 75) != 0L) continue;
                ammo.func_77964_b(ammo.func_77952_i() - 1);
                p.addAir(stack, -(2 << itemLife));
                repaired = true;
            }
            if (repaired) {
                handler.save();
            }
        }
    }

    private Minigun getMinigun(ItemStack stack, EntityPlayer player, ItemStack ammo) {
        return new MinigunItem().setItemStack(stack).setAmmoStack(ammo).setPlayer(player).setPressurizable(this, 20).setWorld(player.field_70170_p);
    }

    public Minigun getMinigun(ItemStack stack, EntityPlayer player) {
        return this.getMinigun(stack, player, ItemMinigun.getMagazine(stack).getAmmo());
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand handIn) {
        ItemStack stack = player.func_184586_b(handIn);
        if (!world.field_72995_K) {
            if (player.func_70093_af()) {
                player.openGui((Object)PneumaticCraftRepressurized.instance, GuiHandler.EnumGuiId.MINIGUN_MAGAZINE.ordinal(), world, (int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v);
            } else {
                MagazineHandler magazineHandler = ItemMinigun.getMagazine(stack);
                ItemStack ammo = magazineHandler.getAmmo();
                if (!ammo.func_190926_b()) {
                    int prevDamage = ammo.func_77952_i();
                    boolean usedAmmo = this.getMinigun(stack, player, ammo).tryFireMinigun(null);
                    if (usedAmmo) {
                        ammo.func_190920_e(0);
                    }
                    if (usedAmmo || ammo.func_77952_i() != prevDamage) {
                        magazineHandler.save();
                    }
                } else {
                    NetworkHandler.sendTo(new PacketPlaySound(SoundEvents.field_187556_aj, SoundCategory.PLAYERS, player.field_70165_t, player.field_70163_u, player.field_70161_v, 1.0f, 1.0f, false), (EntityPlayerMP)player);
                    player.func_146105_b((ITextComponent)new TextComponentTranslation("message.minigun.outOfAmmo", new Object[0]), true);
                }
            }
        }
        return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)stack);
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return false;
    }

    @Override
    public Set<Item> getApplicableUpgrades() {
        if (applicableUpgrades == null) {
            IItemRegistry r = PneumaticRegistry.getInstance().getItemRegistry();
            applicableUpgrades = ImmutableSet.of((Object)r.getUpgrade(IItemRegistry.EnumUpgrade.SPEED), (Object)r.getUpgrade(IItemRegistry.EnumUpgrade.RANGE), (Object)r.getUpgrade(IItemRegistry.EnumUpgrade.DISPENSER), (Object)r.getUpgrade(IItemRegistry.EnumUpgrade.ENTITY_TRACKER), (Object)r.getUpgrade(IItemRegistry.EnumUpgrade.ITEM_LIFE), (Object)r.getUpgrade(IItemRegistry.EnumUpgrade.SECURITY), (Object[])new Item[0]);
        }
        return applicableUpgrades;
    }

    @Override
    public String getName() {
        return this.func_77658_a() + ".name";
    }

    @Override
    public GuiHandler.EnumGuiId getGuiID() {
        return GuiHandler.EnumGuiId.MINIGUN_UPGRADES;
    }

    @Override
    public float getFOVModifier(ItemStack stack, EntityPlayer player, EntityEquipmentSlot slot) {
        Minigun minigun = this.getMinigun(stack, player);
        int trackers = minigun.getUpgrades(IItemRegistry.EnumUpgrade.ENTITY_TRACKER);
        if (!minigun.isMinigunActivated() || trackers == 0) {
            return 1.0f;
        }
        return (float)(1.0 - (double)trackers * minigun.getMinigunSpeed() / 2.0);
    }

    @Override
    public void getStacksInItem(ItemStack stack, List<ItemStack> curStacks) {
        MagazineHandler handler = ItemMinigun.getMagazine(stack);
        for (int i = 0; i < handler.getSlots(); ++i) {
            if (handler.getStackInSlot(i).func_190926_b()) continue;
            curStacks.add(handler.getStackInSlot(i));
        }
    }

    @Override
    public String getInventoryHeader() {
        return TextFormatting.GREEN + I18n.func_135052_a((String)"gui.tooltip.gunAmmo.loaded", (Object[])new Object[0]);
    }

    public static int getLockedSlot(ItemStack stack) {
        if (NBTUtil.hasTag(stack, NBT_LOCKED_SLOT)) {
            int slot = NBTUtil.getInteger(stack, NBT_LOCKED_SLOT);
            if (slot >= 0 && slot < 4) {
                return slot;
            }
            Log.warning("removed out of range saved ammo slot: " + slot);
            NBTUtil.removeTag(stack, NBT_LOCKED_SLOT);
        }
        return -1;
    }

    public static ItemStack getHeldMinigun(EntityPlayer player) {
        if (player.func_184614_ca().func_77973_b() == Itemss.MINIGUN) {
            return player.func_184614_ca();
        }
        if (player.func_184592_cb().func_77973_b() == Itemss.MINIGUN) {
            return player.func_184592_cb();
        }
        return ItemStack.field_190927_a;
    }

    static {
        MAX_UPGRADES = new int[IItemRegistry.EnumUpgrade.values().length];
        ItemMinigun.setMaxUpgrades(IItemRegistry.EnumUpgrade.SPEED, 3);
        ItemMinigun.setMaxUpgrades(IItemRegistry.EnumUpgrade.RANGE, 6);
        ItemMinigun.setMaxUpgrades(IItemRegistry.EnumUpgrade.DISPENSER, 3);
        ItemMinigun.setMaxUpgrades(IItemRegistry.EnumUpgrade.ITEM_LIFE, 4);
        ItemMinigun.setMaxUpgrades(IItemRegistry.EnumUpgrade.ENTITY_TRACKER, 4);
        ItemMinigun.setMaxUpgrades(IItemRegistry.EnumUpgrade.SECURITY, 1);
    }

    private class MinigunItem
    extends Minigun {
        private int[] upgrades;

        MinigunItem() {
            super(false);
            this.upgrades = null;
        }

        @Override
        public Minigun setAmmoStack(@Nonnull ItemStack ammoStack) {
            this.upgrades = null;
            return super.setAmmoStack(ammoStack);
        }

        @Override
        public boolean isMinigunActivated() {
            return NBTUtil.getBoolean(this.minigunStack, "activated");
        }

        @Override
        public void setMinigunActivated(boolean activated) {
            NBTUtil.setBoolean(this.minigunStack, "activated", activated);
        }

        @Override
        public void setAmmoColorStack(@Nonnull ItemStack ammo) {
            if (!ammo.func_190926_b()) {
                NBTTagCompound tag = new NBTTagCompound();
                ammo.func_77955_b(tag);
                NBTUtil.setCompoundTag(this.minigunStack, "ammoColorStack", (NBTBase)tag);
            } else {
                NBTUtil.removeTag(this.minigunStack, "ammoColorStack");
            }
        }

        @Override
        public int getAmmoColor() {
            ItemStack ammo = ItemStack.field_190927_a;
            if (NBTUtil.hasTag(this.minigunStack, "ammoColorStack")) {
                NBTTagCompound tag = NBTUtil.getCompoundTag(this.minigunStack, "ammoColorStack");
                ammo = new ItemStack(tag);
            }
            return this.getAmmoColor(ammo);
        }

        @Override
        public void playSound(SoundEvent soundName, float volume, float pitch) {
            NetworkHandler.sendToAllAround(new PacketPlaySound(soundName, SoundCategory.PLAYERS, this.player.func_180425_c(), volume, pitch, false), this.world);
        }

        @Override
        public double getMinigunSpeed() {
            return NBTUtil.getDouble(this.minigunStack, "speed");
        }

        @Override
        public void setMinigunSpeed(double minigunSpeed) {
            NBTUtil.setDouble(this.minigunStack, "speed", minigunSpeed);
        }

        @Override
        public int getMinigunTriggerTimeOut() {
            return NBTUtil.getInteger(this.minigunStack, "triggerTimeout");
        }

        @Override
        public void setMinigunTriggerTimeOut(int minigunTriggerTimeOut) {
            NBTUtil.setInteger(this.minigunStack, "triggerTimeout", minigunTriggerTimeOut);
        }

        @Override
        public int getMinigunSoundCounter() {
            return NBTUtil.getInteger(this.minigunStack, "soundCounter");
        }

        @Override
        public void setMinigunSoundCounter(int minigunSoundCounter) {
            NBTUtil.setInteger(this.minigunStack, "soundCounter", minigunSoundCounter);
        }

        @Override
        public double getMinigunRotation() {
            return NBTUtil.getDouble(this.minigunStack, "rotation");
        }

        @Override
        public void setMinigunRotation(double minigunRotation) {
            NBTUtil.setDouble(this.minigunStack, "rotation", minigunRotation);
        }

        @Override
        public double getOldMinigunRotation() {
            return NBTUtil.getDouble(this.minigunStack, "oldRotation");
        }

        @Override
        public void setOldMinigunRotation(double oldMinigunRotation) {
            NBTUtil.setDouble(this.minigunStack, "oldRotation", oldMinigunRotation);
        }

        private void loadUpgrades() {
            this.upgrades = new int[IItemRegistry.EnumUpgrade.values().length];
            for (ItemStack stack : UpgradableItemUtils.getUpgradeStacks(this.minigunStack)) {
                int idx;
                if (!(stack.func_77973_b() instanceof ItemMachineUpgrade)) continue;
                int n = idx = ((ItemMachineUpgrade)stack.func_77973_b()).getUpgradeType().ordinal();
                this.upgrades[n] = this.upgrades[n] + stack.func_190916_E();
            }
        }

        @Override
        public int getUpgrades(IItemRegistry.EnumUpgrade upgrade) {
            if (this.upgrades == null) {
                this.loadUpgrades();
            }
            return Math.min(MAX_UPGRADES[upgrade.ordinal()], this.upgrades[upgrade.ordinal()]);
        }
    }

    public static class MagazineHandler
    extends BaseItemStackHandler {
        private final ItemStack gunStack;

        MagazineHandler(ItemStack gunStack) {
            super(4);
            this.gunStack = gunStack;
            if (gunStack.func_77942_o() && gunStack.func_77978_p().func_74764_b(ItemMinigun.NBT_MAGAZINE)) {
                this.deserializeNBT(gunStack.func_77978_p().func_74775_l(ItemMinigun.NBT_MAGAZINE));
            }
        }

        public boolean isItemValid(int slot, ItemStack itemStack) {
            return itemStack.func_190926_b() || itemStack.func_77973_b() instanceof ItemGunAmmo;
        }

        public ItemStack getAmmo() {
            int slot = ItemMinigun.getLockedSlot(this.gunStack);
            if (slot >= 0) {
                return this.getStackInSlot(slot);
            }
            for (int i = 0; i < 4; ++i) {
                if (!(this.getStackInSlot(i).func_77973_b() instanceof ItemGunAmmo)) continue;
                return this.getStackInSlot(i);
            }
            return ItemStack.field_190927_a;
        }

        public void save() {
            if (!this.gunStack.func_190926_b()) {
                NBTUtil.setCompoundTag(this.gunStack, ItemMinigun.NBT_MAGAZINE, (NBTBase)this.serializeNBT());
            }
        }
    }
}

