/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.network;

import io.netty.buffer.ByteBuf;
import java.util.stream.Collectors;
import me.desht.pneumaticcraft.common.network.LocationIntPacket;
import me.desht.pneumaticcraft.common.semiblock.ISemiBlock;
import me.desht.pneumaticcraft.common.semiblock.SemiBlockManager;
import net.minecraft.entity.player.EntityPlayer;

public class PacketRemoveSemiBlock
extends LocationIntPacket<PacketRemoveSemiBlock> {
    private int index;

    public PacketRemoveSemiBlock() {
    }

    public PacketRemoveSemiBlock(ISemiBlock semiBlock, int index) {
        super(semiBlock.getPos());
        this.index = index;
    }

    @Override
    public void toBytes(ByteBuf buf) {
        super.toBytes(buf);
        buf.writeByte(this.index);
    }

    @Override
    public void fromBytes(ByteBuf buf) {
        super.fromBytes(buf);
        this.index = buf.readByte();
    }

    @Override
    public void handleClientSide(PacketRemoveSemiBlock message, EntityPlayer player) {
        SemiBlockManager manager = SemiBlockManager.getInstance(player.field_70170_p);
        manager.getSemiBlocks(player.field_70170_p, message.pos).filter(s -> s.getIndex() == message.index).collect(Collectors.toList()).forEach(manager::removeSemiBlock);
    }

    @Override
    public void handleServerSide(PacketRemoveSemiBlock message, EntityPlayer player) {
    }
}

