/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.progwidgets;

import java.util.List;
import me.desht.pneumaticcraft.client.gui.GuiProgrammer;
import me.desht.pneumaticcraft.client.gui.programmer.GuiWidgetCoordinateCondition;
import me.desht.pneumaticcraft.common.ai.IDroneBase;
import me.desht.pneumaticcraft.common.progwidgets.ICondition;
import me.desht.pneumaticcraft.common.progwidgets.IProgWidget;
import me.desht.pneumaticcraft.common.progwidgets.ProgWidgetConditionBase;
import me.desht.pneumaticcraft.common.progwidgets.ProgWidgetCoordinate;
import me.desht.pneumaticcraft.common.progwidgets.ProgWidgetCoordinateOperator;
import me.desht.pneumaticcraft.common.progwidgets.ProgWidgetString;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ProgWidgetCoordinateCondition
extends ProgWidgetConditionBase {
    public final boolean[] checkingAxis = new boolean[3];
    private ICondition.Operator operator = ICondition.Operator.HIGHER_THAN_EQUALS;

    @Override
    public Class<? extends IProgWidget>[] getParameters() {
        return new Class[]{ProgWidgetCoordinate.class, ProgWidgetCoordinate.class, ProgWidgetString.class};
    }

    @Override
    public String getWidgetString() {
        return "conditionCoordinate";
    }

    @Override
    public IProgWidget.WidgetDifficulty getDifficulty() {
        return IProgWidget.WidgetDifficulty.ADVANCED;
    }

    @Override
    public void addErrors(List<String> curInfo, List<IProgWidget> widgets) {
        super.addErrors(curInfo, widgets);
        if (!(this.checkingAxis[0] || this.checkingAxis[1] || this.checkingAxis[2])) {
            curInfo.add("gui.progWidget.conditionCoordinate.error.noAxisSelected");
        }
    }

    @Override
    public boolean evaluate(IDroneBase drone, IProgWidget widget) {
        BlockPos pos1 = ProgWidgetCoordinateOperator.calculateCoordinate(widget, 0, ProgWidgetCoordinateOperator.EnumOperator.PLUS_MINUS);
        BlockPos pos2 = ProgWidgetCoordinateOperator.calculateCoordinate(widget, 1, ProgWidgetCoordinateOperator.EnumOperator.PLUS_MINUS);
        if (this.checkingAxis[0] && !this.evaluate(pos1.func_177958_n(), pos2.func_177958_n())) {
            return false;
        }
        if (this.checkingAxis[1] && !this.evaluate(pos1.func_177956_o(), pos2.func_177956_o())) {
            return false;
        }
        return !this.checkingAxis[2] || this.evaluate(pos1.func_177952_p(), pos2.func_177952_p());
    }

    private boolean evaluate(int arg1, int arg2) {
        return this.operator == ICondition.Operator.EQUALS ? arg1 == arg2 : arg1 >= arg2;
    }

    public ICondition.Operator getOperator() {
        return this.operator;
    }

    public void setOperator(ICondition.Operator operator) {
        this.operator = operator;
    }

    @Override
    public void writeToNBT(NBTTagCompound tag) {
        super.writeToNBT(tag);
        tag.func_74757_a("checkX", this.checkingAxis[0]);
        tag.func_74757_a("checkY", this.checkingAxis[1]);
        tag.func_74757_a("checkZ", this.checkingAxis[2]);
        tag.func_74774_a("operator", (byte)this.operator.ordinal());
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
        super.readFromNBT(tag);
        this.checkingAxis[0] = tag.func_74767_n("checkX");
        this.checkingAxis[1] = tag.func_74767_n("checkY");
        this.checkingAxis[2] = tag.func_74767_n("checkZ");
        this.operator = ICondition.Operator.values()[tag.func_74771_c("operator")];
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen getOptionWindow(GuiProgrammer guiProgrammer) {
        return new GuiWidgetCoordinateCondition(this, guiProgrammer);
    }

    @Override
    public ResourceLocation getTexture() {
        return Textures.PROG_WIDGET_CONDITION_COORDINATE;
    }

    @Override
    public void getTooltip(List<String> curTooltip) {
        super.getTooltip(curTooltip);
        curTooltip.add("Condition: \"" + this.getCondition() + "\"");
    }

    @Override
    public String getExtraStringInfo() {
        String condition = this.getCondition();
        return condition.length() > 0 ? condition : null;
    }

    public String getCondition() {
        char[] axis = new char[]{'x', 'y', 'z'};
        StringBuilder condition = new StringBuilder();
        for (int i = 0; i < 3; ++i) {
            if (!this.checkingAxis[i]) continue;
            if (condition.length() > 0) {
                condition.append(" and ");
            }
            condition.append(("%s1 " + (Object)((Object)this.operator) + " %s2").replace("%s", "" + axis[i]));
        }
        return condition.toString();
    }
}

