/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.progwidgets.area;

import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import me.desht.pneumaticcraft.common.progwidgets.ProgWidgetArea;
import net.minecraft.client.resources.I18n;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;

public abstract class AreaType {
    private final String unlocalizedName;

    public AreaType(String name) {
        this.unlocalizedName = String.format("gui.progWidget.area.type.%s.name", name);
    }

    public String getName() {
        return I18n.func_135052_a((String)this.unlocalizedName, (Object[])new Object[0]);
    }

    public abstract void addArea(Consumer<BlockPos> var1, BlockPos var2, BlockPos var3, int var4, int var5, int var6, int var7, int var8, int var9);

    public boolean isDeterministic() {
        return true;
    }

    public void writeToNBT(NBTTagCompound tag) {
    }

    public void readFromNBT(NBTTagCompound tag) {
    }

    @Deprecated
    public void convertFromLegacy(ProgWidgetArea.EnumAreaType oldAreaType, int typeInfo) {
    }

    public void addUIWidgets(List<AreaTypeWidget> widgets) {
    }

    public static class AreaTypeWidgetEnum<E extends Enum<?>>
    extends AreaTypeWidget {
        public final Class<E> enumClass;
        public final Supplier<E> readAction;
        public final Consumer<E> writeAction;

        public AreaTypeWidgetEnum(String title, Class<E> enumClass, Supplier<E> readAction, Consumer<E> writeAction) {
            super(title);
            this.enumClass = enumClass;
            this.readAction = readAction;
            this.writeAction = writeAction;
        }

        @Override
        public String getCurValue() {
            return ((Enum)this.readAction.get()).toString();
        }
    }

    public static class AreaTypeWidgetInteger
    extends AreaTypeWidget {
        public final Supplier<Integer> readAction;
        public final Consumer<Integer> writeAction;

        public AreaTypeWidgetInteger(String title, Supplier<Integer> readAction, Consumer<Integer> writeAction) {
            super(title);
            this.readAction = readAction;
            this.writeAction = writeAction;
        }

        @Override
        public String getCurValue() {
            return this.readAction.get().toString();
        }
    }

    public static abstract class AreaTypeWidget {
        public final String title;

        public AreaTypeWidget(String title) {
            this.title = title;
        }

        public abstract String getCurValue();
    }

    public static enum EnumAxis {
        X,
        Y,
        Z;

    }
}

