/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.recipes;

import javax.annotation.Nonnull;
import me.desht.pneumaticcraft.api.recipe.IPneumaticRecipeRegistry;
import me.desht.pneumaticcraft.api.recipe.IPressureChamberRecipe;
import me.desht.pneumaticcraft.api.recipe.IThermopneumaticProcessingPlantRecipe;
import me.desht.pneumaticcraft.api.recipe.ItemIngredient;
import me.desht.pneumaticcraft.common.item.ItemAssemblyProgram;
import me.desht.pneumaticcraft.common.recipes.AmadronOffer;
import me.desht.pneumaticcraft.common.recipes.AmadronOfferManager;
import me.desht.pneumaticcraft.common.recipes.AssemblyRecipe;
import me.desht.pneumaticcraft.common.recipes.BasicThermopneumaticProcessingPlantRecipe;
import me.desht.pneumaticcraft.common.recipes.ExplosionCraftingRecipe;
import me.desht.pneumaticcraft.common.recipes.HeatFrameCoolingRecipe;
import me.desht.pneumaticcraft.common.recipes.PlasticMixerRegistry;
import me.desht.pneumaticcraft.common.recipes.PressureChamberRecipe;
import me.desht.pneumaticcraft.common.recipes.RefineryRecipe;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import org.apache.commons.lang3.Validate;

public class PneumaticRecipeRegistry
implements IPneumaticRecipeRegistry {
    private static final PneumaticRecipeRegistry INSTANCE = new PneumaticRecipeRegistry();

    public static PneumaticRecipeRegistry getInstance() {
        return INSTANCE;
    }

    @Override
    public void registerThermopneumaticProcessingPlantRecipe(IThermopneumaticProcessingPlantRecipe recipe) {
        Validate.notNull((Object)recipe);
        BasicThermopneumaticProcessingPlantRecipe.recipes.add(recipe);
    }

    @Override
    public void registerThermopneumaticProcessingPlantRecipe(FluidStack requiredFluid, @Nonnull ItemStack requiredItem, FluidStack output, double requiredTemperature, float requiredPressure) {
        Validate.notNull((Object)output);
        this.registerThermopneumaticProcessingPlantRecipe(new BasicThermopneumaticProcessingPlantRecipe(requiredFluid, requiredItem, output, requiredTemperature, requiredPressure));
    }

    @Override
    public void addAssemblyDrillRecipe(Object input, Object output) {
        Validate.notNull((Object)input);
        Validate.notNull((Object)output);
        AssemblyRecipe.drillRecipes.add(new AssemblyRecipe(PneumaticRecipeRegistry.getStackFromObject(input), PneumaticRecipeRegistry.getStackFromObject(output), ItemAssemblyProgram.getStackForProgramType(0, 1)));
    }

    @Override
    public void addAssemblyLaserRecipe(Object input, Object output) {
        Validate.notNull((Object)input);
        Validate.notNull((Object)output);
        AssemblyRecipe.laserRecipes.add(new AssemblyRecipe(PneumaticRecipeRegistry.getStackFromObject(input), PneumaticRecipeRegistry.getStackFromObject(output), ItemAssemblyProgram.getStackForProgramType(1, 1)));
    }

    @Override
    public void registerPressureChamberRecipe(ItemIngredient[] input, float pressureRequired, ItemStack[] output) {
        Validate.notNull((Object)input);
        Validate.notNull((Object)output);
        PressureChamberRecipe.recipes.add(new PressureChamberRecipe.SimpleRecipe(input, pressureRequired, output));
    }

    @Override
    public void registerPressureChamberRecipe(IPressureChamberRecipe recipe) {
        Validate.notNull((Object)recipe);
        PressureChamberRecipe.recipes.add(recipe);
    }

    private static ItemStack getStackFromObject(Object object) {
        if (object instanceof Block) {
            return new ItemStack((Block)object);
        }
        if (object instanceof Item) {
            return new ItemStack((Item)object);
        }
        if (object instanceof ItemStack) {
            return (ItemStack)object;
        }
        throw new IllegalArgumentException("object needs to be of type Block, Item or ItemStack");
    }

    @Override
    public void registerExplosionCraftingRecipe(ItemStack input, ItemStack output, int lossRate) {
        ExplosionCraftingRecipe.recipes.add(new ExplosionCraftingRecipe(input, output, lossRate));
    }

    @Override
    public void registerExplosionCraftingRecipe(String oreDictKey, ItemStack output, int lossRate) {
        ExplosionCraftingRecipe.recipes.add(new ExplosionCraftingRecipe(oreDictKey, output, lossRate));
    }

    private static String makeKey(ItemStack stack) {
        return stack.func_77973_b().getRegistryName() + ":" + stack.func_77960_j();
    }

    @Override
    public void registerDefaultStaticAmadronOffer(Object input, Object output) {
        AmadronOffer offer = new AmadronOffer(input, output);
        AmadronOfferManager.getInstance().addStaticOffer(offer);
    }

    @Override
    public void registerDefaultPeriodicAmadronOffer(Object input, Object output) {
        AmadronOffer offer = new AmadronOffer(input, output);
        AmadronOfferManager.getInstance().addPeriodicOffer(offer);
    }

    @Override
    public void registerHeatFrameCoolRecipe(ItemIngredient input, ItemStack output) {
        HeatFrameCoolingRecipe.recipes.add(new HeatFrameCoolingRecipe(input, output));
    }

    @Override
    public void registerRefineryRecipe(FluidStack input, FluidStack ... outputs) {
        this.registerRefineryRecipe(373, input, outputs);
    }

    @Override
    public void registerRefineryRecipe(int minimumTemperature, FluidStack input, FluidStack ... outputs) {
        RefineryRecipe.recipes.add(new RefineryRecipe(minimumTemperature, input, outputs));
    }

    @Override
    public void registerPlasticMixerRecipe(FluidStack fluidPlastic, ItemStack solidPlastic, int temperature, boolean allowMelting, boolean allowSolidifying) {
        PlasticMixerRegistry.INSTANCE.addPlasticMixerRecipe(fluidPlastic, solidPlastic, temperature, allowMelting, allowSolidifying, true, -1);
    }

    @Override
    public void registerPlasticMixerRecipe(FluidStack fluidPlastic, ItemStack solidPlastic, int temperature, boolean allowMelting, boolean allowSolidifying, boolean useDye, int meta) {
        PlasticMixerRegistry.INSTANCE.addPlasticMixerRecipe(fluidPlastic, solidPlastic, temperature, allowMelting, allowSolidifying, useDye, meta);
    }
}

