/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.recipes;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import me.desht.pneumaticcraft.api.recipe.IPressureChamberRecipe;
import me.desht.pneumaticcraft.api.recipe.ItemIngredient;
import me.desht.pneumaticcraft.common.util.ItemStackHandlerIterable;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.items.ItemStackHandler;

public class PressureChamberRecipe {
    public static final List<IPressureChamberRecipe> recipes = new ArrayList<IPressureChamberRecipe>();

    public static class SimpleRecipe
    implements IPressureChamberRecipe {
        private final float pressureRequired;
        private final List<ItemIngredient> input;
        private final NonNullList<ItemStack> output;

        public SimpleRecipe(ItemIngredient[] input, float pressureRequired, ItemStack[] output) {
            this.input = Arrays.asList(input);
            this.output = NonNullList.func_193580_a((Object)ItemStack.field_190927_a, (Object[])output);
            this.pressureRequired = pressureRequired;
        }

        @Override
        public float getCraftingPressure() {
            return this.pressureRequired;
        }

        @Override
        public boolean isValidRecipe(@Nonnull ItemStackHandler chamberHandler) {
            for (ItemIngredient ingredient : this.input) {
                int amount = this.getFilteredChamberContents(chamberHandler, ingredient).mapToInt(ItemStack::func_190916_E).sum();
                if (amount >= ingredient.getItemAmount()) continue;
                return false;
            }
            return true;
        }

        private Stream<ItemStack> getFilteredChamberContents(ItemStackHandler itemsInChamber, ItemIngredient ingredient) {
            return new ItemStackHandlerIterable(itemsInChamber).stream().filter(stack -> !stack.func_190926_b() && ingredient.isItemEqual((ItemStack)stack));
        }

        @Override
        public List<ItemIngredient> getInput() {
            return this.input;
        }

        @Override
        public NonNullList<ItemStack> getResult() {
            return this.output;
        }

        @Override
        @Nonnull
        public NonNullList<ItemStack> craftRecipe(@Nonnull ItemStackHandler chamberHandler) {
            for (ItemIngredient ingredient : this.input) {
                ItemStack itemInChamber;
                int amountLeft = ingredient.getItemAmount();
                for (int i = 0; !(i >= chamberHandler.getSlots() || ingredient.isItemEqual(itemInChamber = chamberHandler.getStackInSlot(i)) && (amountLeft -= chamberHandler.extractItem(i, amountLeft, false).func_190916_E()) <= 0); ++i) {
                }
            }
            return this.output;
        }
    }
}

