/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.recipes;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class RefineryRecipe {
    public static final int MAX_OUTPUTS = 4;
    public static final List<RefineryRecipe> recipes = new ArrayList<RefineryRecipe>();
    public final FluidStack input;
    public final FluidStack[] outputs;
    private final int minimumTemp;

    public RefineryRecipe(int minimumTemp, FluidStack input, FluidStack[] outputs) {
        this.minimumTemp = minimumTemp;
        if (outputs.length < 2 || outputs.length > 4) {
            throw new IllegalArgumentException("Recipe must have between 2 and 4 (inclusive) outputs");
        }
        this.input = input;
        this.outputs = outputs;
    }

    public int getMinimumTemp() {
        return this.minimumTemp;
    }

    public static Optional<RefineryRecipe> getRecipe(Fluid input, int size) {
        if (input == null || size <= 0) {
            return Optional.empty();
        }
        return recipes.stream().filter(r -> r.outputs.length <= size && r.input.getFluid().equals(input)).min((r1, r2) -> Integer.compare(r2.outputs.length, r1.outputs.length));
    }
}

