/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.remote;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.desht.pneumaticcraft.client.gui.widget.IGuiWidget;
import me.desht.pneumaticcraft.common.remote.ActionWidget;
import me.desht.pneumaticcraft.common.remote.ActionWidgetButton;
import me.desht.pneumaticcraft.common.remote.ActionWidgetCheckBox;
import me.desht.pneumaticcraft.common.remote.ActionWidgetDropdown;
import me.desht.pneumaticcraft.common.remote.ActionWidgetLabel;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class RemoteLayout {
    private final List<ActionWidget> actionWidgets = new ArrayList<ActionWidget>();
    private static final Map<String, Class<? extends ActionWidget>> registeredWidgets = new HashMap<String, Class<? extends ActionWidget>>();

    private static void registerWidget(Class<? extends ActionWidget> widgetClass) {
        try {
            ActionWidget widget = widgetClass.newInstance();
            registeredWidgets.put(widget.getId(), widgetClass);
            return;
        }
        catch (IllegalAccessException | InstantiationException e) {
            e.printStackTrace();
            throw new IllegalArgumentException("Widget " + widgetClass + " couldn't be registered");
        }
    }

    public RemoteLayout(ItemStack remote, int guiLeft, int guiTop) {
        NBTTagCompound tag = remote.func_77978_p();
        if (tag != null) {
            NBTTagList tagList = tag.func_150295_c("actionWidgets", 10);
            for (int i = 0; i < tagList.func_74745_c(); ++i) {
                NBTTagCompound widgetTag = tagList.func_150305_b(i);
                String id = widgetTag.func_74779_i("id");
                Class<? extends ActionWidget> clazz = registeredWidgets.get(id);
                try {
                    ActionWidget widget = clazz.newInstance();
                    widget.readFromNBT(widgetTag, guiLeft, guiTop);
                    this.actionWidgets.add(widget);
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public NBTTagCompound toNBT(int guiLeft, int guiTop) {
        NBTTagCompound tag = new NBTTagCompound();
        NBTTagList tagList = new NBTTagList();
        for (ActionWidget actionWidget : this.actionWidgets) {
            tagList.func_74742_a((NBTBase)actionWidget.toNBT(guiLeft, guiTop));
        }
        tag.func_74782_a("actionWidgets", (NBTBase)tagList);
        return tag;
    }

    public void addWidget(ActionWidget widget) {
        this.actionWidgets.add(widget);
    }

    public List<ActionWidget> getActionWidgets() {
        return this.actionWidgets;
    }

    public List<IGuiWidget> getWidgets(boolean filterDisabledWidgets) {
        ArrayList<IGuiWidget> widgets = new ArrayList<IGuiWidget>();
        for (ActionWidget actionWidget : this.actionWidgets) {
            if (filterDisabledWidgets && !actionWidget.isEnabled()) continue;
            widgets.add((IGuiWidget)actionWidget.getWidget());
        }
        return widgets;
    }

    static {
        RemoteLayout.registerWidget(ActionWidgetCheckBox.class);
        RemoteLayout.registerWidget(ActionWidgetLabel.class);
        RemoteLayout.registerWidget(ActionWidgetButton.class);
        RemoteLayout.registerWidget(ActionWidgetDropdown.class);
    }
}

