/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.semiblock;

import me.desht.pneumaticcraft.common.network.DescSynced;
import me.desht.pneumaticcraft.common.semiblock.IDirectionalSemiblock;
import me.desht.pneumaticcraft.common.semiblock.ISemiBlock;
import me.desht.pneumaticcraft.common.semiblock.SemiBlockBasic;
import me.desht.pneumaticcraft.common.semiblock.SemiBlockManager;
import me.desht.pneumaticcraft.common.util.IOHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class SemiBlockTransferGadget
extends SemiBlockBasic<TileEntity>
implements IDirectionalSemiblock {
    private static final int TRANSFER_INTERVAL = 40;
    public static final String ID = "transfer_gadget";
    @DescSynced
    private EnumInputOutput io;
    @DescSynced
    private EnumFacing facing;
    private SemiBlockTransferGadget connectedGadget;
    private int counter;

    public SemiBlockTransferGadget() {
        super(TileEntity.class);
    }

    @Override
    public boolean canStay() {
        return super.canStay() && this.getConnectedGadget() != null && (!this.isAir() || !this.getConnectedGadget().isAir());
    }

    @Override
    public void addDrops(NonNullList<ItemStack> drops) {
        if (this.io == EnumInputOutput.INPUT) {
            super.addDrops(drops);
        }
    }

    @Override
    public void prePlacement(EntityPlayer player, ItemStack stack, EnumFacing facing) {
        super.prePlacement(player, stack, facing);
        this.io = EnumInputOutput.INPUT;
        this.facing = facing;
    }

    @Override
    public void onPlaced(EntityPlayer player, ItemStack stack, EnumFacing facing) {
        super.onPlaced(player, stack, facing);
        this.connectedGadget = new SemiBlockTransferGadget();
        this.connectedGadget.facing = this.facing.func_176734_d();
        this.connectedGadget.io = EnumInputOutput.OUTPUT;
        SemiBlockManager.getInstance(this.world).addSemiBlock(this.world, this.pos.func_177972_a(this.facing), this.connectedGadget);
    }

    @Override
    public boolean onRightClickWithConfigurator(EntityPlayer player, EnumFacing side) {
        if (this.getFacing() == side) {
            this.toggleIO();
            this.getConnectedGadget().toggleIO();
            return true;
        }
        return super.onRightClickWithConfigurator(player, side);
    }

    private void toggleIO() {
        this.io = this.io == EnumInputOutput.INPUT ? EnumInputOutput.OUTPUT : EnumInputOutput.INPUT;
    }

    @Override
    public boolean canCoexistInSameBlock(ISemiBlock semiBlock) {
        return semiBlock instanceof SemiBlockTransferGadget && ((SemiBlockTransferGadget)semiBlock).facing != this.facing;
    }

    private SemiBlockTransferGadget getConnectedGadget() {
        if (this.connectedGadget == null || this.connectedGadget.isInvalid()) {
            this.connectedGadget = SemiBlockManager.getInstance(this.world).getSemiBlocks(SemiBlockTransferGadget.class, this.world, this.pos.func_177972_a(this.facing)).filter(gadget -> gadget.facing == this.facing.func_176734_d()).findFirst().orElse(null);
        }
        return this.connectedGadget;
    }

    @Override
    public void update() {
        super.update();
        if (!this.world.field_72995_K && !this.isInvalid() && this.io == EnumInputOutput.INPUT && ++this.counter >= 40) {
            this.counter = 0;
            this.transfer();
        }
    }

    private void transfer() {
        Object inputTE = this.getTileEntity();
        Object outputTE = this.getConnectedGadget().getTileEntity();
        if (inputTE == null || outputTE == null) {
            return;
        }
        this.tryTransferItem((TileEntity)inputTE, (TileEntity)outputTE);
        this.tryTransferFluid((TileEntity)inputTE, (TileEntity)outputTE);
    }

    private void tryTransferItem(TileEntity inputTE, TileEntity outputTE) {
        IItemHandler input = (IItemHandler)inputTE.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, this.facing);
        IItemHandler output = (IItemHandler)outputTE.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, this.facing.func_176734_d());
        IOHelper.transferOneItem(input, output);
    }

    private void tryTransferFluid(TileEntity inputTE, TileEntity outputTE) {
        IFluidHandler input = (IFluidHandler)inputTE.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, this.facing);
        IFluidHandler output = (IFluidHandler)outputTE.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, this.facing.func_176734_d());
        if (input != null && output != null) {
            FluidUtil.tryFluidTransfer((IFluidHandler)output, (IFluidHandler)input, (int)100, (boolean)true);
        }
    }

    @Override
    public EnumFacing getFacing() {
        return this.facing;
    }

    public EnumInputOutput getInputOutput() {
        return this.io;
    }

    @Override
    public void writeToNBT(NBTTagCompound tag) {
        super.writeToNBT(tag);
        tag.func_74768_a("counter", this.counter);
        tag.func_74774_a("facing", (byte)this.facing.ordinal());
        tag.func_74757_a("input", this.io == EnumInputOutput.INPUT);
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
        super.readFromNBT(tag);
        this.counter = tag.func_74762_e("counter");
        this.facing = EnumFacing.field_82609_l[tag.func_74771_c("facing")];
        this.io = tag.func_74767_n("input") ? EnumInputOutput.INPUT : EnumInputOutput.OUTPUT;
    }

    public static enum EnumInputOutput {
        INPUT,
        OUTPUT;

    }
}

