/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.thirdparty.immersiveengineering;

import blusunrize.immersiveengineering.common.util.IEDamageSources;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import me.desht.pneumaticcraft.api.item.IItemRegistry;
import me.desht.pneumaticcraft.common.entity.living.EntityDrone;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketPlaySound;
import me.desht.pneumaticcraft.common.network.PacketSpawnParticle;
import me.desht.pneumaticcraft.common.pneumatic_armor.CommonArmorHandler;
import me.desht.pneumaticcraft.lib.EnumCustomParticleType;
import me.desht.pneumaticcraft.lib.Sounds;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.SoundCategory;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class ElectricAttackHandler {
    private static final Map<UUID, Long> sounds = new HashMap<UUID, Long>();

    @SubscribeEvent
    public static void onElectricalAttack(LivingHurtEvent event) {
        EntityPlayer player;
        CommonArmorHandler handler;
        if (!(event.getSource() instanceof IEDamageSources.ElectricDamageSource)) {
            return;
        }
        if (event.getEntityLiving() instanceof EntityDrone) {
            EntityDrone drone = (EntityDrone)event.getEntityLiving();
            float dmg = event.getAmount();
            int sec = drone.getUpgrades(IItemRegistry.EnumUpgrade.SECURITY);
            if (sec > 0) {
                drone.addAir(ItemStack.field_190927_a, (int)(-50.0f * dmg));
                event.setAmount(0.0f);
                double dy = Math.min((double)(dmg / 4.0f), 0.5);
                NetworkHandler.sendToAllAround(new PacketSpawnParticle(EnumCustomParticleType.AIR_PARTICLE, drone.field_70165_t, drone.field_70163_u, drone.field_70161_v, 0.0, -dy, 0.0, (int)dmg, 0.0, 0.0, 0.0), drone.field_70170_p);
                ElectricAttackHandler.playLeakSound((Entity)drone);
            }
        } else if (event.getEntityLiving() instanceof EntityPlayer && (handler = CommonArmorHandler.getHandlerForPlayer(player = (EntityPlayer)event.getEntityLiving())).getUpgradeCount(EntityEquipmentSlot.CHEST, IItemRegistry.EnumUpgrade.SECURITY) > 0 && (double)handler.getArmorPressure(EntityEquipmentSlot.CHEST) > 0.1 && handler.isArmorReady(EntityEquipmentSlot.CHEST)) {
            handler.addAir(EntityEquipmentSlot.CHEST, (int)(-150.0f * event.getAmount()));
            float sx = player.func_70681_au().nextFloat() * 1.5f - 0.75f;
            float sz = player.func_70681_au().nextFloat() * 1.5f - 0.75f;
            double dy = Math.min((double)(event.getAmount() / 4.0f), 0.5);
            NetworkHandler.sendToAllAround(new PacketSpawnParticle(EnumCustomParticleType.AIR_PARTICLE_DENSE, player.field_70165_t + (double)sx, player.field_70163_u + 1.0, player.field_70161_v + (double)sz, (double)(sx / 4.0f), -dy, (double)(sz / 4.0f)), player.field_70170_p);
            event.setAmount(0.0f);
            ElectricAttackHandler.playLeakSound((Entity)player);
        }
    }

    private static void playLeakSound(Entity e) {
        if (e.field_70170_p.func_82737_E() - sounds.getOrDefault(e.func_110124_au(), 0L) > 16L) {
            NetworkHandler.sendToAllAround(new PacketPlaySound(Sounds.LEAKING_GAS_SOUND, SoundCategory.PLAYERS, e.field_70165_t, e.field_70163_u, e.field_70161_v, 0.5f, 0.7f, true), e.field_70170_p);
            sounds.put(e.func_110124_au(), e.field_70170_p.func_82737_E());
        }
    }
}

