/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.thirdparty.jei;

import java.util.ArrayList;
import java.util.List;
import me.desht.pneumaticcraft.common.block.Blockss;
import me.desht.pneumaticcraft.common.recipes.PlasticMixerRegistry;
import me.desht.pneumaticcraft.common.thirdparty.jei.PneumaticCraftCategory;
import me.desht.pneumaticcraft.common.thirdparty.jei.PositionedStack;
import me.desht.pneumaticcraft.common.thirdparty.jei.ResourceDrawable;
import mezz.jei.api.IJeiHelpers;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.oredict.OreDictionary;

public class JEIPlasticMixerCategory
extends PneumaticCraftCategory<PlasticMixerRecipeWrapper> {
    public JEIPlasticMixerCategory(IJeiHelpers jeiHelpers) {
        super(jeiHelpers);
    }

    public String getUid() {
        return "pneumaticcraft.plastic_mixer";
    }

    public String getTitle() {
        return I18n.func_135052_a((String)(Blockss.PLASTIC_MIXER.func_149739_a() + ".name"), (Object[])new Object[0]);
    }

    @Override
    public ResourceDrawable getGuiTexture() {
        return new ResourceDrawable("pneumaticcraft:textures/gui/gui_plastic_mixer.png", 0, 0, 6, 3, 166, 79);
    }

    List<PneumaticCraftCategory.MultipleInputOutputRecipeWrapper> getAllRecipes() {
        ArrayList<PneumaticCraftCategory.MultipleInputOutputRecipeWrapper> recipes = new ArrayList<PneumaticCraftCategory.MultipleInputOutputRecipeWrapper>();
        for (PlasticMixerRegistry.PlasticMixerRecipe plasticMixerRecipe : PlasticMixerRegistry.INSTANCE.allRecipes()) {
            int i;
            if (plasticMixerRecipe.getFluidStack().amount <= 0 || plasticMixerRecipe.getItemStack().func_190926_b()) continue;
            int numSubTypes = plasticMixerRecipe.getNumSubTypes();
            if (plasticMixerRecipe.allowSolidifying()) {
                for (i = 0; i < numSubTypes; ++i) {
                    if (plasticMixerRecipe.getMeta() >= 0 && plasticMixerRecipe.getMeta() != i) continue;
                    recipes.add(new PlasticMixerRecipeWrapper(plasticMixerRecipe.getFluidStack(), new ItemStack(plasticMixerRecipe.getItemStack().func_77973_b(), 1, i)));
                }
            }
            if (!plasticMixerRecipe.allowMelting()) continue;
            for (i = 0; i < numSubTypes; ++i) {
                if (plasticMixerRecipe.getMeta() >= 0 && plasticMixerRecipe.getMeta() != i) continue;
                recipes.add(new PlasticMixerRecipeWrapper(new ItemStack(plasticMixerRecipe.getItemStack().func_77973_b(), 1, i), plasticMixerRecipe.getFluidStack(), plasticMixerRecipe.getTemperature()));
            }
        }
        return recipes;
    }

    static class PlasticMixerRecipeWrapper
    extends PneumaticCraftCategory.MultipleInputOutputRecipeWrapper {
        private final boolean solidify;

        private PlasticMixerRecipeWrapper(ItemStack input, FluidStack output, int temperature) {
            this.addOutputLiquid(output, 146, 11);
            this.addIngredient(new PositionedStack(input, 92, 23));
            this.setUsedTemperature(76, 22, temperature);
            this.solidify = false;
        }

        private PlasticMixerRecipeWrapper(FluidStack input, ItemStack output) {
            this.addInputLiquid(input, 146, 11);
            this.addIngredient(new PositionedStack(this.getDye("dyeRed", 1), 122, 17));
            this.addIngredient(new PositionedStack(this.getDye("dyeGreen", 2), 122, 35));
            this.addIngredient(new PositionedStack(this.getDye("dyeBlue", 4), 122, 53));
            this.addOutput(new PositionedStack(output, 92, 55));
            this.solidify = true;
        }

        private ItemStack getDye(String oreDictName, int fallbackMeta) {
            NonNullList entries = OreDictionary.getOres((String)oreDictName);
            return entries.isEmpty() ? new ItemStack(Items.field_151100_aR, 1, fallbackMeta) : (ItemStack)entries.get(0);
        }

        @Override
        public void drawInfo(Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
            super.drawInfo(minecraft, recipeWidth, recipeHeight, mouseX, mouseY);
            String s = this.solidify ? "Solidify" : "Melt";
            minecraft.field_71466_p.func_78276_b(s, 1, 0, -12566464);
        }
    }
}

