/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.thirdparty.toughasnails;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import me.desht.pneumaticcraft.api.heat.IHeatExchangerLogic;
import me.desht.pneumaticcraft.api.tileentity.IHeatExchanger;
import me.desht.pneumaticcraft.common.config.ConfigHandler;
import me.desht.pneumaticcraft.common.tileentity.TileEntityAirCompressor;
import me.desht.pneumaticcraft.common.tileentity.TileEntityHeatSink;
import me.desht.pneumaticcraft.common.tileentity.TileEntityLiquidCompressor;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import toughasnails.api.temperature.IModifierMonitor;
import toughasnails.api.temperature.ITemperatureModifier;
import toughasnails.api.temperature.Temperature;

public class TANModifierPNCBlock
implements ITemperatureModifier {
    private static final PosCache modifierCache = new PosCache();

    public Temperature applyEnvironmentModifiers(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull Temperature initialTemperature, @Nonnull IModifierMonitor monitor) {
        if (ConfigHandler.integration.tanHeatDivider == 0.0f) {
            return initialTemperature;
        }
        if (world.func_82737_E() % (long)ConfigHandler.integration.tanRefreshInterval == 0L) {
            TANModifierPNCBlock.modifierCache.prune(world);
        }
        Temperature res = new Temperature(initialTemperature.getRawValue() + Math.round(TANModifierPNCBlock.modifierCache.getModifier(world, pos)));
        monitor.addEntry(new IModifierMonitor.Context(this.getId(), "PneumaticCraft Heat Sources", initialTemperature, res));
        return res;
    }

    public Temperature applyPlayerModifiers(@Nonnull EntityPlayer player, @Nonnull Temperature initialTemperature, @Nonnull IModifierMonitor monitor) {
        return initialTemperature;
    }

    public boolean isPlayerSpecific() {
        return false;
    }

    @Nonnull
    public String getId() {
        return "pneumaticcraft:temperature";
    }

    private static float getModifierAt(World world, BlockPos pos) {
        float blockTemperatureModifier = 0.0f;
        Vec3d vec = new Vec3d((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5);
        BlockPos.MutableBlockPos pos2 = new BlockPos.MutableBlockPos(pos);
        for (int x = -3; x <= 3; ++x) {
            for (int y = -2; y <= 2; ++y) {
                for (int z = -3; z <= 3; ++z) {
                    pos2.func_181079_c(pos.func_177958_n() + x, pos.func_177956_o() + y, pos.func_177952_p() + z);
                    TileEntity te = world.func_175625_s((BlockPos)pos2);
                    if (te instanceof IHeatExchanger) {
                        EnumFacing side;
                        float div3 = 1.0f;
                        if (te instanceof TileEntityHeatSink) {
                            side = null;
                            div3 = 0.1f;
                        } else {
                            Vec3d vec2 = new Vec3d((double)pos2.func_177958_n() + 0.5, (double)pos2.func_177956_o() + 0.5, (double)pos2.func_177952_p() + 0.5);
                            RayTraceResult rtr = new AxisAlignedBB((BlockPos)pos2).func_72327_a(vec, vec2);
                            side = rtr == null ? null : rtr.field_178784_b;
                        }
                        IHeatExchangerLogic logic = ((IHeatExchanger)te).getHeatExchangerLogic(side);
                        if (logic != null && (logic.getTemperature() > 308.0 || logic.getTemperature() < 273.0)) {
                            float div = Math.max(1, Math.abs(x) + Math.abs(y) + Math.abs(z));
                            float div2 = side != null && world.func_175623_d(pos2.func_177972_a(side)) ? 1.0f : 3.0f;
                            float mod = (float)(logic.getTemperature() - 273.0) / (ConfigHandler.integration.tanHeatDivider * div * div2 * div3);
                            if (Math.abs(mod) > Math.abs(blockTemperatureModifier)) {
                                blockTemperatureModifier = mod;
                            }
                        }
                    }
                    if ((!(te instanceof TileEntityAirCompressor) || !((TileEntityAirCompressor)te).isActive()) && (!(te instanceof TileEntityLiquidCompressor) || !((TileEntityLiquidCompressor)te).isProducing)) continue;
                    blockTemperatureModifier += 3.0f;
                }
            }
        }
        return blockTemperatureModifier;
    }

    private static class PosCache {
        private final Map<Integer, Map<BlockPos, TimeAndModifier>> cache = new HashMap<Integer, Map<BlockPos, TimeAndModifier>>();

        private PosCache() {
        }

        private void prune(World world) {
            Map<BlockPos, TimeAndModifier> posMap = this.cache.get(world.field_73011_w.getDimension());
            if (posMap != null) {
                long now = world.func_82737_E();
                posMap.entrySet().removeIf(entry -> now - ((TimeAndModifier)entry.getValue()).ticks > (long)ConfigHandler.integration.tanRefreshInterval);
            }
        }

        private float getModifier(World world, BlockPos pos) {
            Map posMap = this.cache.computeIfAbsent(world.field_73011_w.getDimension(), k -> new HashMap());
            TimeAndModifier tm = (TimeAndModifier)posMap.get(pos);
            if (tm == null) {
                float modifier = TANModifierPNCBlock.getModifierAt(world, pos);
                posMap.put(pos, new TimeAndModifier(world.func_82737_E(), modifier));
                return modifier;
            }
            return tm.modifier;
        }
    }

    private static class TimeAndModifier {
        private final long ticks;
        private final float modifier;

        private TimeAndModifier(long ticks, float modifier) {
            this.ticks = ticks;
            this.modifier = modifier;
        }
    }
}

