/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.tileentity;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.desht.pneumaticcraft.client.gui.GuiButtonSpecial;
import me.desht.pneumaticcraft.common.block.BlockPneumaticCraft;
import me.desht.pneumaticcraft.common.tileentity.ISideConfigurable;
import me.desht.pneumaticcraft.common.tileentity.TileEntityBase;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.Validate;

public class SideConfigurator<T>
implements INBTSerializable<NBTTagCompound> {
    private final List<ConnectionEntry<T>> entries = new ArrayList<ConnectionEntry<T>>();
    private final String id;
    private final ISideConfigurable sideConfigurable;
    private final int baseButtonID;
    private final Map<String, Integer> idxMap = new HashMap<String, Integer>();
    private T nullFaceHandler = null;
    private final byte[] faces = new byte[RelativeFace.values().length];
    private final byte[] defaultFaces = new byte[RelativeFace.values().length];
    private final RelativeFace[][] facingMatrix = new RelativeFace[4][];

    SideConfigurator(String id, ISideConfigurable sideConfigurable, int baseButtonID) {
        this.id = id;
        this.sideConfigurable = sideConfigurable;
        this.baseButtonID = baseButtonID;
        this.entries.add(null);
        this.setupFacingMatrix();
    }

    int registerHandler(String id, ItemStack textureStack, Capability<T> cap, T handler, RelativeFace ... defaultRelativeFaces) {
        this.entries.add(new ConnectionEntry(id, textureStack, cap, handler));
        this.idxMap.put(id, this.entries.size() - 1);
        return this.setDefaultSides(defaultRelativeFaces);
    }

    int registerHandler(String id, ResourceLocation texture, Capability<T> cap, T handler, RelativeFace ... defaultRelativeFaces) {
        this.entries.add(new ConnectionEntry(id, texture, cap, handler));
        this.idxMap.put(id, this.entries.size() - 1);
        return this.setDefaultSides(defaultRelativeFaces);
    }

    private int setDefaultSides(RelativeFace ... defaultRelativeFaces) {
        Validate.isTrue((this.entries.size() <= 127 ? 1 : 0) != 0, (String)"No more than 127 entries allowed", (Object[])new Object[0]);
        byte idx = (byte)(this.entries.size() - 1);
        for (RelativeFace relativeFace : defaultRelativeFaces) {
            this.faces[relativeFace.ordinal()] = idx;
            this.defaultFaces[relativeFace.ordinal()] = idx;
        }
        return idx;
    }

    void setNullFaceHandler(String id) {
        this.nullFaceHandler = ((ConnectionEntry)this.entries.get(this.idxMap.get(id))).handler;
    }

    private boolean shouldSaveNBT() {
        return !Arrays.equals(this.faces, this.defaultFaces);
    }

    void updateHandler(String id, T handler) {
        int idx = this.idxMap.get(id);
        ConnectionEntry<T> e = this.entries.get(idx);
        this.entries.set(idx, new ConnectionEntry(((ConnectionEntry)e).id, ((ConnectionEntry)e).texture, ((ConnectionEntry)e).cap, handler));
        this.setNullFaceHandler(id);
    }

    public int getBaseButtonID() {
        return this.baseButtonID;
    }

    public byte[] getFaces() {
        return this.faces;
    }

    public void setFaces(byte[] faces) {
        System.arraycopy(faces, 0, this.faces, 0, this.faces.length);
    }

    public boolean handleButtonPress(int buttonID) {
        if (buttonID >= this.baseButtonID && buttonID < this.baseButtonID + 6) {
            RelativeFace relativeFace = RelativeFace.values()[buttonID - this.baseButtonID];
            this.cycleValue(relativeFace);
            return true;
        }
        return false;
    }

    public int getButtonId(RelativeFace relativeFace) {
        return this.baseButtonID + relativeFace.ordinal();
    }

    private void cycleValue(RelativeFace relativeFace) {
        int idx = relativeFace.ordinal();
        int n = 0;
        while (n++ < this.entries.size()) {
            ConnectionEntry<T> c;
            int n2 = idx;
            this.faces[n2] = (byte)(this.faces[n2] + 1);
            if (this.faces[idx] >= this.entries.size()) {
                this.faces[idx] = 0;
            }
            if (!this.sideConfigurable.isValid(relativeFace, (c = this.entries.get(this.faces[idx])) == null ? null : ((ConnectionEntry)c).cap)) continue;
            return;
        }
    }

    public String getID() {
        return this.id;
    }

    public String getTranslationKey() {
        return "gui.sideConfigurator.title." + this.id;
    }

    T getHandler(EnumFacing facing) {
        if (facing == null) {
            return this.nullFaceHandler;
        }
        ConnectionEntry<T> c = this.entries.get(this.faces[this.getRelativeFace(facing).ordinal()]);
        return (T)(c == null ? null : ((ConnectionEntry)c).handler);
    }

    void setupFacingMatrix() {
        for (EnumFacing f : EnumFacing.field_176754_o) {
            this.facingMatrix[f.func_176736_b()] = new RelativeFace[4];
            for (RelativeFace rf : RelativeFace.HORIZONTALS) {
                EnumFacing f2 = this.rot(f, rf);
                this.facingMatrix[f.func_176736_b()][f2.func_176736_b()] = rf;
            }
        }
    }

    private EnumFacing rot(EnumFacing in, RelativeFace rf) {
        switch (rf) {
            case RIGHT: {
                return in.func_176735_f();
            }
            case LEFT: {
                return in.func_176746_e();
            }
            case BACK: {
                return in.func_176734_d();
            }
        }
        return in;
    }

    private RelativeFace getRelativeFace(EnumFacing facing) {
        if (facing == EnumFacing.UP) {
            return RelativeFace.TOP;
        }
        if (facing == EnumFacing.DOWN) {
            return RelativeFace.BOTTOM;
        }
        return this.facingMatrix[this.sideConfigurable.byIndex().func_176736_b()][facing.func_176736_b()];
    }

    @SideOnly(value=Side.CLIENT)
    public void setupButton(GuiButtonSpecial button) {
        RelativeFace relativeFace = RelativeFace.values()[button.getID() - this.baseButtonID];
        ConnectionEntry<T> c = this.entries.get(this.faces[relativeFace.ordinal()]);
        if (c != null) {
            if (((ConnectionEntry)c).texture instanceof ItemStack) {
                button.setRenderStacks((ItemStack)((ConnectionEntry)c).texture);
                button.setRenderedIcon(null);
            } else if (((ConnectionEntry)c).texture instanceof ResourceLocation) {
                button.setRenderStacks(ItemStack.field_190927_a);
                button.setRenderedIcon((ResourceLocation)((ConnectionEntry)c).texture);
            }
        } else {
            button.setRenderStacks(ItemStack.field_190927_a);
            button.setRenderedIcon(Textures.GUI_X_BUTTON);
        }
        button.setTooltipText(Lists.newArrayList((Object[])new String[]{TextFormatting.YELLOW + relativeFace.toString(), I18n.func_135052_a((String)this.getFaceKey(relativeFace), (Object[])new Object[0])}));
    }

    private String getFaceKey(RelativeFace relativeFace) {
        ConnectionEntry<T> c = this.entries.get(this.faces[relativeFace.ordinal()]);
        return c == null ? "gui.sideConfigurator.unconnected" : "gui.sideConfigurator." + this.id + "." + ((ConnectionEntry)c).id;
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound tag = new NBTTagCompound();
        NBTTagList l = new NBTTagList();
        for (byte face : this.faces) {
            l.func_74742_a((NBTBase)new NBTTagByte(face));
        }
        tag.func_74782_a("faces", (NBTBase)l);
        return tag;
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        NBTTagList l = nbt.func_150295_c("faces", 1);
        for (int i = 0; i < l.func_74745_c() && i < this.faces.length; ++i) {
            this.faces[i] = ((NBTTagByte)l.func_179238_g(i)).func_150290_f();
        }
    }

    public static NBTTagCompound writeToNBT(ISideConfigurable sideConfigurable) {
        NBTTagCompound tag = new NBTTagCompound();
        for (SideConfigurator sc : sideConfigurable.getSideConfigurators()) {
            if (!sc.shouldSaveNBT()) continue;
            NBTTagCompound subtag = sc.serializeNBT();
            tag.func_74782_a(sc.id, (NBTBase)subtag);
        }
        return tag;
    }

    public static void readFromNBT(NBTTagCompound tag, ISideConfigurable sideConfigurable) {
        for (SideConfigurator sc : sideConfigurable.getSideConfigurators()) {
            if (!tag.func_74764_b(sc.id)) continue;
            NBTTagCompound subtag = tag.func_74775_l(sc.id);
            sc.deserializeNBT(subtag);
        }
    }

    static void validateBlockRotation(TileEntityBase te) {
        if (te.getRotation().func_176740_k() == EnumFacing.Axis.Y) {
            IBlockState fixState = te.func_145831_w().func_180495_p(te.func_174877_v()).func_177226_a(BlockPneumaticCraft.ROTATION, (Comparable)EnumFacing.NORTH);
            te.func_145831_w().func_175656_a(te.func_174877_v(), fixState);
        }
    }

    private static class ConnectionEntry<T> {
        private final String id;
        private final Object texture;
        private final Capability<T> cap;
        private final T handler;

        private ConnectionEntry(String id, Object texture, Capability<T> cap, T handler) {
            this.id = id;
            this.texture = texture;
            this.cap = cap;
            this.handler = handler;
        }
    }

    public static enum RelativeFace {
        BOTTOM,
        TOP,
        LEFT,
        RIGHT,
        FRONT,
        BACK;

        public static final RelativeFace[] HORIZONTALS;

        static {
            HORIZONTALS = new RelativeFace[4];
            RelativeFace.HORIZONTALS[0] = LEFT;
            RelativeFace.HORIZONTALS[1] = RIGHT;
            RelativeFace.HORIZONTALS[2] = FRONT;
            RelativeFace.HORIZONTALS[3] = BACK;
        }
    }
}

