/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.tileentity;

import javax.annotation.Nonnull;
import me.desht.pneumaticcraft.common.inventory.handler.BaseItemStackHandler;
import me.desht.pneumaticcraft.common.network.DescSynced;
import me.desht.pneumaticcraft.common.network.LazySynced;
import me.desht.pneumaticcraft.common.recipes.programs.AssemblyProgram;
import me.desht.pneumaticcraft.common.tileentity.IAssemblyMachine;
import me.desht.pneumaticcraft.common.tileentity.IResettable;
import me.desht.pneumaticcraft.common.tileentity.TileEntityAssemblyController;
import me.desht.pneumaticcraft.common.tileentity.TileEntityTickableBase;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.items.ItemStackHandler;

public class TileEntityAssemblyPlatform
extends TileEntityTickableBase
implements IAssemblyMachine,
IResettable {
    @DescSynced
    private boolean shouldClawClose;
    @DescSynced
    @LazySynced
    public float clawProgress;
    public float oldClawProgress;
    @DescSynced
    private final ItemStackHandler inventory = new BaseItemStackHandler(this, 1);
    private float speed = 1.0f;
    private BlockPos controllerPos;

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        this.oldClawProgress = this.clawProgress;
        if (!this.shouldClawClose && this.clawProgress > 0.0f) {
            this.clawProgress = Math.max(this.clawProgress - 0.05f * this.speed, 0.0f);
        } else if (this.shouldClawClose && this.clawProgress < 1.0f) {
            this.clawProgress = Math.min(this.clawProgress + 0.05f * this.speed, 1.0f);
        }
    }

    private boolean isClawDone() {
        return this.clawProgress == (this.shouldClawClose ? 1.0f : 0.0f);
    }

    @Override
    public boolean isIdle() {
        return !this.shouldClawClose && this.isClawDone() && this.getHeldStack().func_190926_b();
    }

    @Override
    public boolean reset() {
        this.openClaw();
        return this.isIdle();
    }

    boolean closeClaw() {
        this.shouldClawClose = true;
        this.sendDescriptionPacket();
        return this.isClawDone();
    }

    boolean openClaw() {
        this.shouldClawClose = false;
        this.sendDescriptionPacket();
        return this.isClawDone();
    }

    @Nonnull
    public ItemStack getHeldStack() {
        return this.inventory.getStackInSlot(0);
    }

    public void setHeldStack(@Nonnull ItemStack stack) {
        this.inventory.setStackInSlot(0, stack);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        tag.func_74757_a("clawClosing", this.shouldClawClose);
        tag.func_74776_a("clawProgress", this.clawProgress);
        tag.func_74776_a("speed", this.speed);
        tag.func_74782_a("Items", (NBTBase)this.inventory.serializeNBT());
        return tag;
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.shouldClawClose = tag.func_74767_n("clawClosing");
        this.clawProgress = tag.func_74760_g("clawProgress");
        this.speed = tag.func_74760_g("speed");
        this.inventory.deserializeNBT(tag.func_74775_l("Items"));
    }

    @Override
    public void setSpeed(float speed) {
        this.speed = speed;
    }

    @Override
    public AssemblyProgram.EnumMachine getAssemblyType() {
        return AssemblyProgram.EnumMachine.PLATFORM;
    }

    @Override
    public void setControllerPos(BlockPos controllerPos) {
        this.controllerPos = controllerPos;
    }

    @Override
    public void onNeighborBlockUpdate() {
        super.onNeighborBlockUpdate();
        this.invalidateSystem();
    }

    private void invalidateSystem() {
        TileEntity te;
        if (this.controllerPos != null && (te = this.func_145831_w().func_175625_s(this.controllerPos)) instanceof TileEntityAssemblyController) {
            ((TileEntityAssemblyController)te).invalidateAssemblySystem();
        }
    }
}

