/*
 * Decompiled with CFR 0.152.
 */
package net.jaspr.base.network.message;

import net.jaspr.base.module.ModuleLoader;
import net.jaspr.base.network.message.NetworkMessage;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class MessageChangeConfig
extends NetworkMessage {
    public String moduleName;
    public String category;
    public String key;
    public String value;
    public boolean saveToFile;

    public MessageChangeConfig() {
    }

    public MessageChangeConfig(String moduleName, String category, String key, String value, boolean saveToFile) {
        this.moduleName = moduleName;
        this.category = category;
        this.key = key;
        this.value = value;
    }

    @Override
    public IMessage handleMessage(MessageContext context) {
        MessageChangeConfig.changeConfig(this.moduleName, this.category, this.key, this.value, this.saveToFile);
        return null;
    }

    public static void changeConfig(String moduleName, String category, String key, String value, boolean saveToFile) {
        Configuration config = ModuleLoader.config;
        String fullCategory = moduleName;
        if (!category.equals("-")) {
            fullCategory = fullCategory + "." + category;
        }
        char type = key.charAt(0);
        if (config.hasKey(fullCategory, key = key.substring(2))) {
            boolean changed = false;
            try {
                switch (type) {
                    case 'B': {
                        boolean b = Boolean.parseBoolean(value);
                        config.get(fullCategory, key, false).setValue(b);
                    }
                    case 'I': {
                        int i = Integer.parseInt(value);
                        config.get(fullCategory, key, 0).setValue(i);
                    }
                    case 'D': {
                        double d = Double.parseDouble(value);
                        config.get(fullCategory, key, 0.0).setValue(d);
                    }
                    case 'S': {
                        config.get(fullCategory, key, "").setValue(value);
                    }
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            if (config.hasChanged()) {
                ModuleLoader.forEachModule(module -> module.setupConfig());
                if (saveToFile) {
                    config.save();
                }
            }
        }
    }
}

