/*
 * Decompiled with CFR 0.152.
 */
package gg.galaxygaming.gasconduits.common.conduit;

import com.enderio.core.common.util.DyeColor;
import crazypants.enderio.base.conduit.ConnectionMode;
import gg.galaxygaming.gasconduits.common.conduit.AbstractGasConduit;
import gg.galaxygaming.gasconduits.common.conduit.ender.EnderGasConduit;
import javax.annotation.Nonnull;
import mekanism.api.gas.IGasHandler;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;

public class NetworkGasTank {
    @Nonnull
    public final EnderGasConduit con;
    @Nonnull
    public final EnumFacing conDir;
    private final IGasHandler externalTank;
    @Nonnull
    private final EnumFacing tankDir;
    @Nonnull
    private final BlockPos conduitLoc;
    private final boolean acceptsOutput;
    private final DyeColor inputColor;
    private final DyeColor outputColor;
    private final int priority;
    private final boolean roundRobin;
    private final boolean selfFeed;

    public NetworkGasTank(@Nonnull EnderGasConduit con, @Nonnull EnumFacing conDir) {
        this.con = con;
        this.conDir = conDir;
        this.conduitLoc = con.getBundle().getLocation();
        this.tankDir = conDir.func_176734_d();
        this.externalTank = AbstractGasConduit.getExternalGasHandler((IBlockAccess)con.getBundle().getBundleworld(), this.conduitLoc.func_177972_a(conDir), this.tankDir);
        this.acceptsOutput = con.getConnectionMode(conDir).acceptsOutput();
        this.inputColor = con.getOutputColor(conDir);
        this.outputColor = con.getInputColor(conDir);
        this.priority = con.getOutputPriority(conDir);
        this.roundRobin = con.isRoundRobinEnabled(conDir);
        this.selfFeed = con.isSelfFeedEnabled(conDir);
    }

    public boolean isValid() {
        return this.externalTank != null && this.con.getConnectionMode(this.conDir) != ConnectionMode.DISABLED;
    }

    public int hashCode() {
        int code = 1;
        code = 31 * code + this.conDir.hashCode();
        code = 31 * code + this.conduitLoc.hashCode();
        return code;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        NetworkGasTank other = (NetworkGasTank)obj;
        if (this.conDir != other.conDir) {
            return false;
        }
        return this.conduitLoc.equals((Object)other.conduitLoc);
    }

    public boolean acceptsOutput() {
        return this.acceptsOutput;
    }

    public DyeColor getInputColor() {
        return this.inputColor;
    }

    public DyeColor getOutputColor() {
        return this.outputColor;
    }

    public int getPriority() {
        return this.priority;
    }

    public boolean isRoundRobin() {
        return this.roundRobin;
    }

    public boolean isSelfFeed() {
        return this.selfFeed;
    }

    public IGasHandler getExternalTank() {
        return this.externalTank;
    }

    public EnumFacing getConduitDir() {
        return this.conDir;
    }

    @Nonnull
    public EnumFacing getTankDir() {
        return this.tankDir;
    }

    @Nonnull
    public BlockPos getConduitLocation() {
        return this.conduitLoc;
    }

    public EnderGasConduit getConduit() {
        return this.con;
    }
}

