/*
 * Decompiled with CFR 0.152.
 */
package gg.galaxygaming.gasconduits.common.conduit.basic;

import com.enderio.core.client.render.BoundingBox;
import com.enderio.core.client.render.RenderUtil;
import com.enderio.core.common.util.NNList;
import com.enderio.core.common.vecmath.Vector3d;
import com.enderio.core.common.vecmath.Vector4f;
import com.enderio.core.common.vecmath.Vertex;
import crazypants.enderio.base.conduit.IClientConduit;
import crazypants.enderio.base.conduit.IConduit;
import crazypants.enderio.base.conduit.IConduitTexture;
import crazypants.enderio.base.conduit.geom.CollidableComponent;
import crazypants.enderio.base.conduit.geom.ConduitGeometryUtil;
import crazypants.enderio.conduits.render.DefaultConduitRenderer;
import gg.galaxygaming.gasconduits.client.utils.GasRenderUtil;
import gg.galaxygaming.gasconduits.common.conduit.basic.GasConduit;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.gas.Gas;
import mekanism.api.gas.GasStack;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;

public class GasConduitRenderer
extends DefaultConduitRenderer
implements IResourceManagerReloadListener {
    private static Map<CollidableComponent, Map<Gas, List<CachableRenderStatement>>> cache = new WeakHashMap<CollidableComponent, Map<Gas, List<CachableRenderStatement>>>();

    private GasConduitRenderer() {
    }

    @Nonnull
    public static GasConduitRenderer create() {
        GasConduitRenderer result = new GasConduitRenderer();
        RenderUtil.registerReloadListener((IResourceManagerReloadListener)result);
        return result;
    }

    public boolean isRendererForConduit(@Nonnull IConduit conduit) {
        return conduit instanceof GasConduit;
    }

    protected void addTransmissionQuads(@Nonnull IConduitTexture tex, Vector4f color, @Nonnull BlockRenderLayer layer, @Nonnull IConduit conduit, @Nonnull CollidableComponent component, float selfIllum, @Nonnull List<BakedQuad> quads) {
    }

    protected void renderConduitDynamic(@Nonnull IConduitTexture tex, @Nonnull IClientConduit.WithDefaultRendering conduit, @Nonnull CollidableComponent component, float brightness) {
        GasConduit lc;
        GasStack gas;
        if (component.isDirectional() && (gas = (lc = (GasConduit)conduit).getGasType()) != null) {
            GasConduitRenderer.renderGasOutline(component, gas);
        }
    }

    protected void renderTransmissionDynamic(@Nonnull IConduit conduit, @Nonnull IConduitTexture tex, @Nullable Vector4f color, @Nonnull CollidableComponent component, float selfIllum) {
        BoundingBox[] cubes;
        float filledRatio = ((GasConduit)conduit).getTank().getFilledRatio();
        if (filledRatio <= 0.0f || !component.isDirectional()) {
            return;
        }
        TextureAtlasSprite sprite = tex.getSprite();
        for (BoundingBox cube : cubes = this.toCubes(component.bound)) {
            if (cube == null) continue;
            float shrink = 0.0078125f;
            EnumFacing componentDirection = component.getDirection();
            float xLen = Math.abs(componentDirection.func_82601_c()) == 1 ? 0.0f : shrink;
            float yLen = Math.abs(componentDirection.func_96559_d()) == 1 ? 0.0f : shrink;
            float zLen = Math.abs(componentDirection.func_82599_e()) == 1 ? 0.0f : shrink;
            BoundingBox bb = cube.expand((double)(-xLen), (double)(-yLen), (double)(-zLen));
            this.drawDynamicSection(bb, sprite.func_94214_a((double)(tex.getUv().x * 16.0f)), sprite.func_94214_a((double)(tex.getUv().z * 16.0f)), sprite.func_94207_b((double)(tex.getUv().y * 16.0f)), sprite.func_94207_b((double)(tex.getUv().w * 16.0f)), color, componentDirection, true);
        }
    }

    public static void renderGasOutline(@Nonnull CollidableComponent component, @Nonnull GasStack gas) {
        GasConduitRenderer.renderGasOutline(component, gas, 1.0f - ConduitGeometryUtil.getInstance().getHeight(), 0.0625f);
    }

    public static void renderGasOutline(@Nonnull CollidableComponent component, @Nonnull GasStack gasStack, double scaleFactor, float outlineWidth) {
        Gas gas = gasStack.getGas();
        if (gas != null) {
            GasConduitRenderer.computeGasOutlineToCache(component, gas, scaleFactor, outlineWidth).forEach(CachableRenderStatement::execute);
        }
    }

    public static List<CachableRenderStatement> computeGasOutlineToCache(@Nonnull CollidableComponent component, @Nonnull Gas gas, double scaleFactor, float width) {
        Map cache0 = cache.computeIfAbsent(component, k -> new HashMap());
        ArrayList<CachableRenderStatement> data = (ArrayList<CachableRenderStatement>)cache0.get(gas);
        if (data != null) {
            return data;
        }
        data = new ArrayList<CachableRenderStatement>();
        cache0.put(gas, data);
        TextureAtlasSprite texture = GasRenderUtil.getStillTexture(gas);
        int color = gas.getTint();
        Vector4f colorV = new Vector4f((double)(color >> 16 & 0xFF) / 255.0, (double)(color >> 8 & 0xFF) / 255.0, (double)(color & 0xFF) / 255.0, 1.0);
        EnumFacing componentDirection = component.getDirection();
        double xScale = Math.abs(componentDirection.func_82601_c()) == 1 ? (double)width : (scaleFactor -= 0.05);
        double yScale = Math.abs(componentDirection.func_96559_d()) == 1 ? (double)width : scaleFactor;
        double zScale = Math.abs(componentDirection.func_82599_e()) == 1 ? (double)width : scaleFactor;
        double offSize = (0.5 - (double)width) / 2.0 - (double)(width / 2.0f);
        double xOff = (double)componentDirection.func_82601_c() * offSize;
        double yOff = (double)componentDirection.func_96559_d() * offSize;
        double zOff = (double)componentDirection.func_82599_e() * offSize;
        BoundingBox bbb = component.bound.scale(xScale, yScale, zScale);
        bbb = bbb.translate(new Vector3d(xOff, yOff, zOff));
        NNList.NNIterator itr = NNList.FACING.fastIterator();
        while (itr.hasNext()) {
            EnumFacing face = (EnumFacing)itr.next();
            if (face == componentDirection || face == componentDirection.func_176734_d()) continue;
            NNList corners = bbb.getCornersWithUvForFace(face, texture.func_94209_e(), texture.func_94212_f(), texture.func_94206_g(), texture.func_94210_h());
            for (Vertex corner : corners) {
                data.add(new CachableRenderStatement.AddVertexWithUV(corner.x(), corner.y(), corner.z(), corner.uv.x, corner.uv.y, colorV));
            }
        }
        return data;
    }

    public boolean isDynamic() {
        return true;
    }

    protected void setVerticesForTransmission(@Nonnull BoundingBox bound, @Nonnull EnumFacing id) {
        float scale = 0.7f;
        float xs = id.func_82601_c() == 0 ? scale : 1.0f;
        float ys = id.func_96559_d() == 0 ? scale : 1.0f;
        float zs = id.func_82599_e() == 0 ? scale : 1.0f;
        double sizeY = bound.sizeY();
        bound = bound.scale(xs, ys, zs);
        double transY = (bound.sizeY() - sizeY) / 2.0;
        Vector3d translation = new Vector3d(0.0, transY + 0.025, 0.0);
        this.setupVertices(bound.translate(translation));
    }

    public void func_110549_a(@Nonnull IResourceManager p_110549_1_) {
        cache.clear();
    }

    private static interface CachableRenderStatement {
        public void execute();

        public static class AddVertexWithUV
        implements CachableRenderStatement {
            private final double x;
            private final double y;
            private final double z;
            private final double u;
            private final double v;
            private final Vector4f color;

            private AddVertexWithUV(double x, double y, double z, double u, double v, Vector4f color) {
                this.x = x;
                this.y = y;
                this.z = z;
                this.u = u;
                this.v = v;
                this.color = color;
            }

            @Override
            public void execute() {
                Tessellator.func_178181_a().func_178180_c().func_181662_b(this.x, this.y, this.z).func_187315_a(this.u, this.v).func_181666_a(this.color.x, this.color.y, this.color.z, this.color.w).func_181675_d();
            }
        }
    }
}

