/*
 * Decompiled with CFR 0.152.
 */
package gg.galaxygaming.gasconduits.common.conduit.ender;

import com.enderio.core.common.util.RoundRobinIterator;
import crazypants.enderio.conduits.conduit.AbstractConduitNetwork;
import gg.galaxygaming.gasconduits.common.conduit.IGasConduit;
import gg.galaxygaming.gasconduits.common.conduit.NetworkGasTank;
import gg.galaxygaming.gasconduits.common.conduit.ender.EnderGasConduit;
import gg.galaxygaming.gasconduits.common.config.GasConduitConfig;
import gg.galaxygaming.gasconduits.common.filter.IGasFilter;
import gg.galaxygaming.gasconduits.common.utils.GasUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import mekanism.api.gas.GasStack;
import mekanism.api.gas.GasTankInfo;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;

public class EnderGasConduitNetwork
extends AbstractConduitNetwork<IGasConduit, EnderGasConduit> {
    List<NetworkGasTank> tanks = new ArrayList<NetworkGasTank>();
    Map<NetworkTankKey, NetworkGasTank> tankMap = new HashMap<NetworkTankKey, NetworkGasTank>();
    Map<NetworkGasTank, RoundRobinIterator<NetworkGasTank>> iterators;
    boolean filling;

    public EnderGasConduitNetwork() {
        super(EnderGasConduit.class, IGasConduit.class);
    }

    public void connectionChanged(@Nonnull EnderGasConduit con, @Nonnull EnumFacing conDir) {
        NetworkTankKey key = new NetworkTankKey(con, conDir);
        NetworkGasTank tank = new NetworkGasTank(con, conDir);
        boolean sort = false;
        NetworkGasTank oldTank = this.tankMap.get(key);
        if (oldTank != null && oldTank.getPriority() != tank.getPriority()) {
            sort = true;
        }
        this.tanks.remove(tank);
        this.tankMap.remove(key);
        this.tanks.add(tank);
        this.tankMap.put(key, tank);
        if (sort) {
            this.tanks.sort((arg0, arg1) -> arg1.getPriority() - arg0.getPriority());
        }
    }

    public boolean extractFrom(@Nonnull EnderGasConduit con, @Nonnull EnumFacing conDir) {
        NetworkGasTank tank = this.getTank(con, conDir);
        if (!tank.isValid() || tank.getExternalTank() == null) {
            return false;
        }
        GasStack drained = GasUtil.getGasStack(tank.getExternalTank(), conDir.func_176734_d());
        if (!this.matchedFilter(drained, con, conDir, true) || !tank.getExternalTank().canDrawGas(tank.getConduitDir(), drained.getGas())) {
            return false;
        }
        drained.amount = Math.min(drained.amount, (int)((float)((Integer)GasConduitConfig.tier3_extractRate.get()).intValue() * this.getExtractSpeedMultiplier(tank)));
        int amountAccepted = this.fillFrom(tank, drained.copy(), true);
        if (amountAccepted <= 0) {
            return false;
        }
        drained.amount = amountAccepted;
        drained = tank.getExternalTank().drawGas(tank.getConduitDir(), drained.amount, true);
        return drained != null && drained.amount > 0;
    }

    @Nonnull
    private NetworkGasTank getTank(@Nonnull EnderGasConduit con, @Nonnull EnumFacing conDir) {
        return this.tankMap.get(new NetworkTankKey(con, conDir));
    }

    public int fillFrom(@Nonnull EnderGasConduit con, @Nonnull EnumFacing conDir, GasStack resource, boolean doFill) {
        return this.fillFrom(this.getTank(con, conDir), resource, doFill);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int fillFrom(@Nonnull NetworkGasTank tank, GasStack resource, boolean doFill) {
        if (this.filling) {
            return 0;
        }
        try {
            this.filling = true;
            if (!this.matchedFilter(resource, tank.getConduit(), tank.getConduitDir(), true)) {
                int n = 0;
                return n;
            }
            resource = resource.copy();
            resource.amount = Math.min(resource.amount, (int)((float)((Integer)GasConduitConfig.tier3_maxIO.get()).intValue() * this.getExtractSpeedMultiplier(tank)));
            int filled = 0;
            int remaining = resource.amount;
            for (NetworkGasTank target : this.getIteratorForTank(tank)) {
                if (target.getExternalTank() == null || target.equals(tank) && !tank.isSelfFeed() || !target.acceptsOutput() || !target.isValid() || target.getInputColor() != tank.getOutputColor() || !this.matchedFilter(resource, target.getConduit(), target.getConduitDir(), false) || !target.getExternalTank().canReceiveGas(target.getConduitDir().func_176734_d(), resource.getGas())) continue;
                int vol = target.getExternalTank().receiveGas(target.getConduitDir().func_176734_d(), resource.copy(), doFill);
                filled += vol;
                if ((remaining -= vol) <= 0) {
                    int n = filled;
                    return n;
                }
                resource.amount = remaining;
            }
            int n = filled;
            return n;
        }
        finally {
            if (!tank.isRoundRobin()) {
                this.getIteratorForTank(tank).reset();
            }
            this.filling = false;
        }
    }

    private float getExtractSpeedMultiplier(NetworkGasTank tank) {
        return tank.con.getExtractSpeedMultiplier(tank.conDir);
    }

    private boolean matchedFilter(GasStack drained, @Nonnull EnderGasConduit con, @Nonnull EnumFacing conDir, boolean isInput) {
        if (drained == null) {
            return false;
        }
        IGasFilter filter = con.getFilter(conDir, isInput);
        return filter == null || filter.isEmpty() || filter.matchesFilter(drained);
    }

    private RoundRobinIterator<NetworkGasTank> getIteratorForTank(@Nonnull NetworkGasTank tank) {
        RoundRobinIterator res;
        if (this.iterators == null) {
            this.iterators = new HashMap<NetworkGasTank, RoundRobinIterator<NetworkGasTank>>();
        }
        if ((res = this.iterators.get(tank)) == null) {
            res = new RoundRobinIterator(this.tanks);
            this.iterators.put(tank, (RoundRobinIterator<NetworkGasTank>)res);
        }
        return res;
    }

    public GasTankInfo[] getTankProperties(@Nonnull EnderGasConduit con, @Nonnull EnumFacing conDir) {
        ArrayList<GasTankInfo> res = new ArrayList<GasTankInfo>(this.tanks.size());
        NetworkGasTank tank = this.getTank(con, conDir);
        for (NetworkGasTank target : this.tanks) {
            if (target.equals(tank) || !target.isValid() || target.getExternalTank() == null) continue;
            res.addAll(Arrays.asList(target.getExternalTank().getTankInfo()));
        }
        return res.toArray(new GasTankInfo[0]);
    }

    static class NetworkTankKey {
        EnumFacing conDir;
        BlockPos conduitLoc;

        public NetworkTankKey(@Nonnull EnderGasConduit con, @Nonnull EnumFacing conDir) {
            this(con.getBundle().getLocation(), conDir);
        }

        public NetworkTankKey(@Nonnull BlockPos conduitLoc, @Nonnull EnumFacing conDir) {
            this.conDir = conDir;
            this.conduitLoc = conduitLoc;
        }

        public int hashCode() {
            int code = 1;
            if (this.conDir != null) {
                code = 31 * code + this.conDir.hashCode();
            }
            if (this.conduitLoc != null) {
                code = 31 * code + this.conduitLoc.hashCode();
            }
            return code;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            NetworkTankKey other = (NetworkTankKey)obj;
            if (this.conDir != other.conDir) {
                return false;
            }
            if (this.conduitLoc == null) {
                return other.conduitLoc == null;
            }
            return this.conduitLoc.equals((Object)other.conduitLoc);
        }
    }
}

