/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.client.gui.modulargui.guielements;

import com.brandon3055.brandonscore.client.gui.modulargui.MGuiElementBase;
import com.brandon3055.brandonscore.client.gui.modulargui.guielements.GuiSlotRender;
import com.brandon3055.brandonscore.lib.StackReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;

public class GuiStackIcon
extends MGuiElementBase<GuiStackIcon> {
    public static Map<Integer, ItemStack> stackCache = new HashMap<Integer, ItemStack>();
    public boolean drawCount = true;
    public boolean drawToolTip = true;
    public boolean drawHoverHighlight = false;
    private MGuiElementBase background = null;
    protected List<String> toolTipOverride = null;
    private StackReference stackReference;

    public GuiStackIcon(StackReference stackReference) {
        this.stackReference = stackReference;
        this.setSize(18, 18);
    }

    public GuiStackIcon(int xPos, int yPos, StackReference stackReference) {
        super(xPos, yPos);
        this.stackReference = stackReference;
        this.setSize(18, 18);
    }

    public GuiStackIcon(int xPos, int yPos, int xSize, int ySize, StackReference stackReference) {
        super(xPos, yPos, xSize, ySize);
        this.stackReference = stackReference;
    }

    @Override
    public void renderElement(Minecraft minecraft, int mouseX, int mouseY, float partialTicks) {
        super.renderElement(minecraft, mouseX, mouseY, partialTicks);
        if (this.drawHoverHighlight && this.isMouseOver(mouseX, mouseY)) {
            this.drawColouredRect(this.xPos(), this.yPos(), this.xSize(), this.ySize(), -2130706433);
        }
        GlStateManager.func_179094_E();
        this.renderStack(minecraft);
        GlStateManager.func_179121_F();
    }

    private void renderStack(Minecraft minecraft) {
        RenderHelper.func_74520_c();
        double scaledWidth = (double)this.xSize() / 18.0;
        double scaledHeight = (double)this.ySize() / 18.0;
        GlStateManager.func_179137_b((double)((double)this.xPos() + scaledWidth + (double)this.getInsets().left), (double)((double)this.yPos() + scaledHeight + (double)this.getInsets().top), (double)(this.getRenderZLevel() - 80.0));
        GlStateManager.func_179139_a((double)scaledWidth, (double)scaledHeight, (double)1.0);
        minecraft.func_175599_af().func_175042_a(this.getStack(), 0, 0);
        if (this.getStack().func_77973_b().showDurabilityBar(this.getStack())) {
            double health = this.getStack().func_77973_b().getDurabilityForDisplay(this.getStack());
            int rgbfordisplay = this.getStack().func_77973_b().getRGBDurabilityForDisplay(this.getStack());
            int i = Math.round(13.0f - (float)health * 13.0f);
            GlStateManager.func_179137_b((double)0.0, (double)0.0, (double)(-(this.getRenderZLevel() - 80.0)));
            this.zOffset += 45.0;
            this.drawColouredRect(2.0, 13.0, 13.0, 2.0, -16777216);
            this.drawColouredRect(2.0, 13.0, i, 1.0, rgbfordisplay | 0xFF000000);
            this.zOffset -= 45.0;
            GlStateManager.func_179137_b((double)0.0, (double)0.0, (double)(this.getRenderZLevel() - 80.0));
        }
        if (this.drawCount && this.getStack().func_190916_E() > 1) {
            String s = this.getStack().func_190916_E() + "";
            GlStateManager.func_179137_b((double)0.0, (double)0.0, (double)(-(this.getRenderZLevel() - 80.0)));
            this.zOffset += 45.0;
            this.drawString(this.fontRenderer, s, (float)((double)this.xSize() / scaledWidth) - (float)this.fontRenderer.func_78256_a(s) - 1.0f, this.fontRenderer.field_78288_b, 0xFFFFFF, true);
            this.zOffset -= 45.0;
        }
        RenderHelper.func_74518_a();
    }

    @Override
    public boolean renderOverlayLayer(Minecraft minecraft, int mouseX, int mouseY, float partialTicks) {
        if (this.getInsetRect().contains(mouseX, mouseY) && (this.drawToolTip || this.toolTipOverride != null)) {
            List list = this.toolTipOverride != null ? this.toolTipOverride : this.getStack().func_82840_a((EntityPlayer)minecraft.field_71439_g, (ITooltipFlag)(minecraft.field_71474_y.field_82882_x ? ITooltipFlag.TooltipFlags.ADVANCED : ITooltipFlag.TooltipFlags.NORMAL));
            this.drawHoveringText(list, mouseX, mouseY, this.fontRenderer, this.screenWidth, this.screenHeight);
            return true;
        }
        return super.renderOverlayLayer(minecraft, mouseX, mouseY, partialTicks);
    }

    public GuiStackIcon setStack(StackReference stackReference) {
        this.stackReference = stackReference;
        return this;
    }

    public GuiStackIcon setBackground(MGuiElementBase background) {
        if (background == null) {
            if (this.background != null) {
                this.removeChild(this.background);
                this.background = null;
            }
        } else {
            if (this.background != null) {
                this.removeChild(this.background);
            }
            this.background = background;
            background.setPos(this);
            background.setSize(this);
            this.addChild(background);
        }
        return this;
    }

    public GuiStackIcon setToolTip(boolean drawToolTip) {
        this.drawToolTip = drawToolTip;
        return this;
    }

    public ItemStack getStack() {
        ItemStack stack;
        int hash = this.stackReference.hashCode();
        if (!stackCache.containsKey(hash)) {
            stack = this.stackReference.createStack();
            if (stack.func_190926_b()) {
                stack = new ItemStack(Blocks.field_180401_cv);
                this.toolTipOverride = new ArrayList<String>();
                this.toolTipOverride.add("Failed to load Item Stack");
                this.toolTipOverride.add("This may mean the mod the stack belongs to is not installed");
                this.toolTipOverride.add("Or its just broken...");
            }
            stackCache.put(hash, stack);
        }
        if ((stack = stackCache.get(hash)).func_190926_b()) {
            stack = new ItemStack(Blocks.field_180401_cv);
            stackCache.remove(hash);
        }
        return stack;
    }

    public GuiStackIcon setToolTipOverride(List<String> toolTipOverride) {
        this.toolTipOverride = toolTipOverride;
        return this;
    }

    public GuiStackIcon setDrawHoverHighlight(boolean drawHoverHighlight) {
        this.drawHoverHighlight = drawHoverHighlight;
        return this;
    }

    public GuiStackIcon addSlotBackground() {
        this.setBackground(null);
        this.background = ((GuiSlotRender)new GuiSlotRender().setPos(this)).setSizeModifiers((guiSlotRender, integer) -> this.xSize(), (guiSlotRender, integer) -> this.ySize());
        this.addChild(this.background);
        return this;
    }

    public MGuiElementBase getBackground() {
        return this.background;
    }
}

