/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.client.particle;

import com.brandon3055.brandonscore.client.particle.IGLFXHandler;
import com.brandon3055.brandonscore.lib.Vec3D;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.Entity;
import net.minecraft.world.World;

public class BCParticle
extends Particle {
    protected float texturesPerRow = 16.0f;
    protected float airResistance = 0.0f;
    protected float baseScale = 1.0f;
    private static IGLFXHandler DEFAULT_FX_HANDLER = new IGLFXHandler(){

        @Override
        public void preDraw(int layer, BufferBuilder vertexbuffer, Entity entityIn, float partialTicks, float rotationX, float rotationZ, float rotationYZ, float rotationXY, float rotationXZ) {
        }

        @Override
        public void postDraw(int layer, BufferBuilder vertexbuffer, Tessellator tessellator) {
        }
    };

    public BCParticle(World worldIn, Vec3D pos) {
        super(worldIn, pos.x, pos.y, pos.z);
    }

    public BCParticle(World worldIn, Vec3D pos, Vec3D speed) {
        super(worldIn, pos.x, pos.y, pos.z, speed.x, speed.y, speed.z);
    }

    public int func_70537_b() {
        return super.func_70537_b();
    }

    public IGLFXHandler getFXHandler() {
        return DEFAULT_FX_HANDLER;
    }

    public boolean isRawGLParticle() {
        return false;
    }

    public BCParticle setScale(float scale) {
        this.field_70544_f = scale;
        this.baseScale = scale;
        return this;
    }

    public BCParticle setColour(float red, float green, float blue) {
        super.func_70538_b(red, green, blue);
        return this;
    }

    public BCParticle setMaxAge(int age, int randAdditive) {
        super.func_187114_a(age + this.field_187136_p.nextInt(randAdditive));
        return this;
    }

    public BCParticle setGravity(double gravity) {
        this.field_70545_g = (float)gravity;
        return this;
    }

    public BCParticle setAirResistance(float airResistance) {
        this.airResistance = airResistance;
        return this;
    }

    public BCParticle setSizeAndRandMotion(double scale, double xMotion, double yMotion, double zMotion) {
        this.field_70544_f = (float)scale;
        this.baseScale = (float)scale;
        this.field_187129_i = (-0.5 + this.field_187136_p.nextDouble()) * xMotion;
        this.field_187130_j = (-0.5 + this.field_187136_p.nextDouble()) * yMotion;
        this.field_187131_k = (-0.5 + this.field_187136_p.nextDouble()) * zMotion;
        return this;
    }

    public Vec3D getPos() {
        return new Vec3D(this.field_187126_f, this.field_187127_g, this.field_187128_h);
    }

    public World getWorld() {
        return this.field_187122_b;
    }

    public BCParticle setPosition(Vec3D pos) {
        this.func_187109_b(pos.x, pos.y, pos.z);
        return this;
    }

    public void moveEntityNoClip(double x, double y, double z) {
        this.func_187108_a(this.func_187116_l().func_72317_d(0.0, y, 0.0));
        this.func_187108_a(this.func_187116_l().func_72317_d(x, 0.0, 0.0));
        this.func_187108_a(this.func_187116_l().func_72317_d(0.0, 0.0, z));
        this.func_187118_j();
    }

    public void func_180434_a(BufferBuilder vertexbuffer, Entity entity, float partialTicks, float rotationX, float rotationZ, float rotationYZ, float rotationXY, float rotationXZ) {
        float minU = (float)this.field_94054_b / this.texturesPerRow;
        float maxU = minU + 1.0f / this.texturesPerRow;
        float minV = (float)this.field_94055_c / this.texturesPerRow;
        float maxV = minV + 1.0f / this.texturesPerRow;
        float scale = 0.1f * this.field_70544_f;
        if (this.field_187119_C != null) {
            minU = this.field_187119_C.func_94209_e();
            maxU = this.field_187119_C.func_94212_f();
            minV = this.field_187119_C.func_94206_g();
            maxV = this.field_187119_C.func_94210_h();
        }
        float renderX = (float)(this.field_187123_c + (this.field_187126_f - this.field_187123_c) * (double)partialTicks - field_70556_an);
        float renderY = (float)(this.field_187124_d + (this.field_187127_g - this.field_187124_d) * (double)partialTicks - field_70554_ao);
        float renderZ = (float)(this.field_187125_e + (this.field_187128_h - this.field_187125_e) * (double)partialTicks - field_70555_ap);
        int brightnessForRender = this.func_189214_a(partialTicks);
        int j = brightnessForRender >> 16 & 0xFFFF;
        int k = brightnessForRender & 0xFFFF;
        vertexbuffer.func_181662_b((double)(renderX - rotationX * scale - rotationXY * scale), (double)(renderY - rotationZ * scale), (double)(renderZ - rotationYZ * scale - rotationXZ * scale)).func_187315_a((double)maxU, (double)maxV).func_181666_a(this.field_70552_h, this.field_70553_i, this.field_70551_j, this.field_82339_as).func_187314_a(j, k).func_181675_d();
        vertexbuffer.func_181662_b((double)(renderX - rotationX * scale + rotationXY * scale), (double)(renderY + rotationZ * scale), (double)(renderZ - rotationYZ * scale + rotationXZ * scale)).func_187315_a((double)maxU, (double)minV).func_181666_a(this.field_70552_h, this.field_70553_i, this.field_70551_j, this.field_82339_as).func_187314_a(j, k).func_181675_d();
        vertexbuffer.func_181662_b((double)(renderX + rotationX * scale + rotationXY * scale), (double)(renderY + rotationZ * scale), (double)(renderZ + rotationYZ * scale + rotationXZ * scale)).func_187315_a((double)minU, (double)minV).func_181666_a(this.field_70552_h, this.field_70553_i, this.field_70551_j, this.field_82339_as).func_187314_a(j, k).func_181675_d();
        vertexbuffer.func_181662_b((double)(renderX + rotationX * scale - rotationXY * scale), (double)(renderY - rotationZ * scale), (double)(renderZ + rotationYZ * scale - rotationXZ * scale)).func_187315_a((double)minU, (double)maxV).func_181666_a(this.field_70552_h, this.field_70553_i, this.field_70551_j, this.field_82339_as).func_187314_a(j, k).func_181675_d();
    }
}

