/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.utils;

import cofh.redstoneflux.api.IEnergyContainerItem;
import com.brandon3055.brandonscore.utils.LogHelperBC;
import com.brandon3055.brandonscore.utils.Utils;
import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;
import org.lwjgl.input.Keyboard;

public class InfoHelper {
    public static final int GUI_TITLE = 65535;

    public static void addEnergyInfo(ItemStack stack, List list) {
        IEnergyContainerItem item = (IEnergyContainerItem)stack.func_77973_b();
        String energy = Utils.formatNumber(item.getEnergyStored(stack));
        String maxEnergy = Utils.formatNumber(item.getMaxEnergyStored(stack));
        list.add(I18n.func_135052_a((String)"info.bc.charge.txt", (Object[])new Object[0]) + ": " + energy + " / " + maxEnergy + " RF");
    }

    public static void addLore(ItemStack stack, List list, boolean addLeadingLine) {
        String[] lore = InfoHelper.getLore(stack);
        if (addLeadingLine) {
            list.add("");
        }
        if (lore == null) {
            list.add("" + TextFormatting.ITALIC + "" + TextFormatting.DARK_PURPLE + "Invalid lore localization! (something is broken)");
            return;
        }
        for (String s : lore) {
            list.add("" + TextFormatting.ITALIC + "" + TextFormatting.DARK_PURPLE + s);
        }
    }

    public static void addLore(ItemStack stack, List list) {
        InfoHelper.addLore(stack, list, true);
    }

    public static void addEnergyAndLore(ItemStack stack, List list) {
        if (!InfoHelper.isShiftKeyDown()) {
            list.add(I18n.func_135052_a((String)"info.de.hold.txt", (Object[])new Object[0]) + " " + TextFormatting.AQUA + "" + TextFormatting.ITALIC + I18n.func_135052_a((String)"info.de.shift.txt", (Object[])new Object[0]) + TextFormatting.RESET + " " + TextFormatting.GRAY + I18n.func_135052_a((String)"info.de.forDetails.txt", (Object[])new Object[0]));
        } else {
            InfoHelper.addEnergyInfo(stack, list);
            InfoHelper.addLore(stack, list);
        }
    }

    public static String[] getLore(ItemStack stack) {
        String unlocalizeLore = stack.func_77973_b().func_77658_a() + ".lore";
        String rawLore = I18n.func_135052_a((String)unlocalizeLore, (Object[])new Object[0]);
        if (rawLore.contains(unlocalizeLore)) {
            return null;
        }
        String lineCountS = rawLore.substring(0, 1);
        rawLore = rawLore.substring(1);
        int lineCount = 0;
        try {
            lineCount = Integer.parseInt(lineCountS);
        }
        catch (NumberFormatException e) {
            LogHelperBC.error("Invalid Lore Format! Lore myst start with the number of lines \"3Line 1\\nLine 2\\nLine 3\"");
        }
        String[] loreLines = new String[lineCount];
        for (int i = 0; i < lineCount; ++i) {
            loreLines[i] = rawLore.contains("\\n") ? rawLore.substring(0, rawLore.indexOf("\\n")) : rawLore;
            if (!rawLore.contains("\\n")) continue;
            rawLore = rawLore.substring(rawLore.indexOf("\\n") + 2);
        }
        return loreLines;
    }

    public static boolean isShiftKeyDown() {
        return Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54);
    }

    public static boolean isCtrlKeyDown() {
        return Keyboard.isKeyDown((int)29) || Keyboard.isKeyDown((int)157);
    }

    public static boolean holdShiftForDetails(List list, boolean inverted) {
        if (InfoHelper.isShiftKeyDown() == inverted) {
            list.add(I18n.func_135052_a((String)"info.bc.holdShiftForDetails.txt", (Object[])new Object[]{TextFormatting.AQUA + "" + TextFormatting.ITALIC, TextFormatting.RESET + "" + TextFormatting.GRAY}));
        }
        return InfoHelper.isShiftKeyDown();
    }

    public static boolean holdShiftForDetails(List list) {
        return InfoHelper.holdShiftForDetails(list, false);
    }

    public static String ITC() {
        return "" + TextFormatting.RESET + "" + TextFormatting.DARK_AQUA;
    }

    public static String HITC() {
        return "" + TextFormatting.RESET + "" + TextFormatting.ITALIC + "" + TextFormatting.GOLD;
    }
}

