/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermaldynamics.multiblock;

import cofh.thermaldynamics.duct.tiles.DuctUnit;
import cofh.thermaldynamics.multiblock.IGridTile;
import cofh.thermaldynamics.multiblock.MultiBlockGrid;
import java.util.LinkedList;
import java.util.Queue;
import net.minecraft.util.EnumFacing;

public class MultiBlockFormer<T extends DuctUnit<T, G, C>, G extends MultiBlockGrid<T>, C> {
    Queue<T> blocksToCheck = new LinkedList<T>();
    G theGrid;

    public void formGrid(T theMultiBlock) {
        this.theGrid = ((DuctUnit)theMultiBlock).createGrid();
        ((DuctUnit)theMultiBlock).setGrid(this.theGrid);
        ((MultiBlockGrid)this.theGrid).addBlock(theMultiBlock);
        this.blocksToCheck.add(theMultiBlock);
        while (!this.blocksToCheck.isEmpty()) {
            this.checkMultiBlock((DuctUnit)this.blocksToCheck.remove());
        }
        ((MultiBlockGrid)this.theGrid).resetMultiBlocks();
    }

    private void checkMultiBlock(T currentMultiBlock) {
        if (!((DuctUnit)currentMultiBlock).isValidForForming()) {
            return;
        }
        ((DuctUnit)currentMultiBlock).onNeighborBlockChange();
        ((DuctUnit)currentMultiBlock).setInvalidForForming();
        for (byte i = 0; i < EnumFacing.field_82609_l.length; i = (byte)(i + 1)) {
            IGridTile aBlock;
            if (!((DuctUnit)currentMultiBlock).isSideConnected(i) || (aBlock = ((DuctUnit)currentMultiBlock).getConnectedSide(i)) == null) continue;
            ((DuctUnit)aBlock).onNeighborBlockChange();
            if (!((DuctUnit)aBlock).isValidForForming() || ((DuctUnit)aBlock).getConnectedSide(i ^ 1) != currentMultiBlock) continue;
            if (((DuctUnit)aBlock).getGrid() == null && ((MultiBlockGrid)this.theGrid).canAddBlock(aBlock)) {
                ((DuctUnit)aBlock).setGrid(this.theGrid);
                ((MultiBlockGrid)this.theGrid).addBlock((IGridTile)aBlock);
                this.blocksToCheck.add(aBlock);
                continue;
            }
            if (((MultiBlockGrid)this.theGrid).canAddBlock(aBlock) && ((DuctUnit)aBlock).getGrid() != null && ((MultiBlockGrid)this.theGrid).canGridsMerge((MultiBlockGrid)((DuctUnit)aBlock).getGrid())) {
                if (this.theGrid == ((DuctUnit)aBlock).getGrid()) continue;
                if (((MultiBlockGrid)this.theGrid).size() >= ((MultiBlockGrid)((DuctUnit)aBlock).getGrid()).size()) {
                    ((MultiBlockGrid)this.theGrid).mergeGrids(((DuctUnit)aBlock).getGrid());
                    continue;
                }
                ((MultiBlockGrid)((DuctUnit)aBlock).getGrid()).mergeGrids(this.theGrid);
                this.theGrid = ((DuctUnit)aBlock).getGrid();
                continue;
            }
            ((DuctUnit)currentMultiBlock).onConnectionRejected(i);
            ((DuctUnit)aBlock).onConnectionRejected(i ^ 1);
        }
    }
}

