/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.blocks;

import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.api.cells.CellNull;
import com.ferreusveritas.dynamictrees.api.cells.ICell;
import com.ferreusveritas.dynamictrees.api.network.MapSignal;
import com.ferreusveritas.dynamictrees.api.treedata.ILeavesProperties;
import com.ferreusveritas.dynamictrees.api.treedata.ITreePart;
import com.ferreusveritas.dynamictrees.blocks.BlockBranch;
import com.ferreusveritas.dynamictrees.systems.GrowSignal;
import com.ferreusveritas.dynamictrees.trees.Species;
import com.google.common.base.Predicate;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.property.ExtendedBlockState;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockBranchCactus
extends BlockBranch {
    public static final PropertyEnum<EnumFacing> ORIGIN = PropertyEnum.func_177708_a((String)"origin", EnumFacing.class, (Predicate)new Predicate<EnumFacing>(){

        public boolean apply(@Nullable EnumFacing dir) {
            return dir != EnumFacing.UP;
        }
    });
    public static final PropertyBool TRUNK = PropertyBool.func_177716_a((String)"trunk");

    public BlockBranchCactus(String name) {
        super(Material.field_151570_A, name);
        this.func_149672_a(SoundType.field_185854_g);
        this.setHarvestLevel("axe", 0);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)TRUNK, (Comparable)Boolean.valueOf(true)).func_177226_a(ORIGIN, (Comparable)EnumFacing.DOWN));
    }

    protected BlockStateContainer func_180661_e() {
        IProperty[] listedProperties = new IProperty[]{ORIGIN, TRUNK};
        return new ExtendedBlockState((Block)this, listedProperties, CONNECTIONS);
    }

    public IBlockState func_176203_a(int meta) {
        EnumFacing rootDir = EnumFacing.func_82600_a((int)((meta & 7) % 6));
        boolean trunk = rootDir == EnumFacing.UP;
        return this.func_176223_P().func_177226_a(ORIGIN, (Comparable)(trunk ? EnumFacing.DOWN : rootDir)).func_177226_a((IProperty)TRUNK, (Comparable)Boolean.valueOf(trunk));
    }

    public int func_176201_c(IBlockState state) {
        if (((Boolean)state.func_177229_b((IProperty)TRUNK)).booleanValue()) {
            return EnumFacing.UP.func_176745_a();
        }
        return ((EnumFacing)state.func_177229_b(ORIGIN)).func_176745_a();
    }

    public IBlockState getExtendedState(IBlockState state, IBlockAccess blockAcess, BlockPos pos) {
        if (state instanceof IExtendedBlockState) {
            IExtendedBlockState retval = (IExtendedBlockState)state;
            int thisRadius = this.getRadius(state);
            for (EnumFacing dir : EnumFacing.field_82609_l) {
                retval = retval.withProperty(CONNECTIONS[dir.func_176745_a()], (Object)this.getSideConnectionRadius(blockAcess, pos, thisRadius, dir));
            }
            return retval;
        }
        return state;
    }

    @Override
    public int branchSupport(IBlockState blockState, IBlockAccess blockAccess, BlockBranch branch, BlockPos pos, EnumFacing dir, int radius) {
        return 0;
    }

    public float func_176195_g(IBlockState blockState, World world, BlockPos pos) {
        int radius = this.getRadius(blockState);
        return this.getFamily().getPrimitiveLog().func_177230_c().func_176195_g(blockState, world, pos) * (float)(radius * radius) / 64.0f * 8.0f;
    }

    @Override
    public boolean checkForRot(World world, BlockPos pos, Species species, int radius, Random rand, float chance, boolean rapid) {
        return false;
    }

    public void func_180634_a(World worldIn, BlockPos pos, IBlockState state, Entity entityIn) {
        entityIn.func_70097_a(DamageSource.field_76367_g, 1.0f);
    }

    public IBlockState func_180642_a(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        IBlockState returnState = this.func_176223_P();
        IBlockState adjState = world.func_180495_p(pos.func_177972_a(facing.func_176734_d()));
        boolean trunk = facing == EnumFacing.UP && (adjState.isSideSolid((IBlockAccess)world, pos.func_177972_a(facing.func_176734_d()), facing) || adjState.func_177230_c() == this && (Boolean)adjState.func_177229_b((IProperty)TRUNK) != false);
        return returnState.func_177226_a((IProperty)TRUNK, (Comparable)Boolean.valueOf(trunk)).func_177226_a(ORIGIN, (Comparable)(facing != EnumFacing.DOWN ? facing.func_176734_d() : EnumFacing.DOWN));
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT_MIPPED;
    }

    @Override
    public ICell getHydrationCell(IBlockAccess blockAccess, BlockPos pos, IBlockState blockState, EnumFacing dir, ILeavesProperties leavesProperties) {
        return CellNull.NULLCELL;
    }

    @Override
    public int getRadius(IBlockState blockState) {
        return blockState.func_177230_c() == this ? (((Boolean)blockState.func_177229_b((IProperty)TRUNK)).booleanValue() ? 5 : 4) : 0;
    }

    @Override
    public int setRadius(World world, BlockPos pos, int radius, EnumFacing originDir, int flags) {
        return radius;
    }

    @Override
    public int probabilityForBlock(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, BlockBranch from) {
        return this.isSameTree(from) ? this.getRadius(blockState) + 2 : 0;
    }

    public GrowSignal growIntoAir(World world, BlockPos pos, GrowSignal signal, int fromRadius) {
        EnumFacing originDir = signal.dir.func_176734_d();
        boolean trunk = signal.isInTrunk();
        if (originDir.func_176740_k() != EnumFacing.Axis.Y && (world.func_180495_p(pos.func_177984_a()).func_177230_c() == this || world.func_180495_p(pos.func_177977_b()).func_177230_c() == this)) {
            signal.success = false;
            return signal;
        }
        signal.success = world.func_180501_a(pos, this.field_176227_L.func_177621_b().func_177226_a((IProperty)TRUNK, (Comparable)Boolean.valueOf(trunk)).func_177226_a(ORIGIN, (Comparable)originDir), 2);
        signal.radius = (int)(trunk ? signal.getSpecies().getFamily().getPrimaryThickness() : signal.getSpecies().getFamily().getSecondaryThickness());
        return signal;
    }

    @Override
    public GrowSignal growSignal(World world, BlockPos pos, GrowSignal signal) {
        if (signal.step()) {
            Species species = signal.getSpecies();
            EnumFacing targetDir = species.selectNewDirection(world, pos, this, signal);
            signal.doTurn(targetDir);
            BlockPos deltaPos = pos.func_177972_a(targetDir);
            IBlockState deltaState = world.func_180495_p(deltaPos);
            ITreePart treepart = TreeHelper.getTreePart(deltaState);
            if (treepart == this) {
                signal = treepart.growSignal(world, deltaPos, signal);
            } else if (world.func_175623_d(deltaPos)) {
                signal = this.growIntoAir(world, deltaPos, signal, (int)signal.radius);
            }
        }
        return signal;
    }

    @Override
    public IBlockState getStateForRadius(int radius) {
        return this.func_176223_P().func_177226_a((IProperty)TRUNK, (Comparable)Boolean.valueOf(radius > 4));
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess blockAccess, BlockPos pos) {
        if (state.func_177230_c() != this) {
            return field_185506_k;
        }
        int thisRadius = this.getRadius(state);
        boolean connectionMade = false;
        double radius = (double)thisRadius / 16.0;
        double gap = 0.5 - radius;
        AxisAlignedBB aabb = new AxisAlignedBB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0).func_186662_g(radius);
        int numConnections = 0;
        for (EnumFacing dir : EnumFacing.field_82609_l) {
            if (this.getSideConnectionRadius(blockAccess, pos, thisRadius, dir) <= 0) continue;
            connectionMade = true;
            ++numConnections;
            aabb = aabb.func_72321_a((double)dir.func_82601_c() * gap, (double)dir.func_96559_d() * gap, (double)dir.func_82599_e() * gap);
        }
        if (!((Boolean)state.func_177229_b((IProperty)TRUNK)).booleanValue() && numConnections == 1 && ((EnumFacing)state.func_177229_b(ORIGIN)).func_176740_k().func_176722_c()) {
            aabb = aabb.func_72321_a((double)EnumFacing.UP.func_82601_c() * gap, (double)EnumFacing.UP.func_96559_d() * gap, (double)EnumFacing.UP.func_82599_e() * gap);
        }
        if (connectionMade) {
            return aabb.func_72317_d(0.5, 0.5, 0.5);
        }
        return new AxisAlignedBB(0.5 - radius, 0.5 - radius, 0.5 - radius, 0.5 + radius, 0.5 + radius, 0.5 + radius);
    }

    public void func_185477_a(IBlockState state, World world, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, Entity entityIn, boolean p_185477_7_) {
        int thisRadius = this.getRadius(state);
        int numConnections = 0;
        for (EnumFacing dir : EnumFacing.field_82609_l) {
            int connRadius = this.getSideConnectionRadius((IBlockAccess)world, pos, thisRadius, dir);
            if (connRadius <= 0) continue;
            ++numConnections;
            double radius = (double)MathHelper.func_76125_a((int)connRadius, (int)1, (int)thisRadius) / 16.0;
            double gap = 0.5 - radius;
            AxisAlignedBB aabb = new AxisAlignedBB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0).func_186662_g(radius);
            aabb = aabb.func_72317_d((double)dir.func_82601_c() * gap, (double)dir.func_96559_d() * gap, (double)dir.func_82599_e() * gap).func_72317_d(0.5, 0.5, 0.5);
            BlockBranchCactus.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)aabb);
        }
        if (!((Boolean)state.func_177229_b((IProperty)TRUNK)).booleanValue() && numConnections == 1 && ((EnumFacing)state.func_177229_b(ORIGIN)).func_176740_k().func_176722_c()) {
            double radius = (double)MathHelper.func_76125_a((int)4, (int)1, (int)thisRadius) / 16.0;
            double gap = 0.5 - radius;
            AxisAlignedBB aabb = new AxisAlignedBB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0).func_186662_g(radius);
            aabb = aabb.func_72317_d((double)EnumFacing.UP.func_82601_c() * gap, (double)EnumFacing.UP.func_96559_d() * gap, (double)EnumFacing.UP.func_82599_e() * gap).func_72317_d(0.5, 0.5, 0.5);
            BlockBranchCactus.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)aabb);
        }
        double min = 0.5 - (double)thisRadius / 16.0;
        double max = 0.5 + (double)thisRadius / 16.0;
        BlockBranchCactus.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)new AxisAlignedBB(min, min, min, max, max, max));
    }

    @Override
    public int getRadiusForConnection(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, BlockBranch from, EnumFacing side, int fromRadius) {
        return 0;
    }

    protected int getSideConnectionRadius(IBlockAccess blockAccess, BlockPos pos, int radius, EnumFacing side) {
        BlockPos deltaPos = pos.func_177972_a(side);
        IBlockState otherState = blockAccess.func_180495_p(deltaPos);
        IBlockState state = blockAccess.func_180495_p(pos);
        if (otherState.func_177230_c() == this && state.func_177230_c() == this && (otherState.func_177229_b(ORIGIN) == side.func_176734_d() || state.func_177229_b(ORIGIN) == side)) {
            return (Boolean)state.func_177229_b((IProperty)TRUNK) != false && (Boolean)otherState.func_177229_b((IProperty)TRUNK) != false ? 5 : 4;
        }
        if (side == EnumFacing.DOWN && state.func_177230_c() == this && ((Boolean)state.func_177229_b((IProperty)TRUNK)).booleanValue() && state.func_177229_b(ORIGIN) == side) {
            return 5;
        }
        return 0;
    }

    @Override
    public MapSignal analyse(IBlockState blockState, World world, BlockPos pos, EnumFacing fromDir, MapSignal signal) {
        if (signal.depth++ < 32) {
            IBlockState state = world.func_180495_p(pos);
            signal.run(blockState, world, pos, fromDir);
            for (EnumFacing dir : EnumFacing.field_82609_l) {
                if (dir == fromDir) continue;
                BlockPos deltaPos = pos.func_177972_a(dir);
                IBlockState deltaState = world.func_180495_p(deltaPos);
                if (deltaState.func_177230_c() == this && deltaState.func_177229_b(ORIGIN) == dir.func_176734_d()) {
                    signal = ((ITreePart)deltaState.func_177230_c()).analyse(deltaState, world, deltaPos, dir.func_176734_d(), signal);
                } else if (state.func_177230_c() == this && state.func_177229_b(ORIGIN) == dir) {
                    signal = TreeHelper.getTreePart(deltaState).analyse(deltaState, world, deltaPos, dir.func_176734_d(), signal);
                }
                if (!signal.found || signal.localRootDir != null || fromDir != null) continue;
                signal.localRootDir = dir;
            }
            signal.returnRun(blockState, world, pos, fromDir);
        } else {
            IBlockState state = world.func_180495_p(pos);
            if (state.func_177230_c() instanceof BlockBranch) {
                BlockBranch branch = (BlockBranch)state.func_177230_c();
                branch.breakDeliberate(world, pos, BlockBranch.EnumDestroyMode.OVERFLOW);
            }
            signal.overflow = true;
        }
        --signal.depth;
        return signal;
    }
}

