/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.client;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ModelManager;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormatElement;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class QuadManipulator {
    public static final EnumFacing[] everyFace = new EnumFacing[]{EnumFacing.DOWN, EnumFacing.UP, EnumFacing.NORTH, EnumFacing.SOUTH, EnumFacing.WEST, EnumFacing.EAST, null};
    private static ModelManager modelManager = null;

    public static List<BakedQuad> getQuads(IBakedModel modelIn, IBlockState stateIn) {
        return QuadManipulator.getQuads(modelIn, stateIn, Vec3d.field_186680_a, everyFace, 0L);
    }

    public static List<BakedQuad> getQuads(IBakedModel modelIn, IBlockState stateIn, EnumFacing[] sides) {
        return QuadManipulator.getQuads(modelIn, stateIn, Vec3d.field_186680_a, sides, 0L);
    }

    public static List<BakedQuad> getQuads(IBakedModel modelIn, IBlockState stateIn, long rand) {
        return QuadManipulator.getQuads(modelIn, stateIn, Vec3d.field_186680_a, everyFace, rand);
    }

    public static List<BakedQuad> getQuads(IBakedModel modelIn, IBlockState stateIn, Vec3d offset, long rand) {
        return QuadManipulator.getQuads(modelIn, stateIn, offset, everyFace, rand);
    }

    public static List<BakedQuad> getQuads(IBakedModel modelIn, IBlockState stateIn, Vec3d offset) {
        return QuadManipulator.getQuads(modelIn, stateIn, offset, everyFace, 0L);
    }

    public static List<BakedQuad> getQuads(IBakedModel modelIn, IBlockState stateIn, Vec3d offset, EnumFacing[] sides) {
        return QuadManipulator.getQuads(modelIn, stateIn, offset, sides, 0L);
    }

    public static List<BakedQuad> getQuads(IBakedModel modelIn, IBlockState stateIn, Vec3d offset, EnumFacing[] sides, long rand) {
        ArrayList<BakedQuad> outQuads = new ArrayList<BakedQuad>();
        if (stateIn != null) {
            for (EnumFacing enumfacing : sides) {
                outQuads.addAll(modelIn.func_188616_a(stateIn, enumfacing, rand));
            }
        }
        return offset.equals((Object)Vec3d.field_186680_a) ? outQuads : QuadManipulator.moveQuads(outQuads, offset);
    }

    public static List<BakedQuad> moveQuads(List<BakedQuad> inQuads, Vec3d offset) {
        ArrayList<BakedQuad> outQuads = new ArrayList<BakedQuad>();
        for (BakedQuad inQuad : inQuads) {
            BakedQuad quadCopy = new BakedQuad((int[])inQuad.func_178209_a().clone(), inQuad.func_178211_c(), inQuad.func_178210_d(), inQuad.func_187508_a(), inQuad.shouldApplyDiffuseLighting(), inQuad.getFormat());
            int[] vertexData = quadCopy.func_178209_a();
            block1: for (int i = 0; i < vertexData.length; i += inQuad.getFormat().func_181719_f()) {
                int pos = 0;
                for (VertexFormatElement vfe : inQuad.getFormat().func_177343_g()) {
                    if (vfe.func_177375_c() == VertexFormatElement.EnumUsage.POSITION) {
                        float x = Float.intBitsToFloat(vertexData[i + pos + 0]);
                        float y = Float.intBitsToFloat(vertexData[i + pos + 1]);
                        float z = Float.intBitsToFloat(vertexData[i + pos + 2]);
                        x = (float)((double)x + offset.field_72450_a);
                        y = (float)((double)y + offset.field_72448_b);
                        z = (float)((double)z + offset.field_72449_c);
                        vertexData[i + pos + 0] = Float.floatToIntBits(x);
                        vertexData[i + pos + 1] = Float.floatToIntBits(y);
                        vertexData[i + pos + 2] = Float.floatToIntBits(z);
                        continue block1;
                    }
                    pos += vfe.func_177368_f() / 4;
                }
            }
            outQuads.add(quadCopy);
        }
        outQuads.trimToSize();
        return outQuads;
    }

    public static IModel getModelForState(IBlockState state) {
        IModel model = null;
        try {
            model = ModelLoaderRegistry.getModel((ResourceLocation)QuadManipulator.getModelLocation(state));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return model;
    }

    public static ModelManager getModelManager() {
        if (modelManager == null) {
            try {
                Field[] fields;
                for (Field f : fields = Minecraft.class.getDeclaredFields()) {
                    if (f.getType() != ModelManager.class) continue;
                    f.setAccessible(true);
                    modelManager = (ModelManager)f.get(Minecraft.func_71410_x());
                    return modelManager;
                }
            }
            catch (IllegalAccessException | IllegalArgumentException | SecurityException e) {
                e.printStackTrace();
            }
        }
        return modelManager;
    }

    public static ModelResourceLocation getModelLocation(IBlockState state) {
        return (ModelResourceLocation)QuadManipulator.getModelManager().func_174954_c().func_178120_a().func_188181_b(state.func_177230_c()).get(state);
    }

    public static ResourceLocation getModelTexture(IModel model, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter, IBlockState state, EnumFacing dir) {
        float[] uvs = QuadManipulator.getSpriteUVFromBlockState(state, dir);
        if (uvs != null) {
            ArrayList<TextureAtlasSprite> sprites = new ArrayList<TextureAtlasSprite>();
            float closest = Float.POSITIVE_INFINITY;
            ResourceLocation closestTex = new ResourceLocation("missingno");
            if (model != null) {
                for (ResourceLocation tex : model.getTextures()) {
                    TextureAtlasSprite tas = bakedTextureGetter.apply(tex);
                    float u = tas.func_94214_a(8.0);
                    float v = tas.func_94207_b(8.0);
                    sprites.add(tas);
                    float du = u - uvs[0];
                    float dv = v - uvs[1];
                    float distSq = du * du + dv * dv;
                    if (!(distSq < closest)) continue;
                    closest = distSq;
                    closestTex = tex;
                }
            }
            return closestTex;
        }
        return null;
    }

    public static float[] getSpriteUVFromBlockState(IBlockState state, EnumFacing side) {
        IBakedModel bakedModel = QuadManipulator.getModelManager().func_174954_c().func_178125_b(state);
        List quads = bakedModel.func_188616_a(state, side, 0L);
        quads.addAll(bakedModel.func_188616_a(state, null, 0L));
        Optional<BakedQuad> quad = quads.stream().filter(q -> q.func_178210_d() == side).findFirst();
        if (quad.isPresent()) {
            float u = 0.0f;
            float v = 0.0f;
            int[] vertexData = quad.get().func_178209_a();
            int numVertices = 0;
            for (int i = 0; i < vertexData.length; i += quad.get().getFormat().func_181719_f()) {
                int pos = 0;
                for (VertexFormatElement vfe : quad.get().getFormat().func_177343_g()) {
                    if (vfe.func_177375_c() == VertexFormatElement.EnumUsage.UV) {
                        u += Float.intBitsToFloat(vertexData[i + pos + 0]);
                        v += Float.intBitsToFloat(vertexData[i + pos + 1]);
                    }
                    pos += vfe.func_177368_f() / 4;
                }
                ++numVertices;
            }
            return new float[]{u / (float)numVertices, v / (float)numVertices};
        }
        System.err.println("Warning: Could not get \"" + side + "\" side quads from blockstate: " + state);
        return null;
    }
}

