/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.event;

import com.ferreusveritas.dynamictrees.client.ThickRingTextureAtlasSprite;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TextureGenerationHandler {
    private static final Map<ResourceLocation, ResourceLocation> thickRingTextures = new HashMap<ResourceLocation, ResourceLocation>();

    public static ResourceLocation addRingTextureLocation(ResourceLocation ringsRes) {
        ResourceLocation outputRes = new ResourceLocation(ringsRes.func_110624_b(), ringsRes.func_110623_a() + "_thick");
        thickRingTextures.put(ringsRes, outputRes);
        return outputRes;
    }

    public static ResourceLocation addDualTextureLocations(ResourceLocation res1, ResourceLocation res2, ResourceLocation outputRes) {
        thickRingTextures.put(new DualResourceLocation(res1, res2), outputRes);
        return outputRes;
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public static void onTextureStitchEvent(TextureStitchEvent.Pre event) {
        IResourceManager resourceManager = Minecraft.func_71410_x().func_110442_L();
        for (Map.Entry<ResourceLocation, ResourceLocation> entry : thickRingTextures.entrySet()) {
            IResource resource;
            if (entry.getKey() instanceof DualResourceLocation) {
                TextureGenerationHandler.dualStitch(event, (DualResourceLocation)entry.getKey(), entry.getValue());
                continue;
            }
            ResourceLocation textureLocation = new ResourceLocation(entry.getValue().func_110624_b(), String.format("%s/%s%s", event.getMap().getBasePath(), entry.getValue().func_110623_a(), ".png"));
            try {
                resource = resourceManager.func_110536_a(textureLocation);
            }
            catch (IOException e) {
                resource = null;
            }
            if (resource != null) {
                event.getMap().func_174942_a(entry.getValue());
                continue;
            }
            event.getMap().setTextureEntry((TextureAtlasSprite)new ThickRingTextureAtlasSprite(entry.getValue(), entry.getKey()));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void dualStitch(TextureStitchEvent.Pre event, DualResourceLocation key, ResourceLocation value) {
        event.getMap().setTextureEntry((TextureAtlasSprite)new ThickRingTextureAtlasSprite(value, key, key.getAlternate()));
    }

    public static class DualResourceLocation
    extends ResourceLocation {
        private ResourceLocation alternate;

        public DualResourceLocation(ResourceLocation primary, ResourceLocation alternate) {
            super(primary.func_110624_b(), primary.func_110623_a());
            this.alternate = alternate;
        }

        public ResourceLocation getAlternate() {
            return this.alternate;
        }
    }
}

