/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.models.loaders;

import com.ferreusveritas.dynamictrees.blocks.BlockBranch;
import com.ferreusveritas.dynamictrees.blocks.BlockBranchThick;
import com.ferreusveritas.dynamictrees.client.QuadManipulator;
import com.ferreusveritas.dynamictrees.event.TextureGenerationHandler;
import com.ferreusveritas.dynamictrees.models.ModelResourceLocationWrapped;
import com.ferreusveritas.dynamictrees.models.bakedmodels.BakedModelBlockBranchBasic;
import com.ferreusveritas.dynamictrees.models.bakedmodels.BakedModelBlockBranchThick;
import com.ferreusveritas.dynamictrees.models.blockmodels.ModelBlockWrapped;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.ICustomModelLoader;
import net.minecraftforge.client.model.IModel;

public class ModelLoaderWrapped
implements ICustomModelLoader {
    protected IResourceManager resourceManager;
    public static Map<String, Function<ModelResourceLocationWrapped, IModel>> modelCreatorMap = new HashMap<String, Function<ModelResourceLocationWrapped, IModel>>();

    public void func_110549_a(IResourceManager resourceManager) {
        this.resourceManager = resourceManager;
    }

    public boolean accepts(ResourceLocation modelLocation) {
        if (modelLocation instanceof ModelResourceLocationWrapped) {
            return modelCreatorMap.containsKey(modelLocation.func_110623_a());
        }
        return false;
    }

    public IModel loadModel(ResourceLocation modelLocation) throws Exception {
        return this.accepts(modelLocation) ? modelCreatorMap.get(modelLocation.func_110623_a()).apply((ModelResourceLocationWrapped)modelLocation) : null;
    }

    public static IModel loadModelBranch(ModelResourceLocationWrapped location) {
        final IBlockState blockState = location.getBlockState();
        BlockBranch branch = (BlockBranch)blockState.func_177230_c();
        final boolean thick = branch instanceof BlockBranchThick;
        final ResourceLocation thickRingRes = thick ? ModelLoaderWrapped.injectThickRingTextures(location) : null;
        return new ModelBlockWrapped(location){

            @Override
            public IBakedModel createBakedModel(Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
                BlockBranch branch = (BlockBranch)blockState.func_177230_c();
                IBlockState primLog = branch.getFamily().getPrimitiveLog();
                IModel model = QuadManipulator.getModelForState(primLog);
                ResourceLocation ringsRes = QuadManipulator.getModelTexture(model, bakedTextureGetter, primLog, EnumFacing.UP);
                ResourceLocation barkRes = QuadManipulator.getModelTexture(model, bakedTextureGetter, primLog, EnumFacing.SOUTH);
                return thick ? new BakedModelBlockBranchThick(barkRes, ringsRes, thickRingRes != null ? thickRingRes : ringsRes, bakedTextureGetter) : new BakedModelBlockBranchBasic(barkRes, ringsRes, bakedTextureGetter);
            }
        };
    }

    private static ResourceLocation injectThickRingTextures(ModelResourceLocationWrapped location) {
        ResourceLocation candidate2;
        IBlockState blockState = location.getBlockState();
        BlockBranch branch = (BlockBranch)blockState.func_177230_c();
        ResourceLocation familyName = branch.getFamily().getName();
        IBlockState primLog = branch.getFamily().getPrimitiveLog();
        IModel model = QuadManipulator.getModelForState(primLog);
        Iterator iter = model.getTextures().iterator();
        ResourceLocation candidate1 = iter.hasNext() ? (ResourceLocation)iter.next() : null;
        ResourceLocation resourceLocation = candidate2 = iter.hasNext() ? (ResourceLocation)iter.next() : null;
        if (candidate1 != null) {
            if (candidate2 != null && candidate1.func_110624_b().equals(candidate2.func_110624_b())) {
                ResourceLocation thickRingRes = new ResourceLocation(candidate1.func_110624_b(), "blocks/log_" + familyName.func_110623_a() + "_top_thick");
                return TextureGenerationHandler.addDualTextureLocations(candidate1, candidate2, thickRingRes);
            }
            return TextureGenerationHandler.addRingTextureLocation(candidate1);
        }
        return null;
    }

    static {
        modelCreatorMap.put("branch", r -> ModelLoaderWrapped.loadModelBranch(r));
    }
}

