/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.systems.nodemappers;

import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.api.network.INodeInspector;
import com.ferreusveritas.dynamictrees.blocks.BlockBranch;
import com.ferreusveritas.dynamictrees.blocks.BlockDynamicLeaves;
import com.ferreusveritas.dynamictrees.trees.Species;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class NodeTransform
implements INodeInspector {
    Species fromSpecies;
    Species toSpecies;

    public NodeTransform(Species fromTree, Species toTree) {
        this.fromSpecies = fromTree;
        this.toSpecies = toTree;
    }

    @Override
    public boolean run(IBlockState blockState, World world, BlockPos pos, EnumFacing fromDir) {
        int radius;
        BlockBranch branch = TreeHelper.getBranch(blockState);
        if (branch != null && this.fromSpecies.getFamily() == branch.getFamily() && (radius = branch.getRadius(blockState)) > 0) {
            this.toSpecies.getFamily().getDynamicBranch().setRadius(world, pos, radius, null);
            if (radius == 1) {
                this.transformSurroundingLeaves(world, pos);
            }
        }
        return true;
    }

    @Override
    public boolean returnRun(IBlockState blockState, World world, BlockPos pos, EnumFacing fromDir) {
        return false;
    }

    public void transformSurroundingLeaves(World world, BlockPos twigPos) {
        if (!world.field_72995_K) {
            for (BlockPos leavesPos : BlockPos.func_177980_a((BlockPos)twigPos.func_177982_a(-3, -3, -3), (BlockPos)twigPos.func_177982_a(3, 3, 3))) {
                if (this.fromSpecies.getLeavesProperties().getCellKit().getLeafCluster().getVoxel(twigPos, leavesPos) == 0) continue;
                IBlockState state = world.func_180495_p(leavesPos);
                if (!this.fromSpecies.getFamily().isCompatibleGenericLeaves(state, (IBlockAccess)world, leavesPos)) continue;
                int hydro = state.func_177230_c() instanceof BlockDynamicLeaves ? (Integer)state.func_177229_b((IProperty)BlockDynamicLeaves.HYDRO) : 2;
                world.func_175656_a(leavesPos, this.toSpecies.getLeavesProperties().getDynamicLeavesState(hydro));
            }
        }
    }
}

