/*
 * Decompiled with CFR 0.152.
 */
package openmods.geometry;

import com.google.common.base.Preconditions;
import javax.vecmath.Matrix3f;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.Vec3d;
import openmods.geometry.Orientation;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

public abstract class BlockSpaceTransform {
    private static final int ARG_Z = 6;
    private static final int ARG_Y = 4;
    private static final int ARG_X = 2;
    public static final BlockSpaceTransform instance = BlockSpaceTransform.createTransformInstance();

    private static void createVarAccess(MethodVisitor mv, double value, int var) {
        if (value == 1.0) {
            mv.visitVarInsn(24, var);
        } else if (value == -1.0) {
            mv.visitInsn(15);
            mv.visitVarInsn(24, var);
            mv.visitInsn(103);
        } else {
            throw new IllegalArgumentException();
        }
    }

    private static void createRowVectorMultiplication(MethodVisitor mv, double x, double y, double z) {
        if (x != 0.0) {
            Preconditions.checkArgument((y == 0.0 && z == 0.0 ? 1 : 0) != 0);
            BlockSpaceTransform.createVarAccess(mv, x, 2);
        } else if (y != 0.0) {
            Preconditions.checkArgument((x == 0.0 && z == 0.0 ? 1 : 0) != 0);
            BlockSpaceTransform.createVarAccess(mv, y, 4);
        } else if (z != 0.0) {
            Preconditions.checkArgument((x == 0.0 && y == 0.0 ? 1 : 0) != 0);
            BlockSpaceTransform.createVarAccess(mv, z, 6);
        } else {
            throw new IllegalArgumentException();
        }
    }

    private static void createTransformMethod(MethodVisitor mv, boolean invert) {
        mv.visitCode();
        mv.visitVarInsn(25, 1);
        String enumType = Type.getInternalName(Enum.class);
        mv.visitMethodInsn(182, enumType, "ordinal", Type.getMethodDescriptor((Type)Type.INT_TYPE, (Type[])new Type[0]), false);
        Orientation[] orientations = Orientation.values();
        Label defaultLabel = new Label();
        Label[] targets = new Label[orientations.length];
        for (int i = 0; i < orientations.length; ++i) {
            targets[i] = new Label();
        }
        mv.visitTableSwitchInsn(0, orientations.length - 1, defaultLabel, targets);
        mv.visitLabel(defaultLabel);
        String excType = Type.getInternalName(IllegalArgumentException.class);
        Type stringType = Type.getType(String.class);
        mv.visitTypeInsn(187, excType);
        mv.visitInsn(89);
        mv.visitVarInsn(25, 1);
        mv.visitMethodInsn(182, Type.getInternalName(Object.class), "toString", Type.getMethodDescriptor((Type)stringType, (Type[])new Type[0]), false);
        mv.visitMethodInsn(183, excType, "<init>", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{stringType}), false);
        mv.visitInsn(191);
        String createVectorDesc = Type.getMethodDescriptor((Type)Type.getType(Vec3d.class), (Type[])new Type[]{Type.DOUBLE_TYPE, Type.DOUBLE_TYPE, Type.DOUBLE_TYPE});
        String selfType = Type.getInternalName(BlockSpaceTransform.class);
        for (int i = 0; i < orientations.length; ++i) {
            mv.visitLabel(targets[i]);
            Orientation orientation = orientations[i];
            Matrix3f mat = orientation.getLocalToWorldMatrix();
            if (invert) {
                mat.invert();
            }
            BlockSpaceTransform.createRowVectorMultiplication(mv, mat.m00, mat.m01, mat.m02);
            BlockSpaceTransform.createRowVectorMultiplication(mv, mat.m10, mat.m11, mat.m12);
            BlockSpaceTransform.createRowVectorMultiplication(mv, mat.m20, mat.m21, mat.m22);
            mv.visitMethodInsn(184, selfType, "createVector", createVectorDesc, false);
            mv.visitInsn(176);
        }
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    private static Class<? extends BlockSpaceTransform> createTransformClass() {
        ClassWriter cw = new ClassWriter(1);
        String parentCls = Type.getInternalName(BlockSpaceTransform.class);
        String name = parentCls + "$GeneratedImplementation$";
        cw.visit(50, 4129, name, null, parentCls, new String[0]);
        cw.visitSource(".dynamic", null);
        MethodVisitor mv = cw.visitMethod(1, "<init>", "()V", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, parentCls, "<init>", "()V", false);
        mv.visitInsn(177);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
        String transformMethod = Type.getMethodDescriptor((Type)Type.getType(Vec3d.class), (Type[])new Type[]{Type.getType(Orientation.class), Type.DOUBLE_TYPE, Type.DOUBLE_TYPE, Type.DOUBLE_TYPE});
        MethodVisitor mv2 = cw.visitMethod(4097, "mapWorldToBlock", transformMethod, null, null);
        BlockSpaceTransform.createTransformMethod(mv2, true);
        mv2 = cw.visitMethod(4097, "mapBlockToWorld", transformMethod, null, null);
        BlockSpaceTransform.createTransformMethod(mv2, false);
        cw.visitEnd();
        byte[] clsBytes = cw.toByteArray();
        BytecodeClassLoader loader = new BytecodeClassLoader();
        Class<?> cls = loader.define(clsBytes);
        return cls;
    }

    private static BlockSpaceTransform createTransformInstance() {
        try {
            Class<? extends BlockSpaceTransform> transformClass = BlockSpaceTransform.createTransformClass();
            return transformClass.newInstance();
        }
        catch (Throwable t) {
            throw new Error("Failed to create block space transformer", t);
        }
    }

    public abstract Vec3d mapWorldToBlock(Orientation var1, double var2, double var4, double var6);

    public abstract Vec3d mapBlockToWorld(Orientation var1, double var2, double var4, double var6);

    protected static Vec3d createVector(double x, double y, double z) {
        return new Vec3d(x, y, z);
    }

    public AxisAlignedBB mapWorldToBlock(Orientation orientation, AxisAlignedBB aabb) {
        Vec3d min = this.mapWorldToBlock(orientation, aabb.field_72340_a, aabb.field_72338_b, aabb.field_72339_c);
        Vec3d max = this.mapWorldToBlock(orientation, aabb.field_72336_d, aabb.field_72337_e, aabb.field_72334_f);
        return new AxisAlignedBB(min.field_72450_a, min.field_72448_b, min.field_72449_c, max.field_72450_a, max.field_72448_b, max.field_72449_c);
    }

    public AxisAlignedBB mapBlockToWorld(Orientation orientation, AxisAlignedBB aabb) {
        Vec3d min = this.mapBlockToWorld(orientation, aabb.field_72340_a, aabb.field_72338_b, aabb.field_72339_c);
        Vec3d max = this.mapBlockToWorld(orientation, aabb.field_72336_d, aabb.field_72337_e, aabb.field_72334_f);
        return new AxisAlignedBB(min.field_72450_a, min.field_72448_b, min.field_72449_c, max.field_72450_a, max.field_72448_b, max.field_72449_c);
    }

    private static class BytecodeClassLoader
    extends ClassLoader {
        private BytecodeClassLoader() {
            super(BytecodeClassLoader.class.getClassLoader());
        }

        public Class<?> define(byte[] data) {
            return this.defineClass(null, data, 0, data.length);
        }
    }
}

