/*
 * Decompiled with CFR 0.152.
 */
package openmods.network.event;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.network.handshake.NetworkDispatcher;
import net.minecraftforge.fml.relauncher.Side;
import openmods.network.event.NetworkEventManager;

public abstract class NetworkEvent
extends Event {
    final List<NetworkEvent> replies = Lists.newArrayList();
    NetworkDispatcher dispatcher;
    public EntityPlayer sender;
    public Side side;

    protected abstract void readFromStream(PacketBuffer var1) throws IOException;

    protected abstract void writeToStream(PacketBuffer var1) throws IOException;

    protected void appendLogInfo(List<String> info) {
    }

    public void reply(NetworkEvent reply) {
        Preconditions.checkState((this.dispatcher != null ? 1 : 0) != 0, (Object)"Can't call this method outside event handler");
        reply.dispatcher = this.dispatcher;
        this.replies.add(reply);
    }

    public void sendToAll() {
        NetworkEventManager.dispatcher().senders.global.sendMessage((Object)this);
    }

    public void sendToServer() {
        NetworkEventManager.dispatcher().senders.client.sendMessage((Object)this);
    }

    public void sendToPlayer(EntityPlayer player) {
        NetworkEventManager.dispatcher().senders.player.sendMessage((Object)this, player);
    }

    public void sendToEntity(Entity entity) {
        NetworkEventManager.dispatcher().senders.entity.sendMessage((Object)this, entity);
    }

    public List<Object> serialize() {
        return NetworkEventManager.dispatcher().senders.serialize((Object)this);
    }
}

