/*
 * Decompiled with CFR 0.152.
 */
package openmods.network.rpc;

import com.google.common.base.Preconditions;
import com.google.common.reflect.TypeToken;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import net.minecraft.network.PacketBuffer;
import openmods.network.rpc.NullableArg;
import openmods.serializable.SerializerRegistry;
import openmods.utils.AnnotationMap;
import openmods.utils.io.IStreamReader;
import openmods.utils.io.IStreamSerializer;
import openmods.utils.io.IStreamWriter;

public class MethodParamsCodec {
    private final Method method;
    private final MethodParam[] params;

    MethodParamsCodec(Method method) {
        this.method = method;
        Annotation[][] annotations = method.getParameterAnnotations();
        Class<?>[] types = method.getParameterTypes();
        this.params = new MethodParam[types.length];
        for (int i = 0; i < this.params.length; ++i) {
            MethodParam param = new MethodParam(types[i], annotations[i]);
            try {
                param.validate();
            }
            catch (Exception e) {
                throw new IllegalStateException(String.format("Failed to validate arg %d of method %s", i, method), e);
            }
            this.params[i] = param;
        }
    }

    public void writeArgs(PacketBuffer output, Object ... args) {
        if (args == null) {
            Preconditions.checkArgument((0 == this.params.length ? 1 : 0) != 0, (String)"Argument list length mismatch, expected %d, got 0", (int)this.params.length);
            return;
        }
        Preconditions.checkArgument((args.length == this.params.length ? 1 : 0) != 0, (String)"Argument list length mismatch, expected %d, got %d", (int)this.params.length, (int)args.length);
        for (int i = 0; i < args.length; ++i) {
            MethodParam param = this.params[i];
            try {
                MethodParamsCodec.writeArg(output, i, param.serializer, param.isNullable, args[i]);
                continue;
            }
            catch (Exception e) {
                throw new RuntimeException(String.format("Failed to write argument %d from method %s", i, this.method), e);
            }
        }
    }

    private static void writeArg(PacketBuffer output, int argIndex, IStreamWriter<Object> writer, boolean isNullable, Object value) throws IOException {
        if (isNullable) {
            if (value == null) {
                output.writeBoolean(false);
                return;
            }
            output.writeBoolean(true);
        } else {
            Preconditions.checkNotNull((Object)value, (Object)"Only @NullableArg arguments can be null");
        }
        writer.writeToStream(value, output);
    }

    public Object[] readArgs(PacketBuffer input) {
        if (this.params.length == 0) {
            return null;
        }
        Object[] result = new Object[this.params.length];
        for (int i = 0; i < this.params.length; ++i) {
            MethodParam param = this.params[i];
            try {
                result[i] = MethodParamsCodec.readArg(input, param.serializer, param.isNullable);
                continue;
            }
            catch (Exception e) {
                throw new RuntimeException(String.format("Failed to read argument %d from method %s", i, this.method), e);
            }
        }
        return result;
    }

    private static Object readArg(PacketBuffer input, IStreamReader<Object> reader, boolean isNullable) throws IOException {
        boolean hasValue;
        if (isNullable && !(hasValue = input.readBoolean())) {
            return null;
        }
        return reader.readFromStream(input);
    }

    private static class MethodParam {
        public final Type type;
        public final boolean isNullable;
        public final IStreamSerializer<Object> serializer;

        public MethodParam(Type type, Annotation[] annotations) {
            this.type = type;
            AnnotationMap annotationsMap = new AnnotationMap(annotations);
            this.isNullable = annotationsMap.hasAnnotation(NullableArg.class);
            this.serializer = SerializerRegistry.instance.findSerializer(type);
            Preconditions.checkNotNull(this.serializer, (String)"Failed to find serializer for type %s", (Object)type);
        }

        public void validate() {
            this.validate(TypeToken.of((Type)this.type));
        }

        private void validate(TypeToken<?> type) {
            Preconditions.checkState((!type.isPrimitive() || !this.isNullable ? 1 : 0) != 0, (Object)"Primitive types can't be nullable");
            if (type.isArray()) {
                this.validate(type.getComponentType());
            }
        }

        public String toString() {
            return "MethodParam [type=" + this.type + ", nullable=" + this.isNullable + "]";
        }
    }
}

