# NanoFog
NanoFog is a shield system that can be setup from OpenComputers and configured to your desires

## NanoFog Terminal
![NanoFog Terminal](https://i.imgur.com/4zwZZfk.png)

The Terminal holds the Fuel and is the Component used to configure the shield, also its the power source and origin for the NanoFog

Recipe:
* 1x Wireless Network Card (Tier2)
* 1x Control Unit (CU)
* 2x Microchip (Tier2)
* 2x Transistor
* 3x Capacitor

![NanoFog Terminal GUI](https://i.imgur.com/xcMutc6.png)

The GUI shows Material Input/Output and energy usage



Animation and Resolution for NanoFog can be disabled in the mod configuration.


## Methods
```lua
nanofog_terminal = component.os_nanofog_terminal
```

```lua
set(int:x, int:y, int:z, String:blockName, int:blockMetaindex):boolean 
-- sets a fog block in the world
-- metaindex is optional (defaults to 0)
```
blockName has to be a minecraft item name like "glass", "sand" for blocks from other mods with the same name use full name syntax, e.g. "opencomputers:chameliumblock"

```lua
setArea(int:x1, int:y1, int:z1, int:x2, int:y2, int:z2, String:blockName, int:blockMetaindex):boolean
-- sets fog in the defined area, usage like `set` method
```
```lua
reset(int:x, int:y, int:z):boolean 
-- removes a fog block from the world
```

NanoDNA is put back to the NanoFog Terminal Inventory when enough energy and inventory space are available, otherwise they will drop into the world (with full inventory and enough energy the fog will still return but drop at the terminal location)

```lua
resetAll():boolean 
-- removes all fog blocks assigned to this terminal from the world
```

### fog block config
```lua
setShield(int:x, int:y, int:z):boolean 
-- sets a block to shield mode (walkthrough possible for anyone)
```
```lua
setSolid(int:x, int:y, int:z):boolean
-- sets a block to solid mode 
-- walkthroug only possible for entities on the pass filter
```
```lua
setKnockback(int:x, int:y, int:z, int:power):boolean 
-- sets the power for knockback of entities that aren't allowed to pass the fog
-- valid values for power [0, 1, 2]
```
```lua
setDamage(int:x, int:y, int:z, int:power):boolean 
-- sets the amount of damage dealt to entities on the damage filter
-- valid values for damage [0 - 5]
```
```lua
getMaterial():integer
-- returns the current material input (the output is not reported)
```
```lua
get(int:x, int:y, int:z):string 
-- tells you if a block is air/nanofog or anything else
```

### filter methods
```lua
setFilter(int:x, int:y, int:z, String:type/class, boolean:allowPass, boolean:damageEntity, String:name):boolean
-- sets/removes a filter for the specified entity type/class
-- all entities of the defined type will be filtered when no name argument is specified.
-- types: player, hostile, animal, item, all
```
```lua
getFilterPass(int:x, int:y, int:z):array
-- returns the pass filter list for the defined block
```
```lua
getFilterDamage(int:x, int:y, int:z):array
-- returns the damage filter list for the defined block
```
```lua
getEntityClassNames():array
-- returns a list of entity class names that can be used in the filter
```