## Security Terminal

![](https://i.imgur.com/0y5OZhf.png)

allows you to protect the blocks in an area from getting mined by unauthorized users

### Methods
```lua
isEnabled():boolean
-- returns the status of the block
```
```lua
addUser(String:Password, String:Username):boolean
-- adds the Minecraft User as an allowed user.
```
```lua
delUser(String:Username):boolean 
-- removes the Minecraft User as an allowed user.
```
```lua
setPassword(String:password):boolean 
-- sets the block password, required to enable/disable and other actions
```
```lua
toggleParticle():boolean 
-- switches particles to show the corners of the protected area
```
```lua
setRange(Int:range):boolean -- valid values [1 - 4]
-- sets the range of the protction area 8*range 
-- increasing range increases energy cost.
```
```lua
enable(String:password):boolean 
-- enables the block, requires the correct password
```
```lua
disable(String:password):boolean 
-- disables the block, requires the correct password
```
```lua
getAllowedUsers(String:password):boolean 
-- returns a comma delimited string of current allowed users.
```