# Blocks
## OSAlarm

Computer or Redstone controlled though right now there is no way to change the alarm sound outside of computer control.

### Methods:
    alarm = component.os_alarm

    alarm.setAlarm("klaxon2") Allows you to change the alarm played, 
    the default config is klaxon1 and klaxon2 and the default sound is klaxon1

    alarm.setRange(15-150) Sets the range in blocks from the alarm block, allowed range is 15 - 150
    alarm.activate() It.. activates the alarm.
    alarm.listSounds() returns a table of configured alarms.
    alarm.deactivate() It.. deactivates the alarm.

## RFID Reader Block

RFID Reader Block you to read RFID Cards in a players inventory

### Methods
    rfid = component.os_rfidreader
    rfid.scan(optional int:1-64)
Scans for all entites for RFIDs within range default is 16 blocks, if you specify an integer it will scan that area, large areas can cause lag.
This will queue a signal with the name rfidData 4 parameters will be returned: uuid, playerName, distance, and data.
It will also return the data in a table.
The max range is configurable in the mod's config file, though the maximum is 64 blocks even there.

### Example Program:

    output = component.os_rfidreader.scan(10)
    for k, v in pairs(output[1]) do
      print(k, v)
    end
It would return:
    name
    range
    data
    uuid
    locked

## Card Writer

Card Writer, writes RFID, MagCards and EEPROMs.
### Methods:
    writer = component.os_cardwriter
    writer.write(string: Data, string: DisplayName, Optional Boolean:locked)
    writer.write("Test Data", "Display", true)
Will write "Test Data" to a card, name it "Display" and lock it     from further writing, the same method works on RFID and MagStrip cards,
though the limit on string length is different from both, 64 characters for RFID, and 128 for MagStrip.
the first call to write will also assign the card a UUID to help identify your cards.

### Events:

```
event, address = event.pull("cardInsert")
```

The cardInsert event is triggered when a rfid or mag card is inserted. 

```
event, address = event.pull("cardRemove")
```

The cardRemove event is triggered when you remove the card.

event is the event name, address is the card writer address

## Mag Card Reader

Reads Mag Cards when right clicked.

### Methods:
Methods:
setEventName(string eventName) Sets the event name returned when you click it with a card, default is magData
This block queues signals when it is clicked with a MagStrip card.
The signal name is magData, it returns playerName, data, UUID, locked.


## Entity Detector

Entity Detector allows you to detect any entities around the block
Methods:

    entity = component.os_entdetector
    entity.scanPlayers(optional int:1-64) Returns a table of detected entities, also queues a signal for each entity found "entityDetect",
    with name, range, x, y, z

    entity.scanEntities(optional int:1-64) Returns a table of detected entities, also queues a signal for each entity found "entityDetect",
    with name, range, x, y, z (This omits players, but can include dropped items)

## Door Controller

Door Controller allows you to operate Security Doors. Can only be broken by a person in Creative or the person who placed it.

### Methods
    NOTE: in 1.10+ the door controller component is renamed to os_doorcontroller
    doorcontroller = component.os_door
    
    doorcontroller.toggle() Opens or Closes the Door
    doorcontroller.isOpen() Returns True if the door is open, False if it is closed

## Security Door

Door that can only be operated using the Door Controller. Can only be broken by a person in Creative or the person who placed it.

## Data Block

Provides the functionality of a Data Card, but in block form.

### Methods

The methods are available on the OpenComputers Wiki: http://ocdoc.cil.li/component:data

## Switchable Hub

Allows you to disconnect network segments via computer control

### Methods

    hub = component.os_switchablehub
    
    hub.setSide(int: side, boolean: enabled)
    hub.setSide(sides.left, true)
Will set the left side to allow connections.

## KVM Switch

Allows you to switch inputs to a single output, useful for multiple computers connected to the same monitor/keyboard.

## Keypad

A Keypad with buttons you can press to raise events to attached computers

### Methods
    keypad = component.os_keypad
    keypad.setEventName("eventName") --Sets the event name returned when you press a button, default is keypad
    keypad.setDisplay("displayText", optional int:textColor) --textColor is a minecraft color code
    
    --Custom button labels and colors
    customButtons = {"1", "2", "3", "4", "5", "6", "7", "8", "9", "*", "0", "#"} --This is the default order, change any of them to change the button label in that place.
    customButtonColor = {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1} --This works the same as button labels, but it takes a color code to color the button label in that position.
    keypad.setKey(customButtons, customButtonColor)

### Events:
    
```
event, address, button, button_label = event.pull("keypad")
```
Button is the button id, button_label is the current button label.

## Energy Turret

A energy turret, uses OC Energy to fire energy beams at targets!

### Methods
    turret = component.os_energyturret
    turret.powerOn() Turns the turret on, it needs to be on before you can call any other commands.
    turret.powerOff() Turns the turret off.
    turret.isReady() Returns true if the turret has cooled from it's previous fire, is armed, and the barrel is valid, else false.
    turret.isPowered() returns true if the turret is powered on, else false.
    turret.setArmed(boolean) true/false = Arms and disarms the turret, must be armed to fire.
    turret.extendShaft(int) Valid range (0-2) extends/retracts the rotator shaft, must be at least 1 to fire.
    turret.getShaftLength() Returns the shaft length.
    turret.moveToRadians(int, int) Moves the turret in radians instead of degrees.
    turret.moveTo(int, int) Valid ranges: (0-360), (-45,90) Moves the turret's aim to the provided coords and tries to use shortest rotation to move to them as quick as possible.
    turret.isOnPoint() returns true if the turret has finished moving to it's target, false if not
    turret.fire() returns true if fired, or nil, error if it was unable to fire, not enough energy, or gun hasn't cooled down

The Energy Turret also has upgrade slots in it's GUI you can upgrade it's Damage, Movement speed, Cooldown time, and Energy Usage.