/*
 * Decompiled with CFR 0.152.
 */
package lotr.client.render;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.util.List;
import java.util.UUID;
import lotr.client.LOTRClientProxy;
import lotr.client.LOTRTickHandlerClient;
import lotr.client.render.LOTRRenderShield;
import lotr.client.render.entity.LOTRNPCRendering;
import lotr.common.LOTRConfig;
import lotr.common.LOTRLevelData;
import lotr.common.LOTRPlayerData;
import lotr.common.LOTRShields;
import lotr.common.fac.LOTRAlignmentValues;
import lotr.common.fellowship.LOTRFellowshipClient;
import lotr.common.world.LOTRWorldProvider;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.entity.RendererLivingEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.MathHelper;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.common.MinecraftForge;
import org.lwjgl.opengl.GL11;

public class LOTRRenderPlayer {
    private Minecraft mc = Minecraft.func_71410_x();
    private RenderManager renderManager = RenderManager.field_78727_a;

    public LOTRRenderPlayer() {
        FMLCommonHandler.instance().bus().register((Object)this);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void preRenderSpecials(RenderPlayerEvent.Specials.Pre event) {
        EntityPlayer entityplayer = event.entityPlayer;
        float tick = event.partialRenderTick;
        LOTRShields shield = LOTRLevelData.getData(entityplayer).getShield();
        if (shield != null) {
            if (!entityplayer.func_82150_aj()) {
                LOTRRenderShield.renderShield(shield, (EntityLivingBase)entityplayer, event.renderer.field_77109_a);
            } else if (!entityplayer.func_98034_c((EntityPlayer)this.mc.field_71439_g)) {
                GL11.glPushMatrix();
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.15f);
                GL11.glDepthMask((boolean)false);
                GL11.glEnable((int)3042);
                GL11.glBlendFunc((int)770, (int)771);
                GL11.glAlphaFunc((int)516, (float)0.003921569f);
                LOTRRenderShield.renderShield(shield, (EntityLivingBase)entityplayer, event.renderer.field_77109_a);
                GL11.glDisable((int)3042);
                GL11.glAlphaFunc((int)516, (float)0.1f);
                GL11.glPopMatrix();
                GL11.glDepthMask((boolean)true);
            }
        }
    }

    @SubscribeEvent
    public void postRender(RenderPlayerEvent.Post event) {
        float yOffset;
        EntityPlayer entityplayer = event.entityPlayer;
        float tick = event.partialRenderTick;
        double d0 = RenderManager.field_78725_b;
        double d1 = RenderManager.field_78726_c;
        double d2 = RenderManager.field_78723_d;
        float f0 = (float)entityplayer.field_70142_S + (float)(entityplayer.field_70165_t - entityplayer.field_70142_S) * tick;
        float f1 = (float)entityplayer.field_70137_T + (float)(entityplayer.field_70163_u - entityplayer.field_70137_T) * tick;
        float f2 = (float)entityplayer.field_70136_U + (float)(entityplayer.field_70161_v - entityplayer.field_70136_U) * tick;
        float fr0 = f0 - (float)d0;
        float fr1 = f1 - (float)d1;
        float fr2 = f2 - (float)d2;
        float f = yOffset = entityplayer.func_70608_bn() ? -1.5f : 0.0f;
        if (this.shouldRenderAlignment(entityplayer) && (this.mc.field_71441_e.field_73011_w instanceof LOTRWorldProvider || LOTRConfig.alwaysShowAlignment)) {
            float range;
            LOTRPlayerData clientPD = LOTRLevelData.getData((EntityPlayer)this.mc.field_71439_g);
            LOTRPlayerData otherPD = LOTRLevelData.getData(entityplayer);
            float alignment = otherPD.getAlignment(clientPD.getViewingFaction());
            double dist = entityplayer.func_70068_e((Entity)this.renderManager.field_78734_h);
            if (dist < (double)((range = RendererLivingEntity.NAME_TAG_RANGE) * range)) {
                FontRenderer fr = Minecraft.func_71410_x().field_71466_p;
                GL11.glPushMatrix();
                GL11.glTranslatef((float)fr0, (float)fr1, (float)fr2);
                GL11.glTranslatef((float)0.0f, (float)(entityplayer.field_70131_O + 0.6f + yOffset), (float)0.0f);
                GL11.glNormal3f((float)0.0f, (float)1.0f, (float)0.0f);
                GL11.glRotatef((float)(-this.renderManager.field_78735_i), (float)0.0f, (float)1.0f, (float)0.0f);
                GL11.glRotatef((float)this.renderManager.field_78732_j, (float)1.0f, (float)0.0f, (float)0.0f);
                GL11.glScalef((float)-1.0f, (float)-1.0f, (float)1.0f);
                float scale = 0.025f;
                GL11.glScalef((float)scale, (float)scale, (float)scale);
                GL11.glDisable((int)2896);
                GL11.glDepthMask((boolean)false);
                GL11.glDisable((int)2929);
                GL11.glEnable((int)3042);
                GL11.glBlendFunc((int)770, (int)771);
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                String sAlign = LOTRAlignmentValues.formatAlignForDisplay(alignment);
                this.mc.func_110434_K().func_110577_a(LOTRClientProxy.alignmentTexture);
                LOTRTickHandlerClient.drawTexturedModalRect(-MathHelper.func_76128_c((double)((double)(fr.func_78256_a(sAlign) + 18) / 2.0)), -19.0, 0, 36, 16, 16);
                LOTRTickHandlerClient.drawAlignmentText(fr, 18 - MathHelper.func_76128_c((double)((double)(fr.func_78256_a(sAlign) + 18) / 2.0)), -12, sAlign, 1.0f);
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GL11.glDisable((int)3042);
                GL11.glEnable((int)2929);
                GL11.glDepthMask((boolean)true);
                GL11.glEnable((int)2896);
                GL11.glDisable((int)32826);
                GL11.glPopMatrix();
            }
        }
        if (this.shouldRenderFellowPlayerHealth(entityplayer)) {
            LOTRNPCRendering.renderHealthBar((EntityLivingBase)entityplayer, fr0, fr1, fr2, new int[]{16375808, 12006707}, null);
        }
    }

    private boolean shouldRenderPlayerHUD(EntityPlayer entityplayer) {
        if (Minecraft.func_71382_s()) {
            return entityplayer != this.renderManager.field_78734_h && !entityplayer.func_70093_af() && !entityplayer.func_98034_c((EntityPlayer)this.mc.field_71439_g);
        }
        return false;
    }

    private boolean shouldRenderAlignment(EntityPlayer entityplayer) {
        if (LOTRConfig.displayAlignmentAboveHead && this.shouldRenderPlayerHUD(entityplayer)) {
            if (LOTRLevelData.getData(entityplayer).getHideAlignment()) {
                UUID playerUuid = entityplayer.func_110124_au();
                List<LOTRFellowshipClient> fellowships = LOTRLevelData.getData((EntityPlayer)this.mc.field_71439_g).getClientFellowships();
                for (LOTRFellowshipClient fs : fellowships) {
                    if (!fs.containsPlayer(playerUuid)) continue;
                    return true;
                }
                return false;
            }
            return true;
        }
        return false;
    }

    private boolean shouldRenderFellowPlayerHealth(EntityPlayer entityplayer) {
        if (LOTRConfig.fellowPlayerHealthBars && this.shouldRenderPlayerHUD(entityplayer)) {
            List<LOTRFellowshipClient> fellowships = LOTRLevelData.getData((EntityPlayer)this.mc.field_71439_g).getClientFellowships();
            for (LOTRFellowshipClient fs : fellowships) {
                if (!fs.containsPlayer(entityplayer.func_110124_au())) continue;
                return true;
            }
        }
        return false;
    }
}

