/*
 * Decompiled with CFR 0.152.
 */
package lotr.client.render;

import lotr.common.LOTRMod;
import lotr.common.LOTRShields;
import lotr.common.entity.npc.LOTREntityNPC;
import lotr.common.item.LOTRItemArmor;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.item.ItemTool;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class LOTRRenderShield {
    private static int SHIELD_WIDTH = 32;
    private static int SHIELD_HEIGHT = 32;
    private static float MODELSCALE = 0.0625f;

    public static void renderShield(LOTRShields shield, EntityLivingBase entity, ModelBiped model) {
        boolean blocking;
        ItemStack inUse;
        Minecraft mc = Minecraft.func_71410_x();
        ResourceLocation shieldTexture = shield.shieldTexture;
        ItemStack held = entity == null ? null : entity.func_70694_bm();
        ItemStack heldLeft = entity instanceof LOTREntityNPC ? ((LOTREntityNPC)entity).getHeldItemLeft() : null;
        ItemStack itemStack = inUse = entity instanceof EntityPlayer ? ((EntityPlayer)entity).func_71011_bu() : null;
        boolean holdingSword = entity == null ? true : !(held == null || !(held.func_77973_b() instanceof ItemSword) && !(held.func_77973_b() instanceof ItemTool) || inUse != null && inUse.func_77975_n() == EnumAction.bow);
        boolean bl = blocking = holdingSword && inUse != null && inUse.func_77975_n() == EnumAction.block;
        if (heldLeft != null && entity instanceof LOTREntityNPC) {
            LOTREntityNPC npc = (LOTREntityNPC)entity;
            if (npc.npcCape != null) {
                return;
            }
        }
        ItemStack chestplate = entity == null ? null : entity.func_71124_b(3);
        boolean wearingChestplate = chestplate != null && chestplate.func_77973_b().isValidArmor(chestplate, ((LOTRItemArmor)LOTRMod.bodyMithril).field_77881_a, (Entity)entity);
        boolean renderOnBack = !holdingSword || holdingSword && heldLeft != null;
        GL11.glPushMatrix();
        if (renderOnBack) {
            model.field_78115_e.func_78794_c(MODELSCALE);
        } else {
            model.field_78113_g.func_78794_c(MODELSCALE);
        }
        GL11.glScalef((float)-1.5f, (float)-1.5f, (float)1.5f);
        if (renderOnBack) {
            GL11.glTranslatef((float)0.5f, (float)-0.8f, (float)0.0f);
            if (wearingChestplate) {
                GL11.glTranslatef((float)0.0f, (float)0.0f, (float)0.24f);
            } else {
                GL11.glTranslatef((float)0.0f, (float)0.0f, (float)0.16f);
            }
            GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        } else if (blocking) {
            GL11.glRotatef((float)10.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glTranslatef((float)-0.4f, (float)-0.9f, (float)-0.15f);
        } else {
            GL11.glRotatef((float)60.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glTranslatef((float)-0.5f, (float)-0.75f, (float)0.0f);
            if (wearingChestplate) {
                GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-0.24f);
            } else {
                GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-0.16f);
            }
            GL11.glRotatef((float)-15.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        }
        mc.func_110434_K().func_110577_a(shieldTexture);
        GL11.glEnable((int)3008);
        LOTRRenderShield.doRenderShield(0.0f);
        GL11.glTranslatef((float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glScalef((float)-1.0f, (float)1.0f, (float)1.0f);
        LOTRRenderShield.doRenderShield(0.5f);
        GL11.glPopMatrix();
    }

    private static void doRenderShield(float f) {
        float f9;
        float f8;
        float f7;
        int k;
        float minU = 0.0f + f;
        float maxU = 0.5f + f;
        float minV = 0.0f;
        float maxV = 1.0f;
        int width = SHIELD_WIDTH;
        int height = SHIELD_HEIGHT;
        double depth1 = MODELSCALE * 0.5f * f;
        double depth2 = MODELSCALE * 0.5f * (0.5f + f);
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78375_b(0.0f, 0.0f, 1.0f);
        tessellator.func_78374_a(0.0, 0.0, depth1, (double)maxU, (double)maxV);
        tessellator.func_78374_a(1.0, 0.0, depth1, (double)minU, (double)maxV);
        tessellator.func_78374_a(1.0, 1.0, depth1, (double)minU, (double)minV);
        tessellator.func_78374_a(0.0, 1.0, depth1, (double)maxU, (double)minV);
        tessellator.func_78381_a();
        tessellator.func_78382_b();
        tessellator.func_78375_b(0.0f, 0.0f, -1.0f);
        tessellator.func_78374_a(0.0, 1.0, depth2, (double)maxU, (double)minV);
        tessellator.func_78374_a(1.0, 1.0, depth2, (double)minU, (double)minV);
        tessellator.func_78374_a(1.0, 0.0, depth2, (double)minU, (double)maxV);
        tessellator.func_78374_a(0.0, 0.0, depth2, (double)maxU, (double)maxV);
        tessellator.func_78381_a();
        float f5 = 0.5f * (maxU - minU) / (float)width;
        float f6 = 0.5f * (maxV - minV) / (float)height;
        tessellator.func_78382_b();
        tessellator.func_78375_b(-1.0f, 0.0f, 0.0f);
        for (k = 0; k < width; ++k) {
            f7 = (float)k / (float)width;
            f8 = maxU + (minU - maxU) * f7 - f5;
            tessellator.func_78374_a((double)f7, 0.0, depth2, (double)f8, (double)maxV);
            tessellator.func_78374_a((double)f7, 0.0, depth1, (double)f8, (double)maxV);
            tessellator.func_78374_a((double)f7, 1.0, depth1, (double)f8, (double)minV);
            tessellator.func_78374_a((double)f7, 1.0, depth2, (double)f8, (double)minV);
        }
        tessellator.func_78381_a();
        tessellator.func_78382_b();
        tessellator.func_78375_b(1.0f, 0.0f, 0.0f);
        for (k = 0; k < width; ++k) {
            f7 = (float)k / (float)width;
            f8 = maxU + (minU - maxU) * f7 - f5;
            f9 = f7 + 1.0f / (float)width;
            tessellator.func_78374_a((double)f9, 1.0, depth2, (double)f8, (double)minV);
            tessellator.func_78374_a((double)f9, 1.0, depth1, (double)f8, (double)minV);
            tessellator.func_78374_a((double)f9, 0.0, depth1, (double)f8, (double)maxV);
            tessellator.func_78374_a((double)f9, 0.0, depth2, (double)f8, (double)maxV);
        }
        tessellator.func_78381_a();
        tessellator.func_78382_b();
        tessellator.func_78375_b(0.0f, 1.0f, 0.0f);
        for (k = 0; k < height; ++k) {
            f7 = (float)k / (float)height;
            f8 = maxV + (minV - maxV) * f7 - f6;
            f9 = f7 + 1.0f / (float)height;
            tessellator.func_78374_a(0.0, (double)f9, depth1, (double)maxU, (double)f8);
            tessellator.func_78374_a(1.0, (double)f9, depth1, (double)minU, (double)f8);
            tessellator.func_78374_a(1.0, (double)f9, depth2, (double)minU, (double)f8);
            tessellator.func_78374_a(0.0, (double)f9, depth2, (double)maxU, (double)f8);
        }
        tessellator.func_78381_a();
        tessellator.func_78382_b();
        tessellator.func_78375_b(0.0f, -1.0f, 0.0f);
        for (k = 0; k < height; ++k) {
            f7 = (float)k / (float)height;
            f8 = maxV + (minV - maxV) * f7 - f6;
            tessellator.func_78374_a(1.0, (double)f7, depth1, (double)minU, (double)f8);
            tessellator.func_78374_a(0.0, (double)f7, depth1, (double)maxU, (double)f8);
            tessellator.func_78374_a(0.0, (double)f7, depth2, (double)maxU, (double)f8);
            tessellator.func_78374_a(1.0, (double)f7, depth2, (double)minU, (double)f8);
        }
        tessellator.func_78381_a();
    }
}

