/*
 * Decompiled with CFR 0.152.
 */
package lotr.client.render;

import java.util.Random;
import lotr.client.LOTRTickHandlerClient;
import lotr.common.LOTRConfig;
import lotr.common.LOTRMod;
import lotr.common.world.biome.LOTRBiomeGenDagorlad;
import lotr.common.world.biome.LOTRBiomeGenFarHaradVolcano;
import lotr.common.world.biome.LOTRBiomeGenMordor;
import lotr.common.world.biome.LOTRBiomeGenMorgulVale;
import lotr.common.world.biome.LOTRBiomeGenNurn;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.EntityRenderer;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.client.IRenderHandler;
import org.lwjgl.opengl.GL11;

public class LOTRWeatherRenderer
extends IRenderHandler {
    private static final ResourceLocation rainTexture = new ResourceLocation("lotr:weather/rain.png");
    private static final ResourceLocation snowTexture = new ResourceLocation("lotr:weather/snow.png");
    private static final ResourceLocation ashTexture = new ResourceLocation("lotr:weather/ash.png");
    private static final ResourceLocation sandstormTexture = new ResourceLocation("lotr:weather/sandstorm.png");
    private static final ResourceLocation rainTexture_def = new ResourceLocation("textures/environment/rain.png");
    private static final ResourceLocation snowTexture_def = new ResourceLocation("textures/environment/snow.png");
    private Random rand = new Random();
    private float[] rainXCoords;
    private float[] rainYCoords;

    public void render(float partialTicks, WorldClient world, Minecraft mc) {
        EntityRenderer er = mc.field_71460_t;
        int rendererUpdateCount = LOTRTickHandlerClient.clientTick;
        float rainStrength = world.func_72867_j(partialTicks);
        if (rainStrength > 0.0f) {
            er.func_78463_b((double)partialTicks);
            if (this.rainXCoords == null) {
                this.rainXCoords = new float[1024];
                this.rainYCoords = new float[1024];
                for (int i = 0; i < 32; ++i) {
                    for (int j = 0; j < 32; ++j) {
                        float f2 = j - 16;
                        float f3 = i - 16;
                        float f4 = MathHelper.func_76129_c((float)(f2 * f2 + f3 * f3));
                        this.rainXCoords[i << 5 | j] = -f3 / f4;
                        this.rainYCoords[i << 5 | j] = f2 / f4;
                    }
                }
            }
            EntityLivingBase entitylivingbase = mc.field_71451_h;
            int k2 = MathHelper.func_76128_c((double)entitylivingbase.field_70165_t);
            int l2 = MathHelper.func_76128_c((double)entitylivingbase.field_70163_u);
            int i3 = MathHelper.func_76128_c((double)entitylivingbase.field_70161_v);
            Tessellator tessellator = Tessellator.field_78398_a;
            GL11.glDisable((int)2884);
            GL11.glNormal3f((float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glEnable((int)3042);
            OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
            GL11.glAlphaFunc((int)516, (float)0.1f);
            double d0 = entitylivingbase.field_70142_S + (entitylivingbase.field_70165_t - entitylivingbase.field_70142_S) * (double)partialTicks;
            double d1 = entitylivingbase.field_70137_T + (entitylivingbase.field_70163_u - entitylivingbase.field_70137_T) * (double)partialTicks;
            double d2 = entitylivingbase.field_70136_U + (entitylivingbase.field_70161_v - entitylivingbase.field_70136_U) * (double)partialTicks;
            int k = MathHelper.func_76128_c((double)d1);
            int b0 = 5;
            if (mc.field_71474_y.field_74347_j) {
                b0 = 10;
            }
            boolean flag = false;
            int b1 = -1;
            float f5 = (float)rendererUpdateCount + partialTicks;
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            flag = false;
            boolean isChristmas = LOTRMod.isChristmas();
            for (int l = i3 - b0; l <= i3 + b0; ++l) {
                for (int i1 = k2 - b0; i1 <= k2 + b0; ++i1) {
                    float f15;
                    float f14;
                    double d4;
                    float f11;
                    float f10;
                    int j1 = (l - i3 + 16) * 32 + i1 - k2 + 16;
                    float f6 = this.rainXCoords[j1] * 0.5f;
                    float f7 = this.rainYCoords[j1] * 0.5f;
                    BiomeGenBase biomegenbase = world.func_72807_a(i1, l);
                    boolean rainy = biomegenbase.func_76738_d();
                    boolean snowy = biomegenbase.func_76746_c();
                    boolean ashy = biomegenbase instanceof LOTRBiomeGenMordor && !(biomegenbase instanceof LOTRBiomeGenNurn) && !(biomegenbase instanceof LOTRBiomeGenMorgulVale) || biomegenbase instanceof LOTRBiomeGenFarHaradVolcano || biomegenbase instanceof LOTRBiomeGenDagorlad;
                    boolean sandy = LOTRWeatherRenderer.isSandstormBiome(biomegenbase);
                    if (isChristmas) {
                        ashy = false;
                        sandy = false;
                    }
                    if (!rainy && !snowy && !ashy && !sandy) continue;
                    int k1 = world.func_72874_g(i1, l);
                    int l1 = l2 - b0;
                    int i2 = l2 + b0;
                    if (l1 < k1) {
                        l1 = k1;
                    }
                    if (i2 < k1) {
                        i2 = k1;
                    }
                    float f8 = 1.0f;
                    int j2 = k1;
                    if (k1 < k) {
                        j2 = k;
                    }
                    if (l1 == i2) continue;
                    this.rand.setSeed(i1 * i1 * 3121 + i1 * 45238971 ^ l * l * 418711 + l * 13761);
                    float f9 = biomegenbase.func_150564_a(i1, l1, l);
                    if (ashy) {
                        if (b1 != 1) {
                            if (b1 >= 0) {
                                tessellator.func_78381_a();
                            }
                            b1 = 1;
                            mc.func_110434_K().func_110577_a(ashTexture);
                            tessellator.func_78382_b();
                        }
                        f10 = ((float)(rendererUpdateCount & 0x1FF) + partialTicks) / 512.0f;
                        float f16 = this.rand.nextFloat() * 0.3f + f5 * 0.003f * (float)this.rand.nextGaussian();
                        f11 = this.rand.nextFloat() + f5 * (float)this.rand.nextGaussian() * 0.001f;
                        d4 = (double)((float)i1 + 0.5f) - entitylivingbase.field_70165_t;
                        double d5 = (double)((float)l + 0.5f) - entitylivingbase.field_70161_v;
                        f14 = MathHelper.func_76133_a((double)(d4 * d4 + d5 * d5)) / (float)b0;
                        f15 = 1.0f;
                        tessellator.func_78380_c((world.func_72802_i(i1, j2, l, 0) * 3 + 0xF000F0) / 4);
                        tessellator.func_78369_a(f15, f15, f15, ((1.0f - f14 * f14) * 0.3f + 0.5f) * rainStrength);
                        tessellator.func_78373_b(-d0 * 1.0, -d1 * 1.0, -d2 * 1.0);
                        tessellator.func_78374_a((double)((float)i1 - f6) + 0.5, (double)l1, (double)((float)l - f7) + 0.5, (double)(0.0f * f8 + f16), (double)((float)l1 * f8 / 4.0f + f10 * f8 + f11));
                        tessellator.func_78374_a((double)((float)i1 + f6) + 0.5, (double)l1, (double)((float)l + f7) + 0.5, (double)(1.0f * f8 + f16), (double)((float)l1 * f8 / 4.0f + f10 * f8 + f11));
                        tessellator.func_78374_a((double)((float)i1 + f6) + 0.5, (double)i2, (double)((float)l + f7) + 0.5, (double)(1.0f * f8 + f16), (double)((float)i2 * f8 / 4.0f + f10 * f8 + f11));
                        tessellator.func_78374_a((double)((float)i1 - f6) + 0.5, (double)i2, (double)((float)l - f7) + 0.5, (double)(0.0f * f8 + f16), (double)((float)i2 * f8 / 4.0f + f10 * f8 + f11));
                        tessellator.func_78373_b(0.0, 0.0, 0.0);
                        continue;
                    }
                    if (sandy) {
                        if (b1 != 1) {
                            if (b1 >= 0) {
                                tessellator.func_78381_a();
                            }
                            b1 = 1;
                            mc.func_110434_K().func_110577_a(sandstormTexture);
                            tessellator.func_78382_b();
                        }
                        f10 = ((float)(rendererUpdateCount & 0x1FF) + partialTicks) / 512.0f;
                        float f16 = f5 * (0.07f + (float)this.rand.nextGaussian() * 0.01f);
                        f11 = this.rand.nextFloat() + f5 * (float)this.rand.nextGaussian() * 0.001f;
                        d4 = (double)((float)i1 + 0.5f) - entitylivingbase.field_70165_t;
                        double d5 = (double)((float)l + 0.5f) - entitylivingbase.field_70161_v;
                        f14 = MathHelper.func_76133_a((double)(d4 * d4 + d5 * d5)) / (float)b0;
                        f15 = 1.0f;
                        tessellator.func_78380_c((world.func_72802_i(i1, j2, l, 0) * 3 + 0xF000F0) / 4);
                        tessellator.func_78369_a(f15, f15, f15, ((1.0f - f14 * f14) * 0.3f + 0.5f) * rainStrength);
                        tessellator.func_78373_b(-d0 * 1.0, -d1 * 1.0, -d2 * 1.0);
                        tessellator.func_78374_a((double)((float)i1 - f6) + 0.5, (double)l1, (double)((float)l - f7) + 0.5, (double)(0.0f * f8 + f16), (double)((float)l1 * f8 / 4.0f + f10 * f8 + f11));
                        tessellator.func_78374_a((double)((float)i1 + f6) + 0.5, (double)l1, (double)((float)l + f7) + 0.5, (double)(1.0f * f8 + f16), (double)((float)l1 * f8 / 4.0f + f10 * f8 + f11));
                        tessellator.func_78374_a((double)((float)i1 + f6) + 0.5, (double)i2, (double)((float)l + f7) + 0.5, (double)(1.0f * f8 + f16), (double)((float)i2 * f8 / 4.0f + f10 * f8 + f11));
                        tessellator.func_78374_a((double)((float)i1 - f6) + 0.5, (double)i2, (double)((float)l - f7) + 0.5, (double)(0.0f * f8 + f16), (double)((float)i2 * f8 / 4.0f + f10 * f8 + f11));
                        tessellator.func_78373_b(0.0, 0.0, 0.0);
                        continue;
                    }
                    if (world.func_72959_q().func_76939_a(f9, k1) >= 0.15f) {
                        if (b1 != 0) {
                            if (b1 >= 0) {
                                tessellator.func_78381_a();
                            }
                            b1 = 0;
                            if (LOTRConfig.newWeather) {
                                mc.func_110434_K().func_110577_a(rainTexture);
                            } else {
                                mc.func_110434_K().func_110577_a(rainTexture_def);
                            }
                            tessellator.func_78382_b();
                        }
                        f10 = ((float)(rendererUpdateCount + i1 * i1 * 3121 + i1 * 45238971 + l * l * 418711 + l * 13761 & 0x1F) + partialTicks) / 32.0f * (3.0f + this.rand.nextFloat());
                        double d3 = (double)((float)i1 + 0.5f) - entitylivingbase.field_70165_t;
                        d4 = (double)((float)l + 0.5f) - entitylivingbase.field_70161_v;
                        float f12 = MathHelper.func_76133_a((double)(d3 * d3 + d4 * d4)) / (float)b0;
                        float f13 = 1.0f;
                        tessellator.func_78380_c(world.func_72802_i(i1, j2, l, 0));
                        tessellator.func_78369_a(f13, f13, f13, ((1.0f - f12 * f12) * 0.5f + 0.5f) * rainStrength);
                        tessellator.func_78373_b(-d0 * 1.0, -d1 * 1.0, -d2 * 1.0);
                        tessellator.func_78374_a((double)((float)i1 - f6) + 0.5, (double)l1, (double)((float)l - f7) + 0.5, (double)(0.0f * f8), (double)((float)l1 * f8 / 4.0f + f10 * f8));
                        tessellator.func_78374_a((double)((float)i1 + f6) + 0.5, (double)l1, (double)((float)l + f7) + 0.5, (double)(1.0f * f8), (double)((float)l1 * f8 / 4.0f + f10 * f8));
                        tessellator.func_78374_a((double)((float)i1 + f6) + 0.5, (double)i2, (double)((float)l + f7) + 0.5, (double)(1.0f * f8), (double)((float)i2 * f8 / 4.0f + f10 * f8));
                        tessellator.func_78374_a((double)((float)i1 - f6) + 0.5, (double)i2, (double)((float)l - f7) + 0.5, (double)(0.0f * f8), (double)((float)i2 * f8 / 4.0f + f10 * f8));
                        tessellator.func_78373_b(0.0, 0.0, 0.0);
                        continue;
                    }
                    if (b1 != 1) {
                        if (b1 >= 0) {
                            tessellator.func_78381_a();
                        }
                        b1 = 1;
                        if (LOTRConfig.newWeather) {
                            mc.func_110434_K().func_110577_a(snowTexture);
                        } else {
                            mc.func_110434_K().func_110577_a(snowTexture_def);
                        }
                        tessellator.func_78382_b();
                    }
                    f10 = ((float)(rendererUpdateCount & 0x1FF) + partialTicks) / 512.0f;
                    float f16 = this.rand.nextFloat() + f5 * 0.01f * (float)this.rand.nextGaussian();
                    f11 = this.rand.nextFloat() + f5 * (float)this.rand.nextGaussian() * 0.001f;
                    d4 = (double)((float)i1 + 0.5f) - entitylivingbase.field_70165_t;
                    double d5 = (double)((float)l + 0.5f) - entitylivingbase.field_70161_v;
                    f14 = MathHelper.func_76133_a((double)(d4 * d4 + d5 * d5)) / (float)b0;
                    f15 = 1.0f;
                    tessellator.func_78380_c((world.func_72802_i(i1, j2, l, 0) * 3 + 0xF000F0) / 4);
                    tessellator.func_78369_a(f15, f15, f15, ((1.0f - f14 * f14) * 0.3f + 0.5f) * rainStrength);
                    tessellator.func_78373_b(-d0 * 1.0, -d1 * 1.0, -d2 * 1.0);
                    tessellator.func_78374_a((double)((float)i1 - f6) + 0.5, (double)l1, (double)((float)l - f7) + 0.5, (double)(0.0f * f8 + f16), (double)((float)l1 * f8 / 4.0f + f10 * f8 + f11));
                    tessellator.func_78374_a((double)((float)i1 + f6) + 0.5, (double)l1, (double)((float)l + f7) + 0.5, (double)(1.0f * f8 + f16), (double)((float)l1 * f8 / 4.0f + f10 * f8 + f11));
                    tessellator.func_78374_a((double)((float)i1 + f6) + 0.5, (double)i2, (double)((float)l + f7) + 0.5, (double)(1.0f * f8 + f16), (double)((float)i2 * f8 / 4.0f + f10 * f8 + f11));
                    tessellator.func_78374_a((double)((float)i1 - f6) + 0.5, (double)i2, (double)((float)l - f7) + 0.5, (double)(0.0f * f8 + f16), (double)((float)i2 * f8 / 4.0f + f10 * f8 + f11));
                    tessellator.func_78373_b(0.0, 0.0, 0.0);
                }
            }
            if (b1 >= 0) {
                tessellator.func_78381_a();
            }
            GL11.glEnable((int)2884);
            GL11.glDisable((int)3042);
            GL11.glAlphaFunc((int)516, (float)0.1f);
            er.func_78483_a((double)partialTicks);
        }
    }

    public static boolean isSandstormBiome(BiomeGenBase biome) {
        return !biome.func_76738_d() && biome.field_76752_A.func_149688_o() == Material.field_151595_p;
    }
}

