/*
 * Decompiled with CFR 0.152.
 */
package lotr.client.render.entity;

import java.awt.Color;
import java.util.List;
import lotr.client.LOTRSpeechClient;
import lotr.client.LOTRTickHandlerClient;
import lotr.common.LOTRConfig;
import lotr.common.LOTRLevelData;
import lotr.common.LOTRMod;
import lotr.common.entity.npc.LOTREntityNPC;
import lotr.common.entity.npc.LOTRHiredNPCInfo;
import lotr.common.item.LOTRItemRedBook;
import lotr.common.quest.LOTRMiniQuest;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.entity.RendererLivingEntity;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import net.minecraft.util.StringUtils;
import net.minecraft.world.World;
import org.lwjgl.opengl.GL11;

public class LOTRNPCRendering {
    private static RenderItem itemRenderer = new RenderItem();
    private static final int SPEECH_WIDTH = 150;
    private static final float SPEECH_SCALE = 0.015f;

    public static void renderAllNPCSpeeches(Minecraft mc, World world, float f) {
        GL11.glPushMatrix();
        RenderHelper.func_74519_b();
        GL11.glAlphaFunc((int)516, (float)0.01f);
        double d0 = RenderManager.field_78725_b;
        double d1 = RenderManager.field_78726_c;
        double d2 = RenderManager.field_78723_d;
        for (Object obj : world.field_72996_f) {
            Entity entity = (Entity)obj;
            boolean inRange = entity.func_145770_h(d0, d1, d2);
            if (!(entity instanceof LOTREntityNPC) || !inRange) continue;
            LOTREntityNPC npc = (LOTREntityNPC)entity;
            if (!npc.func_70089_S()) {
                LOTRSpeechClient.removeSpeech(npc);
                continue;
            }
            LOTRSpeechClient.TimedSpeech timedSpeech = LOTRSpeechClient.getSpeechFor(npc);
            if (timedSpeech == null) continue;
            double d3 = npc.field_70142_S + (npc.field_70165_t - npc.field_70142_S) * (double)f;
            double d4 = npc.field_70137_T + (npc.field_70163_u - npc.field_70137_T) * (double)f;
            double d5 = npc.field_70136_U + (npc.field_70161_v - npc.field_70136_U) * (double)f;
            LOTRNPCRendering.renderSpeech((EntityLivingBase)npc, timedSpeech.getSpeech(), timedSpeech.getAge(), d3 - d0, d4 - d1, d5 - d2);
        }
        GL11.glAlphaFunc((int)516, (float)0.1f);
        RenderHelper.func_74518_a();
        mc.field_71460_t.func_78483_a((double)f);
        GL11.glPopMatrix();
    }

    public static void renderSpeech(EntityLivingBase entity, String speech, float speechAge, double d, double d1, double d2) {
        Minecraft mc = Minecraft.func_71410_x();
        WorldClient world = mc.field_71441_e;
        world.field_72984_F.func_76320_a("renderNPCSpeech");
        TextureManager textureManager = mc.func_110434_K();
        RenderManager renderManager = RenderManager.field_78727_a;
        FontRenderer fr = mc.field_71466_p;
        double distance = RendererLivingEntity.NAME_TAG_RANGE;
        double distanceSq = entity.func_70068_e((Entity)renderManager.field_78734_h);
        if (distanceSq <= distance * distance) {
            String name = EnumChatFormatting.YELLOW + entity.func_70005_c_();
            int fontHeight = fr.field_78288_b;
            List speechLines = fr.func_78271_c(speech, 150);
            float alpha = 0.8f;
            if (speechAge < 0.1f) {
                alpha *= speechAge / 0.1f;
            }
            int intAlpha = (int)(alpha * 255.0f);
            GL11.glPushMatrix();
            GL11.glTranslatef((float)((float)d), (float)((float)d1 + entity.field_70131_O + 0.3f), (float)((float)d2));
            GL11.glNormal3f((float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)(-renderManager.field_78735_i), (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)renderManager.field_78732_j, (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glDisable((int)2896);
            GL11.glDepthMask((boolean)false);
            GL11.glDisable((int)2929);
            GL11.glEnable((int)3042);
            OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
            OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            Tessellator tessellator = Tessellator.field_78398_a;
            float scale = 0.015f;
            GL11.glScalef((float)(-scale), (float)(-scale), (float)scale);
            GL11.glTranslatef((float)0.0f, (float)(-fontHeight * (3 + speechLines.size())), (float)0.0f);
            GL11.glDisable((int)3553);
            tessellator.func_78382_b();
            tessellator.func_78369_a(0.0f, 0.0f, 0.0f, 0.25f * alpha);
            int halfNameW = fr.func_78256_a(name) / 2;
            tessellator.func_78377_a((double)(-halfNameW - 1), 0.0, 0.0);
            tessellator.func_78377_a((double)(-halfNameW - 1), (double)fontHeight, 0.0);
            tessellator.func_78377_a((double)(halfNameW + 1), (double)fontHeight, 0.0);
            tessellator.func_78377_a((double)(halfNameW + 1), 0.0, 0.0);
            tessellator.func_78381_a();
            GL11.glEnable((int)3553);
            fr.func_78276_b(name, -halfNameW, 0, intAlpha << 24 | 0xFFFFFF);
            GL11.glTranslatef((float)0.0f, (float)fontHeight, (float)0.0f);
            for (String line : speechLines) {
                GL11.glTranslatef((float)0.0f, (float)fontHeight, (float)0.0f);
                GL11.glDisable((int)3553);
                tessellator.func_78382_b();
                tessellator.func_78369_a(0.0f, 0.0f, 0.0f, 0.25f * alpha);
                int halfLineW = fr.func_78256_a(line) / 2;
                tessellator.func_78377_a((double)(-halfLineW - 1), 0.0, 0.0);
                tessellator.func_78377_a((double)(-halfLineW - 1), (double)fontHeight, 0.0);
                tessellator.func_78377_a((double)(halfLineW + 1), (double)fontHeight, 0.0);
                tessellator.func_78377_a((double)(halfLineW + 1), 0.0, 0.0);
                tessellator.func_78381_a();
                GL11.glEnable((int)3553);
                fr.func_78276_b(line, -halfLineW, 0, intAlpha << 24 | 0xFFFFFF);
            }
            GL11.glDisable((int)3042);
            GL11.glEnable((int)2929);
            GL11.glDepthMask((boolean)true);
            GL11.glEnable((int)2896);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glPopMatrix();
        }
        world.field_72984_F.func_76319_b();
    }

    private static float calcSpeechDisplacement(LOTREntityNPC npc) {
        LOTRSpeechClient.TimedSpeech timedSpeech = LOTRSpeechClient.getSpeechFor(npc);
        if (timedSpeech != null) {
            FontRenderer fr = Minecraft.func_71410_x().field_71466_p;
            int fontHeight = fr.field_78288_b;
            int numLines = fr.func_78271_c(timedSpeech.getSpeech(), 150).size();
            float f = fontHeight * (3 + numLines);
            return f * 0.015f;
        }
        return 0.0f;
    }

    public static void renderHiredIcon(EntityLivingBase entity, double d, double d1, double d2) {
        if (!LOTRConfig.hiredUnitIcons) {
            return;
        }
        if (entity.field_70153_n instanceof LOTREntityNPC) {
            return;
        }
        if (entity instanceof LOTREntityNPC && LOTRSpeechClient.hasSpeech((LOTREntityNPC)entity)) {
            d1 += (double)LOTRNPCRendering.calcSpeechDisplacement((LOTREntityNPC)entity);
        }
        Minecraft mc = Minecraft.func_71410_x();
        TextureManager textureManager = mc.func_110434_K();
        FontRenderer fr = mc.field_71466_p;
        RenderManager renderManager = RenderManager.field_78727_a;
        EntityLivingBase viewer = renderManager.field_78734_h;
        WorldClient world = mc.field_71441_e;
        world.field_72984_F.func_76320_a("renderHiredIcon");
        double distance = RendererLivingEntity.NAME_TAG_RANGE;
        double distanceSq = entity.func_70068_e((Entity)viewer);
        if (distanceSq <= distance * distance) {
            ItemStack hiredIcon = entity.func_70694_bm();
            int displayLevel = -1;
            String squadron = null;
            if (entity instanceof LOTREntityNPC) {
                String sq;
                LOTREntityNPC npc = (LOTREntityNPC)entity;
                LOTRHiredNPCInfo hiredInfo = npc.hiredNPCInfo;
                if (hiredInfo.getTask().displayXpLevel) {
                    displayLevel = hiredInfo.xpLevel;
                }
                if (!StringUtils.func_151246_b((String)(sq = hiredInfo.getSquadron()))) {
                    squadron = sq;
                }
            }
            GL11.glPushMatrix();
            GL11.glTranslatef((float)((float)d), (float)((float)d1 + entity.field_70131_O), (float)((float)d2));
            GL11.glNormal3f((float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)(-renderManager.field_78735_i), (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)renderManager.field_78732_j, (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glDisable((int)2896);
            GL11.glDepthMask((boolean)false);
            GL11.glDisable((int)2929);
            GL11.glEnable((int)3042);
            OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
            OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            if (squadron != null) {
                GL11.glTranslatef((float)0.0f, (float)0.3f, (float)0.0f);
                GL11.glPushMatrix();
                Tessellator tessellator = Tessellator.field_78398_a;
                int halfWidth = fr.func_78256_a(squadron) / 2;
                float boxScale = 0.015f;
                GL11.glScalef((float)(-boxScale), (float)(-boxScale), (float)boxScale);
                GL11.glDisable((int)3553);
                tessellator.func_78382_b();
                tessellator.func_78369_a(0.0f, 0.0f, 0.0f, 0.25f);
                tessellator.func_78377_a((double)(-halfWidth - 1), -9.0, 0.0);
                tessellator.func_78377_a((double)(-halfWidth - 1), 0.0, 0.0);
                tessellator.func_78377_a((double)(halfWidth + 1), 0.0, 0.0);
                tessellator.func_78377_a((double)(halfWidth + 1), -9.0, 0.0);
                tessellator.func_78381_a();
                GL11.glEnable((int)3553);
                fr.func_78276_b(squadron, -halfWidth, -8, 0x20FFFFFF);
                GL11.glEnable((int)2929);
                GL11.glDepthMask((boolean)true);
                fr.func_78276_b(squadron, -halfWidth, -8, -1);
                GL11.glDisable((int)2929);
                GL11.glDepthMask((boolean)false);
                GL11.glPopMatrix();
            }
            if (viewer.func_70093_af() && displayLevel >= 0) {
                GL11.glPushMatrix();
                GL11.glTranslatef((float)0.0f, (float)0.5f, (float)0.0f);
                GL11.glScalef((float)-1.0f, (float)-1.0f, (float)1.0f);
                float textScale = 0.03f;
                GL11.glScalef((float)textScale, (float)textScale, (float)textScale);
                String s = String.valueOf(displayLevel);
                LOTRTickHandlerClient.drawBorderedText(fr, -fr.func_78256_a(s) / 2, 0, s, 0xFF5500, 1.0f);
                GL11.glPopMatrix();
            } else if (hiredIcon != null) {
                GL11.glPushMatrix();
                GL11.glTranslatef((float)0.0f, (float)0.5f, (float)0.0f);
                GL11.glScalef((float)-1.0f, (float)-1.0f, (float)1.0f);
                float itemScale = 0.03f;
                GL11.glScalef((float)itemScale, (float)itemScale, (float)itemScale);
                textureManager.func_110577_a(TextureMap.field_110576_c);
                itemRenderer.func_94149_a(-8, -8, hiredIcon.func_77954_c(), 16, 16);
                GL11.glPopMatrix();
            }
            GL11.glDisable((int)3042);
            GL11.glEnable((int)2929);
            GL11.glDepthMask((boolean)true);
            GL11.glEnable((int)2896);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glPopMatrix();
        }
        world.field_72984_F.func_76319_b();
    }

    public static void renderNPCHealthBar(EntityLivingBase entity, double d, double d1, double d2) {
        if (!LOTRConfig.hiredUnitHealthBars) {
            return;
        }
        if (entity.field_70153_n instanceof LOTREntityNPC) {
            return;
        }
        if (entity instanceof LOTREntityNPC && LOTRSpeechClient.hasSpeech((LOTREntityNPC)entity)) {
            d1 += (double)LOTRNPCRendering.calcSpeechDisplacement((LOTREntityNPC)entity);
        }
        LOTRNPCRendering.renderHealthBar(entity, d, d1, d2, new int[]{5888860, 12006707}, new int[]{6079225, 12006707});
    }

    public static void renderHealthBar(EntityLivingBase entity, double d, double d1, double d2, int[] colors, int[] mountColors) {
        Minecraft mc = Minecraft.func_71410_x();
        WorldClient world = mc.field_71441_e;
        world.field_72984_F.func_76320_a("renderHealthBar");
        RenderManager renderManager = RenderManager.field_78727_a;
        double distance = RendererLivingEntity.NAME_TAG_RANGE;
        double distanceSq = entity.func_70068_e((Entity)renderManager.field_78734_h);
        if (distanceSq <= distance * distance) {
            float f1 = 1.6f;
            float f2 = 0.016666666f * f1;
            GL11.glPushMatrix();
            GL11.glTranslatef((float)((float)d), (float)((float)d1 + entity.field_70131_O + 0.7f), (float)((float)d2));
            GL11.glNormal3f((float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)(-renderManager.field_78735_i), (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)renderManager.field_78732_j, (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glScalef((float)(-f2), (float)(-f2), (float)f2);
            GL11.glDisable((int)2896);
            GL11.glDepthMask((boolean)false);
            GL11.glDisable((int)2929);
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            Tessellator tessellator = Tessellator.field_78398_a;
            GL11.glDisable((int)3553);
            int colorHealth = colors[0];
            int colorBase = colors[1];
            tessellator.func_78382_b();
            tessellator.func_78378_d(0);
            tessellator.func_78377_a(-19.5, 18.5, 0.0);
            tessellator.func_78377_a(-19.5, 21.0, 0.0);
            tessellator.func_78377_a(19.5, 21.0, 0.0);
            tessellator.func_78377_a(19.5, 18.5, 0.0);
            tessellator.func_78381_a();
            tessellator.func_78382_b();
            tessellator.func_78378_d(colorBase);
            tessellator.func_78377_a(-19.0, 19.0, 0.0);
            tessellator.func_78377_a(-19.0, 20.5, 0.0);
            tessellator.func_78377_a(19.0, 20.5, 0.0);
            tessellator.func_78377_a(19.0, 19.0, 0.0);
            tessellator.func_78381_a();
            double healthRemaining = entity.func_110143_aJ() / entity.func_110138_aP();
            if (healthRemaining < 0.0) {
                healthRemaining = 0.0;
            }
            tessellator.func_78382_b();
            tessellator.func_78378_d(colorHealth);
            tessellator.func_78377_a(-19.0, 19.0, 0.0);
            tessellator.func_78377_a(-19.0, 20.5, 0.0);
            tessellator.func_78377_a(-19.0 + 38.0 * healthRemaining, 20.5, 0.0);
            tessellator.func_78377_a(-19.0 + 38.0 * healthRemaining, 19.0, 0.0);
            tessellator.func_78381_a();
            if (mountColors != null && entity.field_70154_o instanceof EntityLivingBase) {
                EntityLivingBase mount = (EntityLivingBase)entity.field_70154_o;
                int mountColorHealth = mountColors[0];
                int mountColorBase = mountColors[1];
                tessellator.func_78382_b();
                tessellator.func_78378_d(0);
                tessellator.func_78377_a(-19.5, 23.5, 0.0);
                tessellator.func_78377_a(-19.5, 26.0, 0.0);
                tessellator.func_78377_a(19.5, 26.0, 0.0);
                tessellator.func_78377_a(19.5, 23.5, 0.0);
                tessellator.func_78381_a();
                tessellator.func_78382_b();
                tessellator.func_78378_d(mountColorBase);
                tessellator.func_78377_a(-19.0, 24.0, 0.0);
                tessellator.func_78377_a(-19.0, 25.5, 0.0);
                tessellator.func_78377_a(19.0, 25.5, 0.0);
                tessellator.func_78377_a(19.0, 24.0, 0.0);
                tessellator.func_78381_a();
                double mountHealthRemaining = mount.func_110143_aJ() / mount.func_110138_aP();
                if (mountHealthRemaining < 0.0) {
                    mountHealthRemaining = 0.0;
                }
                tessellator.func_78382_b();
                tessellator.func_78378_d(mountColorHealth);
                tessellator.func_78377_a(-19.0, 24.0, 0.0);
                tessellator.func_78377_a(-19.0, 25.5, 0.0);
                tessellator.func_78377_a(-19.0 + 38.0 * mountHealthRemaining, 25.5, 0.0);
                tessellator.func_78377_a(-19.0 + 38.0 * mountHealthRemaining, 24.0, 0.0);
                tessellator.func_78381_a();
            }
            GL11.glEnable((int)3553);
            GL11.glEnable((int)2929);
            GL11.glDepthMask((boolean)true);
            GL11.glEnable((int)2896);
            GL11.glDisable((int)3042);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glPopMatrix();
        }
        world.field_72984_F.func_76319_b();
    }

    public static void renderQuestBook(LOTREntityNPC npc, double d, double d1, double d2) {
        Minecraft mc = Minecraft.func_71410_x();
        WorldClient world = mc.field_71441_e;
        world.field_72984_F.func_76320_a("renderMiniquestBook");
        float distance = mc.field_71451_h.func_70032_d((Entity)npc);
        boolean aboveHead = (double)distance <= LOTRMiniQuest.RENDER_HEAD_DISTANCE;
        TextureManager textureManager = mc.func_110434_K();
        RenderManager renderManager = RenderManager.field_78727_a;
        EntityClientPlayerMP entityplayer = mc.field_71439_g;
        if (!LOTRLevelData.getData((EntityPlayer)entityplayer).getMiniQuestsForEntity(npc, true).isEmpty() && !LOTRSpeechClient.hasSpeech(npc)) {
            ItemStack questBook = new ItemStack(LOTRMod.redBook);
            IIcon icon = questBook.func_77954_c();
            if (icon == null) {
                icon = ((TextureMap)textureManager.func_110581_b(TextureMap.field_110576_c)).func_110572_b("missingno");
            }
            Tessellator tessellator = Tessellator.field_78398_a;
            float minU = icon.func_94209_e();
            float maxU = icon.func_94212_f();
            float minV = icon.func_94206_g();
            float maxV = icon.func_94210_h();
            if (aboveHead) {
                float age = (float)npc.field_70173_aa + LOTRTickHandlerClient.renderTick;
                float rotation = age % 360.0f;
                rotation *= 6.0f;
                GL11.glPushMatrix();
                GL11.glEnable((int)32826);
                GL11.glDisable((int)2896);
                GL11.glTranslatef((float)((float)d), (float)((float)d1 + npc.field_70131_O + 1.3f), (float)((float)d2));
                float scale = 1.0f;
                GL11.glRotatef((float)rotation, (float)0.0f, (float)1.0f, (float)0.0f);
                GL11.glTranslatef((float)(-0.5f * scale), (float)(-0.5f * scale), (float)(0.03125f * scale));
                GL11.glScalef((float)scale, (float)scale, (float)scale);
                textureManager.func_110577_a(TextureMap.field_110576_c);
                OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                ItemRenderer.func_78439_a((Tessellator)tessellator, (float)maxU, (float)minV, (float)minU, (float)maxV, (int)icon.func_94211_a(), (int)icon.func_94216_b(), (float)0.0625f);
                GL11.glEnable((int)2896);
                GL11.glDisable((int)32826);
                GL11.glPopMatrix();
            } else {
                float scale = distance / (float)LOTRMiniQuest.RENDER_HEAD_DISTANCE;
                scale = (float)Math.pow(scale, 1.1);
                float alpha = (float)Math.pow(scale, -0.4);
                GL11.glPushMatrix();
                GL11.glTranslatef((float)((float)d), (float)((float)d1 + npc.field_70131_O + 1.3f), (float)((float)d2));
                GL11.glNormal3f((float)0.0f, (float)1.0f, (float)0.0f);
                GL11.glRotatef((float)(-renderManager.field_78735_i), (float)0.0f, (float)1.0f, (float)0.0f);
                GL11.glRotatef((float)renderManager.field_78732_j, (float)1.0f, (float)0.0f, (float)0.0f);
                GL11.glScalef((float)scale, (float)scale, (float)scale);
                GL11.glDisable((int)2896);
                GL11.glDepthMask((boolean)false);
                GL11.glDisable((int)2929);
                GL11.glEnable((int)3042);
                OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
                textureManager.func_110577_a(TextureMap.field_110576_c);
                OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
                GL11.glScalef((float)-1.0f, (float)-1.0f, (float)1.0f);
                float itemScale = 0.0625f;
                GL11.glScalef((float)itemScale, (float)itemScale, (float)itemScale);
                textureManager.func_110577_a(TextureMap.field_110576_c);
                itemRenderer.func_94149_a(-8, -8, icon, 16, 16);
                GL11.glDisable((int)3042);
                GL11.glEnable((int)2929);
                GL11.glDepthMask((boolean)true);
                GL11.glEnable((int)2896);
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GL11.glPopMatrix();
            }
        }
        world.field_72984_F.func_76319_b();
    }

    public static void renderQuestOffer(LOTREntityNPC npc, double d, double d1, double d2) {
        Minecraft mc = Minecraft.func_71410_x();
        WorldClient world = mc.field_71441_e;
        world.field_72984_F.func_76320_a("renderMiniquestoffer");
        if (npc.func_70089_S() && npc.questInfo.clientIsOffering && !LOTRSpeechClient.hasSpeech(npc)) {
            EntityClientPlayerMP entityplayer = mc.field_71439_g;
            float distance = mc.field_71451_h.func_70032_d((Entity)npc);
            if ((double)distance <= 16.0 && LOTRLevelData.getData((EntityPlayer)entityplayer).getMiniQuestsForEntity(npc, true).isEmpty()) {
                TextureManager textureManager = mc.func_110434_K();
                RenderManager renderManager = RenderManager.field_78727_a;
                IIcon icon = LOTRItemRedBook.questOfferIcon;
                Tessellator tessellator = Tessellator.field_78398_a;
                float minU = icon.func_94209_e();
                float maxU = icon.func_94212_f();
                float minV = icon.func_94206_g();
                float maxV = icon.func_94210_h();
                float scale = 0.75f;
                float alpha = 1.0f;
                int questColor = npc.questInfo.clientOfferColor;
                float[] questRGB = new Color(questColor).getColorComponents(null);
                GL11.glPushMatrix();
                GL11.glTranslatef((float)((float)d), (float)((float)d1 + npc.field_70131_O + 1.0f), (float)((float)d2));
                GL11.glNormal3f((float)0.0f, (float)1.0f, (float)0.0f);
                GL11.glRotatef((float)(-renderManager.field_78735_i), (float)0.0f, (float)1.0f, (float)0.0f);
                GL11.glRotatef((float)renderManager.field_78732_j, (float)1.0f, (float)0.0f, (float)0.0f);
                GL11.glScalef((float)scale, (float)scale, (float)scale);
                GL11.glDisable((int)2896);
                GL11.glEnable((int)3042);
                OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
                textureManager.func_110577_a(TextureMap.field_110576_c);
                OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
                GL11.glScalef((float)-1.0f, (float)-1.0f, (float)1.0f);
                float itemScale = 0.0625f;
                GL11.glScalef((float)itemScale, (float)itemScale, (float)itemScale);
                textureManager.func_110577_a(TextureMap.field_110576_c);
                GL11.glColor4f((float)questRGB[0], (float)questRGB[1], (float)questRGB[2], (float)alpha);
                itemRenderer.func_94149_a(-8, -8, icon, 16, 16);
                GL11.glDisable((int)3042);
                GL11.glEnable((int)2896);
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GL11.glPopMatrix();
            }
        }
        world.field_72984_F.func_76319_b();
    }
}

