/*
 * Decompiled with CFR 0.152.
 */
package lotr.client.render.entity;

import java.awt.Color;
import lotr.client.LOTRTextures;
import lotr.client.model.LOTRModelElf;
import lotr.client.render.entity.LOTRGlowingEyes;
import lotr.client.render.entity.LOTRRandomSkins;
import lotr.client.render.entity.LOTRRenderBiped;
import lotr.common.LOTRMod;
import lotr.common.entity.npc.LOTREntityDorwinionElf;
import lotr.common.entity.npc.LOTREntityElf;
import lotr.common.entity.npc.LOTREntityHighElf;
import lotr.common.entity.npc.LOTREntityRivendellElf;
import lotr.common.entity.npc.LOTREntityTormentedElf;
import lotr.common.entity.npc.LOTREntityWoodElf;
import lotr.common.item.LOTRItemRing;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class LOTRRenderElf
extends LOTRRenderBiped {
    private static LOTRRandomSkins galadhrimSkinsMale;
    private static LOTRRandomSkins galadhrimSkinsFemale;
    private static LOTRRandomSkins woodElfSkinsMale;
    private static LOTRRandomSkins woodElfSkinsFemale;
    private static LOTRRandomSkins highElfSkinsMale;
    private static LOTRRandomSkins highElfSkinsFemale;
    private static LOTRRandomSkins dorwinionSkinsMale;
    private static LOTRRandomSkins dorwinionSkinsFemale;
    private static LOTRRandomSkins tormentedElfSkins;
    private static LOTRRandomSkins jazzSkinsMale;
    private static LOTRRandomSkins jazzSkinsFemale;
    private static LOTRRandomSkins jazzOutfits;
    private LOTRModelElf eyesModel = new LOTRModelElf(0.05f, 64, 64);
    private LOTRModelElf outfitModel = new LOTRModelElf(0.6f, 64, 64);

    public LOTRRenderElf() {
        super(new LOTRModelElf(), 0.5f);
        galadhrimSkinsMale = LOTRRandomSkins.loadSkinsList("lotr:mob/elf/galadhrim_male");
        galadhrimSkinsFemale = LOTRRandomSkins.loadSkinsList("lotr:mob/elf/galadhrim_female");
        woodElfSkinsMale = LOTRRandomSkins.loadSkinsList("lotr:mob/elf/woodElf_male");
        woodElfSkinsFemale = LOTRRandomSkins.loadSkinsList("lotr:mob/elf/woodElf_female");
        highElfSkinsMale = LOTRRandomSkins.loadSkinsList("lotr:mob/elf/highElf_male");
        highElfSkinsFemale = LOTRRandomSkins.loadSkinsList("lotr:mob/elf/highElf_female");
        dorwinionSkinsMale = LOTRRandomSkins.loadSkinsList("lotr:mob/elf/dorwinion_male");
        dorwinionSkinsFemale = LOTRRandomSkins.loadSkinsList("lotr:mob/elf/dorwinion_female");
        tormentedElfSkins = LOTRRandomSkins.loadSkinsList("lotr:mob/elf/tormented");
        jazzSkinsMale = LOTRRandomSkins.loadSkinsList("lotr:mob/elf/jazz_male");
        jazzSkinsFemale = LOTRRandomSkins.loadSkinsList("lotr:mob/elf/jazz_female");
        jazzOutfits = LOTRRandomSkins.loadSkinsList("lotr:mob/elf/jazz_outfit");
    }

    @Override
    protected void func_82421_b() {
        this.field_82423_g = new LOTRModelElf(1.0f);
        this.field_82425_h = new LOTRModelElf(0.5f);
    }

    @Override
    public ResourceLocation func_110775_a(Entity entity) {
        LOTREntityElf elf = (LOTREntityElf)entity;
        boolean male = elf.familyInfo.isMale();
        if (elf.isJazz()) {
            if (male) {
                return jazzSkinsMale.getRandomSkin(elf);
            }
            return jazzSkinsFemale.getRandomSkin(elf);
        }
        if (elf instanceof LOTREntityTormentedElf) {
            return tormentedElfSkins.getRandomSkin(elf);
        }
        if (elf instanceof LOTREntityDorwinionElf) {
            if (male) {
                return dorwinionSkinsMale.getRandomSkin(elf);
            }
            return dorwinionSkinsFemale.getRandomSkin(elf);
        }
        if (elf instanceof LOTREntityHighElf || elf instanceof LOTREntityRivendellElf) {
            if (male) {
                return highElfSkinsMale.getRandomSkin(elf);
            }
            return highElfSkinsFemale.getRandomSkin(elf);
        }
        if (elf instanceof LOTREntityWoodElf) {
            if (male) {
                return woodElfSkinsMale.getRandomSkin(elf);
            }
            return woodElfSkinsFemale.getRandomSkin(elf);
        }
        if (male) {
            return galadhrimSkinsMale.getRandomSkin(elf);
        }
        return galadhrimSkinsFemale.getRandomSkin(elf);
    }

    protected void func_77036_a(EntityLivingBase entity, float f, float f1, float f2, float f3, float f4, float f5) {
        super.func_77036_a(entity, f, f1, f2, f3, f4, f5);
        if (entity instanceof LOTREntityTormentedElf) {
            ResourceLocation eyes = LOTRTextures.getEyesTexture(this.func_110775_a((Entity)entity), new int[][]{{9, 12}, {13, 12}}, 2, 1);
            LOTRGlowingEyes.renderGlowingEyes((Entity)entity, eyes, this.eyesModel, f, f1, f2, f3, f4, f5);
        }
    }

    @Override
    public int func_77032_a(EntityLiving entity, int pass, float f) {
        LOTREntityElf elf = (LOTREntityElf)entity;
        if (elf.isJazz() && pass == 0 && elf.func_71124_b(4) == null && LOTRRandomSkins.nextInt(elf, 2) == 0) {
            this.func_77042_a((ModelBase)this.outfitModel);
            this.func_110776_a(jazzOutfits.getRandomSkin(elf));
            return 1;
        }
        return super.func_77032_a((EntityLiving)elf, pass, f);
    }

    @Override
    protected void func_77041_b(EntityLivingBase entity, float f) {
        super.func_77041_b(entity, f);
        LOTREntityElf elf = (LOTREntityElf)entity;
        if (LOTRMod.isAprilFools()) {
            GL11.glScalef((float)0.25f, (float)0.25f, (float)0.25f);
        }
        if (elf.isJazz() && elf.isSolo()) {
            float hue = ((float)elf.field_70173_aa + f) / 20.0f;
            float sat = 0.5f;
            Color color = Color.getHSBColor(hue %= 360.0f, sat, 1.0f);
            float r = (float)color.getRed() / 255.0f;
            float g = (float)color.getGreen() / 255.0f;
            float b = (float)color.getBlue() / 255.0f;
            GL11.glColor3f((float)r, (float)g, (float)b);
            float soloSpin = elf.getSoloSpin(f);
            GL11.glRotatef((float)soloSpin, (float)0.0f, (float)1.0f, (float)0.0f);
        }
    }

    @Override
    protected void func_77029_c(EntityLivingBase entity, float f) {
        super.func_77029_c(entity, f);
        LOTREntityElf elf = (LOTREntityElf)entity;
        if (elf.isJazz() && elf.isSolo()) {
            GL11.glPushMatrix();
            GL11.glTranslatef((float)0.0f, (float)0.75f, (float)0.1f);
            GL11.glScalef((float)1.0f, (float)-1.0f, (float)1.0f);
            GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)-20.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            TextureManager texturemanager = this.field_76990_c.field_78724_e;
            texturemanager.func_110577_a(TextureMap.field_110576_c);
            TextureUtil.func_152777_a((boolean)false, (boolean)false, (float)1.0f);
            Tessellator tessellator = Tessellator.field_78398_a;
            IIcon icon = LOTRItemRing.saxIcon;
            float minU = icon.func_94209_e();
            float maxU = icon.func_94212_f();
            float minV = icon.func_94206_g();
            float maxV = icon.func_94210_h();
            GL11.glEnable((int)32826);
            ItemRenderer.func_78439_a((Tessellator)tessellator, (float)maxU, (float)minV, (float)minU, (float)maxV, (int)icon.func_94211_a(), (int)icon.func_94216_b(), (float)0.0625f);
            GL11.glDisable((int)32826);
            texturemanager.func_110577_a(TextureMap.field_110576_c);
            TextureUtil.func_147945_b();
            GL11.glPopMatrix();
        }
    }
}

