/*
 * Decompiled with CFR 0.152.
 */
package lotr.common;

import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.eventhandler.Event;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import lotr.common.LOTRLevelData;
import lotr.common.entity.npc.LOTREntityGandalf;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;

public class LOTRGreyWandererTracker {
    private static Map<UUID, Integer> activeGreyWanderers = new HashMap<UUID, Integer>();
    private static final int greyWandererCooldown_MAX = 3600;
    private static final int spawnInterval = 2400;
    private static int spawnCooldown;

    public static void save(NBTTagCompound levelData) {
        NBTTagList greyWandererTags = new NBTTagList();
        for (Map.Entry<UUID, Integer> e : activeGreyWanderers.entrySet()) {
            UUID id = e.getKey();
            int cd = e.getValue();
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74778_a("ID", id.toString());
            nbt.func_74768_a("CD", cd);
            greyWandererTags.func_74742_a((NBTBase)nbt);
        }
        levelData.func_74782_a("GreyWanderers", (NBTBase)greyWandererTags);
        levelData.func_74768_a("GWSpawnTick", spawnCooldown);
    }

    public static void load(NBTTagCompound levelData) {
        activeGreyWanderers.clear();
        NBTTagList greyWandererTags = levelData.func_150295_c("GreyWanderers", 10);
        for (int i = 0; i < greyWandererTags.func_74745_c(); ++i) {
            NBTTagCompound nbt = greyWandererTags.func_150305_b(i);
            try {
                UUID id = UUID.fromString(nbt.func_74779_i("ID"));
                int cd = nbt.func_74762_e("CD");
                activeGreyWanderers.put(id, cd);
                continue;
            }
            catch (Exception e) {
                FMLLog.severe((String)"Error loading LOTR data: invalid Grey Wanderer", (Object[])new Object[0]);
                e.printStackTrace();
            }
        }
        spawnCooldown = levelData.func_74764_b("GWSpawnTick") ? levelData.func_74762_e("GWSpawnTick") : 2400;
    }

    private static void markDirty() {
        LOTRLevelData.markDirty();
    }

    public static boolean isWandererActive(UUID id) {
        return activeGreyWanderers.containsKey(id) && activeGreyWanderers.get(id) > 0;
    }

    public static void addNewWanderer(UUID id) {
        activeGreyWanderers.put(id, 3600);
        LOTRGreyWandererTracker.markDirty();
    }

    public static void setWandererActive(UUID id) {
        if (activeGreyWanderers.containsKey(id)) {
            activeGreyWanderers.put(id, 3600);
            LOTRGreyWandererTracker.markDirty();
        }
    }

    public static void updateCooldowns() {
        HashSet<UUID> removes = new HashSet<UUID>();
        for (UUID id : activeGreyWanderers.keySet()) {
            int cd = activeGreyWanderers.get(id);
            activeGreyWanderers.put(id, --cd);
            if (cd > 0) continue;
            removes.add(id);
        }
        if (!removes.isEmpty()) {
            for (UUID id : removes) {
                activeGreyWanderers.remove(id);
            }
            LOTRGreyWandererTracker.markDirty();
        }
    }

    public static void performSpawning(World world) {
        if (!activeGreyWanderers.isEmpty()) {
            return;
        }
        if (!world.field_73010_i.isEmpty() && --spawnCooldown <= 0) {
            spawnCooldown = 2400;
            ArrayList players = new ArrayList(world.field_73010_i);
            Collections.shuffle(players);
            Random rand = world.field_73012_v;
            boolean spawned = false;
            block0: for (Object obj : players) {
                EntityPlayer entityplayer = (EntityPlayer)obj;
                if (LOTRLevelData.getData(entityplayer).hasAnyGWQuest()) continue;
                for (int attempts = 0; attempts < 32; ++attempts) {
                    int k;
                    float angle = rand.nextFloat() * (float)Math.PI * 2.0f;
                    int r = MathHelper.func_76136_a((Random)rand, (int)4, (int)16);
                    int i = MathHelper.func_76128_c((double)(entityplayer.field_70165_t + (double)((float)r * MathHelper.func_76134_b((float)angle))));
                    int j = world.func_72976_f(i, k = MathHelper.func_76128_c((double)(entityplayer.field_70161_v + (double)((float)r * MathHelper.func_76126_a((float)angle)))));
                    if (j <= 62 || !world.func_147439_a(i, j - 1, k).func_149662_c() || world.func_147439_a(i, j, k).func_149721_r() || world.func_147439_a(i, j + 1, k).func_149721_r()) continue;
                    LOTREntityGandalf wanderer = new LOTREntityGandalf(world);
                    wanderer.func_70012_b((double)i + 0.5, j, (double)k + 0.5, world.field_73012_v.nextFloat() * 360.0f, 0.0f);
                    wanderer.liftSpawnRestrictions = true;
                    wanderer.liftBannerRestrictions = true;
                    Event.Result canSpawn = ForgeEventFactory.canEntitySpawn((EntityLiving)wanderer, (World)world, (float)((float)wanderer.field_70165_t), (float)((float)wanderer.field_70163_u), (float)((float)wanderer.field_70161_v));
                    if (canSpawn != Event.Result.ALLOW && (canSpawn != Event.Result.DEFAULT || !wanderer.func_70601_bi())) continue;
                    wanderer.liftSpawnRestrictions = false;
                    wanderer.liftBannerRestrictions = false;
                    world.func_72838_d((Entity)wanderer);
                    wanderer.func_110161_a(null);
                    LOTRGreyWandererTracker.addNewWanderer(wanderer.func_110124_au());
                    wanderer.arriveAt(entityplayer);
                    spawned = true;
                    break block0;
                }
            }
        }
    }
}

