/*
 * Decompiled with CFR 0.152.
 */
package lotr.common;

import cpw.mods.fml.common.FMLLog;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import lotr.common.LOTRLevelData;
import lotr.common.LOTRMod;
import lotr.common.world.LOTRWorldInfo;
import lotr.common.world.LOTRWorldProvider;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;

public class LOTRTime {
    public static int DAY_LENGTH = 48000;
    private static long totalTime;
    private static long worldTime;
    public static boolean needsLoad;

    private static File getTimeDat() {
        return new File(LOTRLevelData.getOrCreateLOTRDir(), "LOTRTime.dat");
    }

    public static void save() {
        try {
            File time_dat = LOTRTime.getTimeDat();
            if (!time_dat.exists()) {
                CompressedStreamTools.func_74799_a((NBTTagCompound)new NBTTagCompound(), (OutputStream)new FileOutputStream(time_dat));
            }
            NBTTagCompound timeData = new NBTTagCompound();
            timeData.func_74772_a("LOTRTotalTime", totalTime);
            timeData.func_74772_a("LOTRWorldTime", worldTime);
            LOTRLevelData.saveNBTToFile(time_dat, timeData);
        }
        catch (Exception e) {
            FMLLog.severe((String)"Error saving LOTR time data", (Object[])new Object[0]);
            e.printStackTrace();
        }
    }

    public static void load() {
        try {
            NBTTagCompound timeData = LOTRLevelData.loadNBTFromFile(LOTRTime.getTimeDat());
            totalTime = timeData.func_74763_f("LOTRTotalTime");
            worldTime = timeData.func_74763_f("LOTRWorldTime");
            needsLoad = false;
            LOTRTime.save();
        }
        catch (Exception e) {
            FMLLog.severe((String)"Error loading LOTR time data", (Object[])new Object[0]);
            e.printStackTrace();
        }
    }

    public static void setWorldTime(long time) {
        worldTime = time;
    }

    public static void addWorldTime(long time) {
        worldTime += time;
    }

    public static void advanceToMorning() {
        long l = worldTime + (long)DAY_LENGTH;
        LOTRTime.setWorldTime(l - l % (long)DAY_LENGTH);
    }

    public static void update() {
        MinecraftServer server = MinecraftServer.func_71276_C();
        WorldServer overworld = server.func_71218_a(0);
        if (LOTRMod.doDayCycle((World)overworld)) {
            ++worldTime;
        }
        ++totalTime;
        for (WorldServer world : server.field_71305_c) {
            if (!(world.field_73011_w instanceof LOTRWorldProvider)) continue;
            LOTRWorldInfo worldinfo = (LOTRWorldInfo)world.func_72912_H();
            worldinfo.lotr_setTotalTime(totalTime);
            worldinfo.lotr_setWorldTime(worldTime);
        }
    }

    static {
        needsLoad = true;
    }
}

