/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.enchant;

import com.google.common.collect.Lists;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import lotr.common.LOTRAchievement;
import lotr.common.LOTRConfig;
import lotr.common.LOTRLevelData;
import lotr.common.LOTRMod;
import lotr.common.enchant.LOTREnchantment;
import lotr.common.enchant.LOTREnchantmentBane;
import lotr.common.enchant.LOTREnchantmentDamage;
import lotr.common.enchant.LOTREnchantmentDurability;
import lotr.common.enchant.LOTREnchantmentKnockback;
import lotr.common.enchant.LOTREnchantmentLooting;
import lotr.common.enchant.LOTREnchantmentMeleeReach;
import lotr.common.enchant.LOTREnchantmentMeleeSpeed;
import lotr.common.enchant.LOTREnchantmentProtection;
import lotr.common.enchant.LOTREnchantmentProtectionFire;
import lotr.common.enchant.LOTREnchantmentProtectionSpecial;
import lotr.common.enchant.LOTREnchantmentRangedDamage;
import lotr.common.enchant.LOTREnchantmentRangedKnockback;
import lotr.common.enchant.LOTREnchantmentToolSpeed;
import lotr.common.enchant.LOTREnchantmentType;
import lotr.common.enchant.LOTREnchantmentWeaponSpecial;
import lotr.common.item.LOTRMaterial;
import lotr.common.network.LOTRPacketCancelItemHighlight;
import lotr.common.network.LOTRPacketHandler;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.item.ItemTool;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.StatCollector;
import net.minecraft.util.WeightedRandom;

public class LOTREnchantmentHelper {
    private static Map<UUID, ItemStack[]> lastKnownPlayerInventories = new HashMap<UUID, ItemStack[]>();
    private static Random backupRand;

    private static NBTTagList getItemEnchantTags(ItemStack itemstack, boolean create) {
        NBTTagCompound itemData = itemstack.func_77978_p();
        NBTTagList tags = null;
        if (itemData != null && itemData.func_74764_b("LOTREnch")) {
            tags = itemData.func_150295_c("LOTREnch", 8);
        } else if (create) {
            if (itemData == null) {
                itemData = new NBTTagCompound();
                itemstack.func_77982_d(itemData);
            }
            tags = new NBTTagList();
            itemData.func_74782_a("LOTREnch", (NBTBase)tags);
        }
        return tags;
    }

    private static NBTTagCompound getItemEnchantProgress(ItemStack itemstack, LOTREnchantment ench, boolean create) {
        NBTTagCompound itemData = itemstack.func_77978_p();
        if (itemData != null && itemData.func_74764_b("LOTREnchProgress")) {
            NBTTagList tags = itemData.func_150295_c("LOTREnchProgress", 10);
            for (int i = 0; i < tags.func_74745_c(); ++i) {
                NBTTagCompound enchData = tags.func_150305_b(i);
                if (!enchData.func_74779_i("Name").equals(ench.enchantName)) continue;
                return enchData;
            }
            if (create) {
                NBTTagCompound enchData = new NBTTagCompound();
                enchData.func_74778_a("Name", ench.enchantName);
                tags.func_74742_a((NBTBase)enchData);
                return enchData;
            }
        } else if (create) {
            if (itemData == null) {
                itemData = new NBTTagCompound();
                itemstack.func_77982_d(itemData);
            }
            NBTTagList tags = new NBTTagList();
            itemData.func_74782_a("LOTREnchProgress", (NBTBase)tags);
            NBTTagCompound enchData = new NBTTagCompound();
            enchData.func_74778_a("Name", ench.enchantName);
            tags.func_74742_a((NBTBase)enchData);
            return enchData;
        }
        return null;
    }

    public static boolean hasEnchant(ItemStack itemstack, LOTREnchantment ench) {
        NBTTagList tags = LOTREnchantmentHelper.getItemEnchantTags(itemstack, false);
        if (tags != null) {
            for (int i = 0; i < tags.func_74745_c(); ++i) {
                String s = tags.func_150307_f(i);
                if (!s.equals(ench.enchantName)) continue;
                return true;
            }
        }
        return false;
    }

    public static void setHasEnchant(ItemStack itemstack, LOTREnchantment ench) {
        NBTTagList tags;
        if (!LOTREnchantmentHelper.hasEnchant(itemstack, ench) && (tags = LOTREnchantmentHelper.getItemEnchantTags(itemstack, true)) != null) {
            String enchName = ench.enchantName;
            tags.func_74742_a((NBTBase)new NBTTagString(enchName));
        }
    }

    public static void removeEnchant(ItemStack itemstack, LOTREnchantment ench) {
        NBTTagList tags = LOTREnchantmentHelper.getItemEnchantTags(itemstack, true);
        if (tags != null) {
            String enchName = ench.enchantName;
            for (int i = 0; i < tags.func_74745_c(); ++i) {
                String s = tags.func_150307_f(i);
                if (!s.equals(enchName)) continue;
                tags.func_74744_a(i);
                break;
            }
        }
    }

    public static List<LOTREnchantment> getEnchantList(ItemStack itemstack) {
        ArrayList<LOTREnchantment> enchants = new ArrayList<LOTREnchantment>();
        NBTTagList tags = LOTREnchantmentHelper.getItemEnchantTags(itemstack, false);
        if (tags != null) {
            for (int i = 0; i < tags.func_74745_c(); ++i) {
                String s = tags.func_150307_f(i);
                LOTREnchantment ench = LOTREnchantment.getEnchantmentByName(s);
                if (ench == null) continue;
                enchants.add(ench);
            }
        }
        return enchants;
    }

    public static void setEnchantList(ItemStack itemstack, List<LOTREnchantment> enchants) {
        LOTREnchantmentHelper.clearEnchants(itemstack);
        for (LOTREnchantment ench : enchants) {
            LOTREnchantmentHelper.setHasEnchant(itemstack, ench);
        }
    }

    public static void clearEnchants(ItemStack itemstack) {
        NBTTagCompound itemData = itemstack.func_77978_p();
        if (itemData != null && itemData.func_74764_b("LOTREnch")) {
            itemData.func_82580_o("LOTREnch");
        }
    }

    public static void clearEnchantsAndProgress(ItemStack itemstack) {
        LOTREnchantmentHelper.clearEnchants(itemstack);
        NBTTagCompound itemData = itemstack.func_77978_p();
        if (itemData != null && itemData.func_74764_b("LOTREnchProgress")) {
            itemData.func_82580_o("LOTREnchProgress");
        }
    }

    public static boolean checkEnchantCompatible(ItemStack itemstack, LOTREnchantment ench) {
        List<LOTREnchantment> enchants = LOTREnchantmentHelper.getEnchantList(itemstack);
        for (LOTREnchantment itemEnch : enchants) {
            if (itemEnch.isCompatibleWith(ench) && ench.isCompatibleWith(itemEnch)) continue;
            return false;
        }
        return true;
    }

    public static String getFullEnchantedName(ItemStack itemstack, String name) {
        List enchants = LOTREnchantmentHelper.getEnchantList(itemstack);
        enchants = Lists.reverse(enchants);
        for (LOTREnchantment ench : enchants) {
            name = StatCollector.func_74837_a((String)"lotr.enchant.nameFormat", (Object[])new Object[]{ench.getDisplayName(), name});
        }
        return name;
    }

    private static boolean hasAppliedRandomEnchants(ItemStack itemstack) {
        NBTTagCompound nbt = itemstack.func_77978_p();
        if (nbt != null && nbt.func_74764_b("LOTRRandomEnch")) {
            return nbt.func_74767_n("LOTRRandomEnch");
        }
        return false;
    }

    private static void setAppliedRandomEnchants(ItemStack itemstack) {
        if (!itemstack.func_77942_o()) {
            itemstack.func_77982_d(new NBTTagCompound());
        }
        itemstack.func_77978_p().func_74757_a("LOTRRandomEnch", true);
    }

    private static boolean canApplyAnyEnchant(ItemStack itemstack) {
        for (LOTREnchantment ench : LOTREnchantment.allEnchantments) {
            if (!ench.canApply(itemstack, true)) continue;
            return true;
        }
        return false;
    }

    public static int getAnvilCost(ItemStack itemstack) {
        NBTTagCompound nbt = itemstack.func_77978_p();
        if (nbt != null && nbt.func_74764_b("LOTRRepairCost")) {
            return nbt.func_74762_e("LOTRRepairCost");
        }
        return 0;
    }

    public static void setAnvilCost(ItemStack itemstack, int cost) {
        if (!itemstack.func_77942_o()) {
            itemstack.func_77982_d(new NBTTagCompound());
        }
        itemstack.func_77978_p().func_74768_a("LOTRRepairCost", cost);
    }

    public static boolean isReforgeable(ItemStack itemstack) {
        return !LOTREnchantmentHelper.getEnchantList(itemstack).isEmpty() || LOTREnchantmentHelper.canApplyAnyEnchant(itemstack);
    }

    public static void onEntityUpdate(EntityLivingBase entity) {
        Random rand = entity.func_70681_au();
        if (LOTRConfig.enchantingLOTR) {
            boolean init;
            if (entity instanceof EntityLiving && !(init = entity.getEntityData().func_74767_n("LOTREnchantInit"))) {
                for (int i = 0; i < entity.func_70035_c().length; ++i) {
                    ItemStack itemstack = entity.func_71124_b(i);
                    LOTREnchantmentHelper.tryApplyRandomEnchantsForEntity(itemstack, rand);
                }
                entity.getEntityData().func_74757_a("LOTREnchantInit", true);
            }
            if (entity instanceof EntityPlayerMP) {
                EntityPlayerMP entityplayer = (EntityPlayerMP)entity;
                UUID playerID = entityplayer.func_110124_au();
                InventoryPlayer inv = entityplayer.field_71071_by;
                ItemStack[] lastKnownInv = lastKnownPlayerInventories.get(playerID);
                if (lastKnownInv == null) {
                    lastKnownInv = new ItemStack[inv.func_70302_i_()];
                }
                for (int i = 0; i < inv.func_70302_i_(); ++i) {
                    ItemStack lastKnownItem;
                    ItemStack itemstack = inv.func_70301_a(i);
                    if (ItemStack.func_77989_b((ItemStack)itemstack, (ItemStack)(lastKnownItem = lastKnownInv[i]))) continue;
                    LOTREnchantmentHelper.tryApplyRandomEnchantsForEntity(itemstack, rand);
                    lastKnownInv[i] = lastKnownItem = itemstack == null ? null : itemstack.func_77946_l();
                }
                if (LOTREnchantmentHelper.tryApplyRandomEnchantsForEntity(inv.func_70445_o(), rand)) {
                    entityplayer.func_71113_k();
                }
                lastKnownPlayerInventories.put(playerID, lastKnownInv);
                if (lastKnownPlayerInventories.size() > 200) {
                    lastKnownPlayerInventories.clear();
                }
            }
        }
    }

    private static boolean tryApplyRandomEnchantsForEntity(ItemStack itemstack, Random rand) {
        if (itemstack != null && !LOTREnchantmentHelper.hasAppliedRandomEnchants(itemstack) && LOTREnchantmentHelper.canApplyAnyEnchant(itemstack)) {
            LOTREnchantmentHelper.applyRandomEnchantments(itemstack, rand, false, false);
            return true;
        }
        return false;
    }

    public static int getSkilfulWeight(LOTREnchantment ench) {
        int weight = ench.getEnchantWeight();
        double wd = weight;
        if (ench.isBeneficial()) {
            wd = Math.pow(wd, 0.3);
        }
        wd *= 100.0;
        if (!ench.isBeneficial()) {
            wd *= 0.15;
        }
        weight = (int)Math.round(wd);
        weight = Math.max(weight, 1);
        return weight;
    }

    public static void applyRandomEnchantments(ItemStack itemstack, Random random, boolean skilful, boolean keepBanes) {
        LOTREnchantment ench;
        if (!keepBanes) {
            LOTREnchantmentHelper.clearEnchantsAndProgress(itemstack);
        } else {
            List<LOTREnchantment> enchants = LOTREnchantmentHelper.getEnchantList(itemstack);
            for (LOTREnchantment ench2 : enchants) {
                if (ench2.persistsReforge()) continue;
                LOTREnchantmentHelper.removeEnchant(itemstack, ench2);
            }
        }
        if (itemstack.func_77973_b() instanceof ItemSword && LOTRMaterial.getToolMaterialByName(((ItemSword)itemstack.func_77973_b()).func_150932_j()) == LOTRMaterial.BARROW.toToolMaterial() && (ench = LOTREnchantment.baneWight).canApply(itemstack, false)) {
            LOTREnchantmentHelper.setHasEnchant(itemstack, ench);
        }
        if (itemstack.func_77973_b() == LOTRMod.sting && (ench = LOTREnchantment.baneSpider).canApply(itemstack, false)) {
            LOTREnchantmentHelper.setHasEnchant(itemstack, ench);
        }
        int enchants = 0;
        float chance = random.nextFloat();
        if (skilful) {
            if (chance < 0.15f) {
                enchants = 2;
            } else if (chance < 0.8f) {
                enchants = 1;
            }
        } else if (chance < 0.1f) {
            enchants = 2;
        } else if (chance < 0.65f) {
            enchants = 1;
        }
        ArrayList<WeightedRandomEnchant> applicable = new ArrayList<WeightedRandomEnchant>();
        for (LOTREnchantment ench3 : LOTREnchantment.allEnchantments) {
            int weight;
            if (!ench3.canApply(itemstack, true) || ench3.isSkilful() && !skilful || (weight = ench3.getEnchantWeight()) <= 0) continue;
            weight = skilful ? LOTREnchantmentHelper.getSkilfulWeight(ench3) : (weight *= 100);
            if (weight > 0 && itemstack.func_77973_b() instanceof ItemTool && !ench3.itemTypes.contains((Object)LOTREnchantmentType.TOOL) && !ench3.itemTypes.contains((Object)LOTREnchantmentType.BREAKABLE)) {
                weight /= 3;
                weight = Math.max(weight, 1);
            }
            WeightedRandomEnchant wre = new WeightedRandomEnchant(ench3, weight);
            applicable.add(wre);
        }
        if (!applicable.isEmpty()) {
            ArrayList<LOTREnchantment> chosenEnchants = new ArrayList<LOTREnchantment>();
            for (int l = 0; l < enchants && !applicable.isEmpty(); ++l) {
                WeightedRandomEnchant chosenWre = (WeightedRandomEnchant)WeightedRandom.func_76271_a((Random)random, applicable);
                LOTREnchantment chosenEnch = chosenWre.theEnchant;
                chosenEnchants.add(chosenEnch);
                applicable.remove((Object)chosenWre);
                ArrayList<WeightedRandomEnchant> nowIncompatibles = new ArrayList<WeightedRandomEnchant>();
                for (WeightedRandomEnchant wre : applicable) {
                    LOTREnchantment otherEnch = wre.theEnchant;
                    if (otherEnch.isCompatibleWith(chosenEnch)) continue;
                    nowIncompatibles.add(wre);
                }
                applicable.removeAll(nowIncompatibles);
            }
            for (LOTREnchantment ench4 : chosenEnchants) {
                if (!ench4.canApply(itemstack, false)) continue;
                LOTREnchantmentHelper.setHasEnchant(itemstack, ench4);
            }
        }
        if (!LOTREnchantmentHelper.getEnchantList(itemstack).isEmpty() || LOTREnchantmentHelper.canApplyAnyEnchant(itemstack)) {
            LOTREnchantmentHelper.setAppliedRandomEnchants(itemstack);
        }
    }

    public static float calcTradeValueFactor(ItemStack itemstack) {
        float value = 1.0f;
        List<LOTREnchantment> enchants = LOTREnchantmentHelper.getEnchantList(itemstack);
        for (LOTREnchantment ench : enchants) {
            value *= ench.getValueModifier();
            if (!ench.isSkilful()) continue;
            value *= 1.5f;
        }
        return value;
    }

    public static float calcBaseMeleeDamageBoost(ItemStack itemstack) {
        float damage = 0.0f;
        if (itemstack != null) {
            List<LOTREnchantment> enchants = LOTREnchantmentHelper.getEnchantList(itemstack);
            for (LOTREnchantment ench : enchants) {
                if (!(ench instanceof LOTREnchantmentDamage)) continue;
                damage += ((LOTREnchantmentDamage)ench).getBaseDamageBoost();
            }
        }
        return damage;
    }

    public static float calcEntitySpecificDamage(ItemStack itemstack, EntityLivingBase entity) {
        float damage = 0.0f;
        if (itemstack != null) {
            List<LOTREnchantment> enchants = LOTREnchantmentHelper.getEnchantList(itemstack);
            for (LOTREnchantment ench : enchants) {
                if (!(ench instanceof LOTREnchantmentDamage)) continue;
                damage += ((LOTREnchantmentDamage)ench).getEntitySpecificDamage(entity);
            }
        }
        return damage;
    }

    public static float calcMeleeSpeedFactor(ItemStack itemstack) {
        float speed = 1.0f;
        if (itemstack != null) {
            List<LOTREnchantment> enchants = LOTREnchantmentHelper.getEnchantList(itemstack);
            for (LOTREnchantment ench : enchants) {
                if (!(ench instanceof LOTREnchantmentMeleeSpeed)) continue;
                speed *= ((LOTREnchantmentMeleeSpeed)ench).speedFactor;
            }
        }
        return speed;
    }

    public static float calcMeleeReachFactor(ItemStack itemstack) {
        float reach = 1.0f;
        if (itemstack != null) {
            List<LOTREnchantment> enchants = LOTREnchantmentHelper.getEnchantList(itemstack);
            for (LOTREnchantment ench : enchants) {
                if (!(ench instanceof LOTREnchantmentMeleeReach)) continue;
                reach *= ((LOTREnchantmentMeleeReach)ench).reachFactor;
            }
        }
        return reach;
    }

    public static int calcExtraKnockback(ItemStack itemstack) {
        int kb = 0;
        if (itemstack != null) {
            List<LOTREnchantment> enchants = LOTREnchantmentHelper.getEnchantList(itemstack);
            for (LOTREnchantment ench : enchants) {
                if (!(ench instanceof LOTREnchantmentKnockback)) continue;
                kb += ((LOTREnchantmentKnockback)ench).knockback;
            }
        }
        return kb;
    }

    public static boolean negateDamage(ItemStack itemstack, Random random) {
        if (itemstack != null) {
            if (random == null) {
                if (backupRand == null) {
                    backupRand = new Random();
                }
                random = backupRand;
            }
            List<LOTREnchantment> enchants = LOTREnchantmentHelper.getEnchantList(itemstack);
            for (LOTREnchantment ench : enchants) {
                float durability;
                if (!(ench instanceof LOTREnchantmentDurability) || !((durability = ((LOTREnchantmentDurability)ench).durabilityFactor) > 1.0f)) continue;
                float inv = 1.0f / durability;
                if (!(random.nextFloat() > inv)) continue;
                return true;
            }
        }
        return false;
    }

    public static float calcToolEfficiency(ItemStack itemstack) {
        float speed = 1.0f;
        if (itemstack != null) {
            List<LOTREnchantment> enchants = LOTREnchantmentHelper.getEnchantList(itemstack);
            for (LOTREnchantment ench : enchants) {
                if (!(ench instanceof LOTREnchantmentToolSpeed)) continue;
                speed *= ((LOTREnchantmentToolSpeed)ench).speedFactor;
            }
        }
        return speed;
    }

    public static boolean isSilkTouch(ItemStack itemstack) {
        return itemstack != null && LOTREnchantmentHelper.hasEnchant(itemstack, LOTREnchantment.toolSilk);
    }

    public static int calcLootingLevel(ItemStack itemstack) {
        int looting = 0;
        if (itemstack != null) {
            List<LOTREnchantment> enchants = LOTREnchantmentHelper.getEnchantList(itemstack);
            for (LOTREnchantment ench : enchants) {
                if (!(ench instanceof LOTREnchantmentLooting)) continue;
                looting += ((LOTREnchantmentLooting)ench).lootLevel;
            }
        }
        return looting;
    }

    public static int calcCommonArmorProtection(ItemStack itemstack) {
        int protection = 0;
        if (itemstack != null) {
            List<LOTREnchantment> enchants = LOTREnchantmentHelper.getEnchantList(itemstack);
            for (LOTREnchantment ench : enchants) {
                if (!(ench instanceof LOTREnchantmentProtection)) continue;
                protection += ((LOTREnchantmentProtection)ench).protectLevel;
            }
        }
        return protection;
    }

    public static int calcSpecialArmorSetProtection(ItemStack[] armor, DamageSource source) {
        int protection = 0;
        if (armor != null) {
            for (ItemStack itemstack : armor) {
                if (itemstack == null) continue;
                List<LOTREnchantment> enchants = LOTREnchantmentHelper.getEnchantList(itemstack);
                for (LOTREnchantment ench : enchants) {
                    if (!(ench instanceof LOTREnchantmentProtectionSpecial)) continue;
                    protection += ((LOTREnchantmentProtectionSpecial)ench).calcSpecialProtection(source);
                }
            }
        }
        return protection;
    }

    public static int getMaxFireProtectionLevel(ItemStack[] armor) {
        int max = 0;
        if (armor != null) {
            for (ItemStack itemstack : armor) {
                if (itemstack == null) continue;
                List<LOTREnchantment> enchants = LOTREnchantmentHelper.getEnchantList(itemstack);
                for (LOTREnchantment ench : enchants) {
                    int protection;
                    if (!(ench instanceof LOTREnchantmentProtectionFire) || (protection = ((LOTREnchantmentProtectionFire)ench).protectLevel) <= max) continue;
                    max = protection;
                }
            }
        }
        return max;
    }

    public static float calcRangedDamageFactor(ItemStack itemstack) {
        float damage = 1.0f;
        if (itemstack != null) {
            List<LOTREnchantment> enchants = LOTREnchantmentHelper.getEnchantList(itemstack);
            for (LOTREnchantment ench : enchants) {
                if (!(ench instanceof LOTREnchantmentRangedDamage)) continue;
                damage *= ((LOTREnchantmentRangedDamage)ench).damageFactor;
            }
        }
        return damage;
    }

    public static int calcRangedKnockback(ItemStack itemstack) {
        int kb = 0;
        if (itemstack != null) {
            List<LOTREnchantment> enchants = LOTREnchantmentHelper.getEnchantList(itemstack);
            for (LOTREnchantment ench : enchants) {
                if (!(ench instanceof LOTREnchantmentRangedKnockback)) continue;
                kb += ((LOTREnchantmentRangedKnockback)ench).knockback;
            }
        }
        return kb;
    }

    public static int calcFireAspect(ItemStack itemstack) {
        int fire = 0;
        if (itemstack != null) {
            List<LOTREnchantment> enchants = LOTREnchantmentHelper.getEnchantList(itemstack);
            for (LOTREnchantment ench : enchants) {
                if (ench != LOTREnchantment.fire) continue;
                fire += LOTREnchantmentWeaponSpecial.getFireAmount();
            }
        }
        return fire;
    }

    public static int calcFireAspectForMelee(ItemStack itemstack) {
        if (itemstack != null && LOTREnchantmentType.MELEE.canApply(itemstack, false)) {
            return LOTREnchantmentHelper.calcFireAspect(itemstack);
        }
        return 0;
    }

    public static void onKillEntity(EntityPlayer entityplayer, EntityLivingBase target, DamageSource source) {
        if (source.func_76364_f() == entityplayer) {
            ItemStack weapon = entityplayer.func_70694_bm();
            Random rand = entityplayer.func_70681_au();
            if (weapon != null) {
                boolean progressChanged = false;
                boolean enchantsChanged = false;
                for (LOTREnchantment ench : LOTREnchantment.allEnchantments) {
                    boolean compatible;
                    if (!ench.canApply(weapon, false) || !(ench instanceof LOTREnchantmentBane)) continue;
                    LOTREnchantmentBane enchBane = (LOTREnchantmentBane)ench;
                    if (!enchBane.isAchievable || !enchBane.doesEntityKillCountTowardsBane(target, entityplayer.field_70170_p)) continue;
                    NBTTagCompound nbt = LOTREnchantmentHelper.getItemEnchantProgress(weapon, ench, true);
                    int killed = 0;
                    if (nbt.func_74764_b("Kills")) {
                        killed = nbt.func_74762_e("Kills");
                    }
                    nbt.func_74768_a("Kills", ++killed);
                    progressChanged = true;
                    int requiredKills = 0;
                    if (nbt.func_74764_b("KillsRequired")) {
                        requiredKills = nbt.func_74762_e("KillsRequired");
                    } else {
                        requiredKills = enchBane.getRandomKillsRequired(rand);
                        nbt.func_74768_a("KillsRequired", requiredKills);
                    }
                    if (killed < requiredKills || LOTREnchantmentHelper.hasEnchant(weapon, enchBane) || !(compatible = LOTREnchantmentHelper.checkEnchantCompatible(weapon, enchBane))) continue;
                    LOTREnchantmentHelper.setHasEnchant(weapon, enchBane);
                    enchantsChanged = true;
                    entityplayer.func_145747_a(enchBane.getEarnMessage(weapon));
                    for (Object obj : MinecraftServer.func_71276_C().func_71203_ab().field_72404_b) {
                        EntityPlayer otherPlayer = (EntityPlayer)obj;
                        if (otherPlayer == entityplayer) continue;
                        otherPlayer.func_145747_a(enchBane.getEarnMessageWithName(entityplayer, weapon));
                    }
                    if (enchBane == LOTREnchantment.baneElf) {
                        LOTRLevelData.getData(entityplayer).addAchievement(LOTRAchievement.enchantBaneElf);
                        continue;
                    }
                    if (enchBane == LOTREnchantment.baneOrc) {
                        LOTRLevelData.getData(entityplayer).addAchievement(LOTRAchievement.enchantBaneOrc);
                        continue;
                    }
                    if (enchBane == LOTREnchantment.baneDwarf) {
                        LOTRLevelData.getData(entityplayer).addAchievement(LOTRAchievement.enchantBaneDwarf);
                        continue;
                    }
                    if (enchBane == LOTREnchantment.baneWarg) {
                        LOTRLevelData.getData(entityplayer).addAchievement(LOTRAchievement.enchantBaneWarg);
                        continue;
                    }
                    if (enchBane == LOTREnchantment.baneTroll) {
                        LOTRLevelData.getData(entityplayer).addAchievement(LOTRAchievement.enchantBaneTroll);
                        continue;
                    }
                    if (enchBane == LOTREnchantment.baneSpider) {
                        LOTRLevelData.getData(entityplayer).addAchievement(LOTRAchievement.enchantBaneSpider);
                        continue;
                    }
                    if (enchBane != LOTREnchantment.baneWight) continue;
                    LOTRLevelData.getData(entityplayer).addAchievement(LOTRAchievement.enchantBaneWight);
                }
                if (progressChanged && !enchantsChanged) {
                    LOTRPacketCancelItemHighlight pkt = new LOTRPacketCancelItemHighlight();
                    LOTRPacketHandler.networkWrapper.sendTo((IMessage)pkt, (EntityPlayerMP)entityplayer);
                }
            }
        }
    }

    private static NBTTagList getEntityEnchantTags(Entity entity, boolean create) {
        NBTTagCompound data = entity.getEntityData();
        NBTTagList tags = null;
        if (data != null && data.func_74764_b("LOTREnchEntity")) {
            tags = data.func_150295_c("LOTREnchEntity", 8);
        } else if (create) {
            tags = new NBTTagList();
            data.func_74782_a("LOTREnchEntity", (NBTBase)tags);
        }
        return tags;
    }

    public static void setProjectileEnchantment(Entity entity, LOTREnchantment ench) {
        NBTTagList tags;
        if (!LOTREnchantmentHelper.hasProjectileEnchantment(entity, ench) && (tags = LOTREnchantmentHelper.getEntityEnchantTags(entity, true)) != null) {
            String enchName = ench.enchantName;
            tags.func_74742_a((NBTBase)new NBTTagString(enchName));
        }
    }

    public static boolean hasProjectileEnchantment(Entity entity, LOTREnchantment ench) {
        NBTTagList tags = LOTREnchantmentHelper.getEntityEnchantTags(entity, false);
        if (tags != null) {
            for (int i = 0; i < tags.func_74745_c(); ++i) {
                String s = tags.func_150307_f(i);
                if (!s.equals(ench.enchantName)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean hasMeleeOrRangedEnchant(DamageSource source, LOTREnchantment ench) {
        ItemStack weapon;
        EntityLivingBase attackerLiving;
        Entity attacker = source.func_76346_g();
        Entity sourceEntity = source.func_76364_f();
        if (attacker instanceof EntityLivingBase && (attackerLiving = (EntityLivingBase)attacker) == sourceEntity && (weapon = attackerLiving.func_70694_bm()) != null && LOTREnchantmentType.MELEE.canApply(weapon, false) && LOTREnchantmentHelper.hasEnchant(weapon, ench)) {
            return true;
        }
        return sourceEntity != null && LOTREnchantmentHelper.hasProjectileEnchantment(sourceEntity, ench);
    }

    public static class WeightedRandomEnchant
    extends WeightedRandom.Item {
        public final LOTREnchantment theEnchant;

        public WeightedRandomEnchant(LOTREnchantment e, int weight) {
            super(weight);
            this.theEnchant = e;
        }
    }
}

