/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.entity;

import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import lotr.common.LOTRAchievement;
import lotr.common.LOTRBannerProtection;
import lotr.common.LOTRConfig;
import lotr.common.LOTRLevelData;
import lotr.common.LOTRMod;
import lotr.common.LOTRPlayerData;
import lotr.common.entity.LOTREntities;
import lotr.common.entity.LOTREntityNPCRespawner;
import lotr.common.entity.npc.LOTREntityNPC;
import lotr.common.fac.LOTRFaction;
import lotr.common.item.LOTRItemConquestHorn;
import lotr.common.network.LOTRPacketHandler;
import lotr.common.network.LOTRPacketInvasionWatch;
import lotr.common.world.spawning.LOTRInvasions;
import net.minecraft.command.IEntitySelector;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.WeightedRandom;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.event.ForgeEventFactory;

public class LOTREntityInvasionSpawner
extends Entity {
    public float spawnerSpin;
    public float prevSpawnerSpin;
    private int invasionSize;
    public static final int MAX_INVASION_SIZE = 10000;
    private int invasionRemaining;
    private int successiveFailedSpawns = 0;
    private int timeSincePlayerProgress = 0;
    private Map<UUID, Integer> recentPlayerContributors = new HashMap<UUID, Integer>();
    private static double INVASION_FOLLOW_RANGE = 40.0;
    public boolean isWarhorn = false;
    public boolean spawnsPersistent = true;
    private List<LOTRFaction> bonusFactions = new ArrayList<LOTRFaction>();

    public LOTREntityInvasionSpawner(World world) {
        super(world);
        this.func_70105_a(1.5f, 1.5f);
        this.field_70155_l = 4.0;
        this.spawnerSpin = this.field_70146_Z.nextFloat() * 360.0f;
    }

    public ItemStack getInvasionItem() {
        return this.getInvasionType().getInvasionIcon();
    }

    public void func_70088_a() {
        this.field_70180_af.func_75682_a(20, (Object)0);
        this.field_70180_af.func_75682_a(21, (Object)0);
        this.field_70180_af.func_75682_a(22, (Object)0);
    }

    public LOTRInvasions getInvasionType() {
        byte i = this.field_70180_af.func_75683_a(20);
        LOTRInvasions type = LOTRInvasions.forID(i);
        if (type != null) {
            return type;
        }
        return LOTRInvasions.HOBBIT;
    }

    public void setInvasionType(LOTRInvasions type) {
        this.field_70180_af.func_75692_b(20, (Object)((byte)type.ordinal()));
    }

    private void updateWatchedInvasionValues() {
        if (!this.field_70170_p.field_72995_K) {
            this.field_70180_af.func_75692_b(21, (Object)((short)this.invasionSize));
            this.field_70180_af.func_75692_b(22, (Object)((short)this.invasionRemaining));
        } else {
            this.invasionSize = this.field_70180_af.func_75693_b(21);
            this.invasionRemaining = this.field_70180_af.func_75693_b(22);
        }
    }

    public int getInvasionSize() {
        return this.invasionSize;
    }

    public float getInvasionHealthStatus() {
        return (float)this.invasionRemaining / (float)this.invasionSize;
    }

    public UUID getInvasionID() {
        return this.func_110124_au();
    }

    public boolean canInvasionSpawnHere() {
        if (LOTRBannerProtection.isProtected(this.field_70170_p, this, LOTRBannerProtection.forInvasionSpawner(this), false)) {
            return false;
        }
        if (LOTREntityNPCRespawner.isSpawnBlocked(this, this.getInvasionType().invasionFaction)) {
            return false;
        }
        return this.field_70170_p.func_72855_b(this.field_70121_D) && this.field_70170_p.func_72945_a((Entity)this, this.field_70121_D).isEmpty() && !this.field_70170_p.func_72953_d(this.field_70121_D);
    }

    private void playHorn() {
        this.field_70170_p.func_72956_a((Entity)this, "lotr:item.horn", 4.0f, 0.65f + this.field_70146_Z.nextFloat() * 0.1f);
    }

    public void startInvasion() {
        this.startInvasion(null);
    }

    public void startInvasion(EntityPlayer announcePlayer) {
        this.startInvasion(announcePlayer, -1);
    }

    public void startInvasion(EntityPlayer announcePlayer, int size) {
        if (size < 0) {
            size = MathHelper.func_76136_a((Random)this.field_70146_Z, (int)30, (int)70);
        }
        this.invasionRemaining = this.invasionSize = size;
        this.playHorn();
        double announceRange = INVASION_FOLLOW_RANGE * 2.0;
        List nearbyPlayers = this.field_70170_p.func_72872_a(EntityPlayer.class, this.field_70121_D.func_72314_b(announceRange, announceRange, announceRange));
        if (announcePlayer != null && !nearbyPlayers.contains(announcePlayer)) {
            nearbyPlayers.add(announcePlayer);
        }
        for (EntityPlayer entityplayer : nearbyPlayers) {
            boolean announce;
            boolean bl = announce = LOTRLevelData.getData(entityplayer).getAlignment(this.getInvasionType().invasionFaction) < 0.0f;
            if (entityplayer == announcePlayer) {
                announce = true;
            }
            if (!announce) continue;
            this.announceInvasionTo(entityplayer);
            this.setWatchingInvasion((EntityPlayerMP)entityplayer, false);
        }
    }

    private void announceInvasionTo(EntityPlayer entityplayer) {
        entityplayer.func_145747_a((IChatComponent)new ChatComponentTranslation("chat.lotr.invasion.start", new Object[]{this.getInvasionType().invasionName()}));
    }

    public void setWatchingInvasion(EntityPlayerMP entityplayer, boolean overrideAlreadyWatched) {
        LOTRPacketInvasionWatch pkt = new LOTRPacketInvasionWatch(this, overrideAlreadyWatched);
        LOTRPacketHandler.networkWrapper.sendTo((IMessage)pkt, entityplayer);
    }

    public void selectAppropriateBonusFactions() {
        if (LOTRFaction.controlZonesEnabled(this.field_70170_p)) {
            LOTRFaction invasionFaction = this.getInvasionType().invasionFaction;
            for (LOTRFaction faction : invasionFaction.getBonusesForKilling()) {
                if (faction.isolationist || !faction.inDefinedControlZone(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, 50)) continue;
                this.bonusFactions.add(faction);
            }
            if (this.bonusFactions.isEmpty()) {
                int nearestRange = 150;
                LOTRFaction nearest = null;
                double nearestDist = Double.MAX_VALUE;
                for (LOTRFaction faction : invasionFaction.getBonusesForKilling()) {
                    double dist;
                    if (faction.isolationist || !((dist = faction.distanceToNearestControlZoneInRange(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, nearestRange)) >= 0.0) || nearest != null && !(dist < nearestDist)) continue;
                    nearest = faction;
                    nearestDist = dist;
                }
                if (nearest != null) {
                    this.bonusFactions.add(nearest);
                }
            }
        }
    }

    public void func_70014_b(NBTTagCompound nbt) {
        nbt.func_74778_a("InvasionType", this.getInvasionType().codeName());
        nbt.func_74768_a("InvasionSize", this.invasionSize);
        nbt.func_74768_a("InvasionRemaining", this.invasionRemaining);
        nbt.func_74768_a("SuccessiveFailedSpawns", this.successiveFailedSpawns);
        nbt.func_74768_a("TimeSinceProgress", this.timeSincePlayerProgress);
        if (!this.recentPlayerContributors.isEmpty()) {
            NBTTagList recentTags = new NBTTagList();
            for (Map.Entry<UUID, Integer> e : this.recentPlayerContributors.entrySet()) {
                UUID player = e.getKey();
                int time = e.getValue();
                NBTTagCompound playerData = new NBTTagCompound();
                playerData.func_74778_a("Player", player.toString());
                playerData.func_74777_a("Time", (short)time);
                recentTags.func_74742_a((NBTBase)playerData);
            }
            nbt.func_74782_a("RecentPlayers", (NBTBase)recentTags);
        }
        nbt.func_74757_a("Warhorn", this.isWarhorn);
        nbt.func_74757_a("NPCPersistent", this.spawnsPersistent);
        if (!this.bonusFactions.isEmpty()) {
            NBTTagList bonusTags = new NBTTagList();
            for (LOTRFaction f : this.bonusFactions) {
                String fName = f.codeName();
                bonusTags.func_74742_a((NBTBase)new NBTTagString(fName));
            }
            nbt.func_74782_a("BonusFactions", (NBTBase)bonusTags);
        }
    }

    public void func_70037_a(NBTTagCompound nbt) {
        LOTRInvasions type = LOTRInvasions.forName(nbt.func_74779_i("InvasionType"));
        if (type == null && nbt.func_74764_b("Faction")) {
            String factionName = nbt.func_74779_i("Faction");
            type = LOTRInvasions.forName(factionName);
        }
        if (type == null || type.invasionMobs.isEmpty()) {
            this.func_70106_y();
        } else {
            int i;
            this.setInvasionType(type);
            if (nbt.func_74764_b("MobsRemaining")) {
                this.invasionSize = this.invasionRemaining = nbt.func_74762_e("MobsRemaining");
            } else {
                this.invasionSize = nbt.func_74762_e("InvasionSize");
                this.invasionRemaining = nbt.func_74764_b("InvasionRemaining") ? nbt.func_74762_e("InvasionRemaining") : this.invasionSize;
            }
            this.successiveFailedSpawns = nbt.func_74762_e("SuccessiveFailedSpawns");
            this.timeSincePlayerProgress = nbt.func_74762_e("TimeSinceProgress");
            this.recentPlayerContributors.clear();
            if (nbt.func_74764_b("RecentPlayers")) {
                NBTTagList recentTags = nbt.func_150295_c("RecentPlayers", 10);
                for (i = 0; i < recentTags.func_74745_c(); ++i) {
                    NBTTagCompound playerData = recentTags.func_150305_b(i);
                    String playerS = playerData.func_74779_i("Player");
                    try {
                        UUID player = UUID.fromString(playerS);
                        if (player == null) continue;
                        short time = playerData.func_74765_d("Time");
                        this.recentPlayerContributors.put(player, Integer.valueOf(time));
                        continue;
                    }
                    catch (IllegalArgumentException e) {
                        FMLLog.warning((String)"LOTR: Error loading invasion recent players - %s is not a valid UUID", (Object[])new Object[]{playerS});
                        e.printStackTrace();
                    }
                }
            }
            if (nbt.func_74764_b("Warhorn")) {
                this.isWarhorn = nbt.func_74767_n("Warhorn");
            }
            if (nbt.func_74764_b("NPCPersistent")) {
                this.spawnsPersistent = nbt.func_74767_n("NPCPersistent");
            }
            if (nbt.func_74764_b("BonusFactions")) {
                NBTTagList bonusTags = nbt.func_150295_c("BonusFactions", 8);
                for (i = 0; i < bonusTags.func_74745_c(); ++i) {
                    String fName = bonusTags.func_150307_f(i);
                    LOTRFaction f = LOTRFaction.forName(fName);
                    if (f == null) continue;
                    this.bonusFactions.add(f);
                }
            }
        }
    }

    private void endInvasion(boolean completed) {
        if (completed) {
            LOTRFaction invasionFac = this.getInvasionType().invasionFaction;
            float conqBoost = 50.0f;
            HashSet<EntityPlayer> achievementPlayers = new HashSet<EntityPlayer>();
            HashSet<EntityPlayer> conqRewardPlayers = new HashSet<EntityPlayer>();
            for (UUID player : this.recentPlayerContributors.keySet()) {
                LOTRFaction pledged;
                EntityPlayer entityplayer = this.field_70170_p.func_152378_a(player);
                if (entityplayer == null) continue;
                double range = 100.0;
                if (entityplayer.field_71093_bK != this.field_71093_bK || !(entityplayer.func_70068_e((Entity)this) < range * range)) continue;
                LOTRPlayerData pd = LOTRLevelData.getData(player);
                if (pd.getAlignment(invasionFac) <= 0.0f) {
                    achievementPlayers.add(entityplayer);
                }
                if ((pledged = pd.getPledgeFaction()) == null || !pledged.isBadRelation(invasionFac)) continue;
                conqRewardPlayers.add(entityplayer);
            }
            for (EntityPlayer entityplayer : achievementPlayers) {
                LOTRPlayerData pd = LOTRLevelData.getData(entityplayer);
                pd.addAchievement(LOTRAchievement.defeatInvasion);
            }
            if (!conqRewardPlayers.isEmpty()) {
                float boostPerPlayer = 50.0f / (float)conqRewardPlayers.size();
                for (EntityPlayer entityplayer : conqRewardPlayers) {
                    LOTRPlayerData pd = LOTRLevelData.getData(entityplayer);
                    pd.givePureConquestBonus(entityplayer, pd.getPledgeFaction(), this.getInvasionType().invasionFaction, boostPerPlayer, "lotr.alignment.invasionDefeat", this.field_70165_t, this.field_70163_u, this.field_70161_v);
                }
            }
        }
        this.field_70170_p.func_72876_a((Entity)this, this.field_70165_t, this.field_70163_u + (double)this.field_70131_O / 2.0, this.field_70161_v, 0.0f, false);
        this.func_70106_y();
    }

    public void func_70071_h_() {
        if (!this.field_70170_p.field_72995_K && this.field_70170_p.field_73013_u == EnumDifficulty.PEACEFUL) {
            this.endInvasion(false);
            return;
        }
        this.field_70169_q = this.field_70165_t;
        this.field_70167_r = this.field_70163_u;
        this.field_70166_s = this.field_70161_v;
        this.prevSpawnerSpin = this.spawnerSpin;
        this.spawnerSpin += 6.0f;
        this.prevSpawnerSpin = MathHelper.func_76142_g((float)this.prevSpawnerSpin);
        this.spawnerSpin = MathHelper.func_76142_g((float)this.spawnerSpin);
        this.field_70159_w = 0.0;
        this.field_70181_x = 0.0;
        this.field_70179_y = 0.0;
        this.func_70091_d(this.field_70159_w, this.field_70181_x, this.field_70179_y);
        if (!this.field_70170_p.field_72995_K) {
            if (this.invasionRemaining > 0) {
                ++this.timeSincePlayerProgress;
                if (LOTRConfig.invasionProgressReverts && this.timeSincePlayerProgress >= 6000 && !this.isWarhorn && this.timeSincePlayerProgress % 1200 == 0) {
                    ++this.invasionRemaining;
                    this.invasionRemaining = Math.min(this.invasionRemaining, this.invasionSize);
                }
                if (!this.recentPlayerContributors.isEmpty()) {
                    HashSet<UUID> removes = new HashSet<UUID>();
                    for (Map.Entry<UUID, Integer> e : this.recentPlayerContributors.entrySet()) {
                        UUID player = e.getKey();
                        int time = e.getValue();
                        e.setValue(--time);
                        if (time > 0) continue;
                        removes.add(player);
                    }
                    for (UUID player : removes) {
                        this.recentPlayerContributors.remove(player);
                    }
                }
            } else {
                this.endInvasion(true);
            }
        }
        if (!this.field_70170_p.field_72995_K && LOTRMod.canSpawnMobs(this.field_70170_p)) {
            double nearbySearch;
            List nearbyNPCs;
            LOTRInvasions invasionType = this.getInvasionType();
            EntityPlayer closePlayer = this.field_70170_p.func_72977_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, 80.0);
            if (closePlayer != null && this.invasionRemaining > 0 && (nearbyNPCs = this.field_70170_p.func_82733_a(LOTREntityNPC.class, this.field_70121_D.func_72314_b(nearbySearch = INVASION_FOLLOW_RANGE * 2.0, nearbySearch, nearbySearch), this.selectThisInvasionMobs())).size() < 16 && this.field_70146_Z.nextInt(160) == 0) {
                int spawnAttempts = MathHelper.func_76136_a((Random)this.field_70146_Z, (int)1, (int)6);
                spawnAttempts = Math.min(spawnAttempts, this.invasionRemaining);
                boolean spawnedAnyMobs = false;
                for (int l = 0; l < spawnAttempts; ++l) {
                    LOTRInvasions.InvasionSpawnEntry entry = (LOTRInvasions.InvasionSpawnEntry)WeightedRandom.func_76271_a((Random)this.field_70146_Z, invasionType.invasionMobs);
                    Class entityClass = entry.getEntityClass();
                    String entityName = LOTREntities.getStringFromClass(entityClass);
                    LOTREntityNPC npc = (LOTREntityNPC)EntityList.func_75620_a((String)entityName, (World)this.field_70170_p);
                    if (!this.attemptSpawnMob(npc)) continue;
                    spawnedAnyMobs = true;
                }
                if (spawnedAnyMobs) {
                    this.successiveFailedSpawns = 0;
                    this.playHorn();
                } else {
                    ++this.successiveFailedSpawns;
                    if (this.successiveFailedSpawns >= 16) {
                        this.endInvasion(false);
                    }
                }
            }
        } else {
            String particle = this.field_70146_Z.nextBoolean() ? "smoke" : "flame";
            this.field_70170_p.func_72869_a(particle, this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.field_70131_O, this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, 0.0, 0.0, 0.0);
        }
        this.updateWatchedInvasionValues();
    }

    private boolean attemptSpawnMob(LOTREntityNPC npc) {
        for (int at = 0; at < 40; ++at) {
            int i = MathHelper.func_76128_c((double)this.field_70165_t) + MathHelper.func_76136_a((Random)this.field_70146_Z, (int)-6, (int)6);
            int k = MathHelper.func_76128_c((double)this.field_70161_v) + MathHelper.func_76136_a((Random)this.field_70146_Z, (int)-6, (int)6);
            int j = MathHelper.func_76128_c((double)this.field_70163_u) + MathHelper.func_76136_a((Random)this.field_70146_Z, (int)-8, (int)4);
            if (!this.field_70170_p.func_147439_a(i, j - 1, k).isSideSolid((IBlockAccess)this.field_70170_p, i, j - 1, k, ForgeDirection.UP)) continue;
            npc.func_70012_b((double)i + 0.5, j, (double)k + 0.5, this.field_70146_Z.nextFloat() * 360.0f, 0.0f);
            npc.liftSpawnRestrictions = true;
            Event.Result canSpawn = ForgeEventFactory.canEntitySpawn((EntityLiving)npc, (World)this.field_70170_p, (float)((float)npc.field_70165_t), (float)((float)npc.field_70163_u), (float)((float)npc.field_70161_v));
            if (canSpawn != Event.Result.ALLOW && (canSpawn != Event.Result.DEFAULT || !npc.func_70601_bi())) continue;
            npc.liftSpawnRestrictions = false;
            npc.func_110161_a(null);
            npc.isNPCPersistent = false;
            if (this.spawnsPersistent) {
                npc.isNPCPersistent = true;
            }
            npc.setInvasionID(this.getInvasionID());
            npc.killBonusFactions.addAll(this.bonusFactions);
            this.field_70170_p.func_72838_d((Entity)npc);
            IAttributeInstance followRangeAttrib = npc.func_110148_a(SharedMonsterAttributes.field_111265_b);
            double followRange = followRangeAttrib.func_111125_b();
            followRange = Math.max(followRange, INVASION_FOLLOW_RANGE);
            followRangeAttrib.func_111128_a(followRange);
            return true;
        }
        return false;
    }

    private IEntitySelector selectThisInvasionMobs() {
        return new IEntitySelector(){

            public boolean func_82704_a(Entity entity) {
                if (entity.func_70089_S() && entity instanceof LOTREntityNPC) {
                    LOTREntityNPC npc = (LOTREntityNPC)entity;
                    return npc.isInvasionSpawned() && npc.getInvasionID().equals(LOTREntityInvasionSpawner.this.getInvasionID());
                }
                return false;
            }
        };
    }

    public void addPlayerKill(EntityPlayer entityplayer) {
        --this.invasionRemaining;
        this.timeSincePlayerProgress = 0;
        this.recentPlayerContributors.put(entityplayer.func_110124_au(), 2400);
    }

    public boolean func_70067_L() {
        return true;
    }

    public void func_70108_f(Entity entity) {
    }

    public boolean func_85031_j(Entity entity) {
        if (entity instanceof EntityPlayer) {
            return this.func_70097_a(DamageSource.func_76365_a((EntityPlayer)((EntityPlayer)entity)), 0.0f);
        }
        return false;
    }

    public boolean func_70097_a(DamageSource damagesource, float f) {
        Entity entity = damagesource.func_76346_g();
        if (entity instanceof EntityPlayer && ((EntityPlayer)entity).field_71075_bZ.field_75098_d) {
            if (!this.field_70170_p.field_72995_K) {
                this.endInvasion(false);
            }
            return true;
        }
        return false;
    }

    public boolean func_130002_c(EntityPlayer entityplayer) {
        if (!this.field_70170_p.field_72995_K && entityplayer.field_71075_bZ.field_75098_d && !this.bonusFactions.isEmpty()) {
            ChatComponentText message = new ChatComponentText("");
            for (LOTRFaction f : this.bonusFactions) {
                if (!message.func_150253_a().isEmpty()) {
                    message.func_150257_a((IChatComponent)new ChatComponentText(", "));
                }
                message.func_150257_a((IChatComponent)new ChatComponentTranslation(f.factionName(), new Object[0]));
            }
            entityplayer.func_145747_a((IChatComponent)message);
            return true;
        }
        return false;
    }

    public ItemStack getPickedResult(MovingObjectPosition target) {
        LOTRInvasions invasionType = this.getInvasionType();
        if (invasionType != null) {
            return LOTRItemConquestHorn.createHorn(invasionType);
        }
        return null;
    }

    public static LOTREntityInvasionSpawner locateInvasionNearby(Entity seeker, final UUID id) {
        World world = seeker.field_70170_p;
        double search = 256.0;
        List invasions = world.func_82733_a(LOTREntityInvasionSpawner.class, seeker.field_70121_D.func_72314_b(search, search, search), new IEntitySelector(){

            public boolean func_82704_a(Entity e) {
                return e.func_110124_au().equals(id);
            }
        });
        if (!invasions.isEmpty()) {
            return (LOTREntityInvasionSpawner)((Object)invasions.get(0));
        }
        return null;
    }
}

