/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.entity.ai;

import com.mojang.authlib.GameProfile;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import lotr.common.LOTRMod;
import lotr.common.LOTRReflection;
import lotr.common.block.LOTRBlockCorn;
import lotr.common.block.LOTRBlockGrapevine;
import lotr.common.entity.npc.LOTREntityNPC;
import lotr.common.entity.npc.LOTRFarmhand;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCrops;
import net.minecraft.block.BlockStem;
import net.minecraft.block.IGrowable;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.item.EntityItemFrame;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemDye;
import net.minecraft.item.ItemHoe;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.PathEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.common.util.ForgeDirection;

public class LOTREntityAIFarm
extends EntityAIBase {
    private static final int DEPOSIT_THRESHOLD = 16;
    private static final int COLLECT_THRESHOLD = 16;
    private static final int MIN_CHEST_RANGE = 24;
    private LOTREntityNPC theEntity;
    private LOTRFarmhand theEntityFarmer;
    private World theWorld;
    private double moveSpeed;
    private float farmingEfficiency;
    private Action action = null;
    private ChunkCoordinates actionTarget;
    private ChunkCoordinates pathTarget;
    private int pathingTick;
    private int rePathDelay;
    private boolean harvestingSolidBlock;
    private FakePlayer fakePlayer;

    public LOTREntityAIFarm(LOTRFarmhand npc, double d, float f) {
        this.theEntity = (LOTREntityNPC)((Object)npc);
        this.theEntityFarmer = npc;
        this.theWorld = this.theEntity.field_70170_p;
        this.moveSpeed = d;
        this.func_75248_a(1);
        if (this.theWorld instanceof WorldServer) {
            this.fakePlayer = FakePlayerFactory.get((WorldServer)((WorldServer)this.theWorld), (GameProfile)new GameProfile(null, "LOTRFarming"));
        }
        this.farmingEfficiency = f;
    }

    public boolean func_75250_a() {
        boolean flag = this.shouldFarmhandExecute();
        return flag;
    }

    private boolean shouldFarmhandExecute() {
        if (this.theEntity.hiredNPCInfo.isActive && !this.theEntity.hiredNPCInfo.isGuardMode()) {
            return false;
        }
        this.setAppropriateHomeRange(null);
        if (this.theEntity.func_110175_bO() && !this.theEntity.func_110173_bK()) {
            return false;
        }
        if (this.theEntity.func_70681_au().nextFloat() < this.farmingEfficiency * 0.1f) {
            TargetPair collectTarget;
            TargetPair bonemealTarget;
            TargetPair harvestTarget;
            TargetPair plantTarget;
            TargetPair hoeTarget;
            TargetPair depositTarget;
            if (this.canDoDepositing() && (depositTarget = this.findTarget(Action.DEPOSITING)) != null) {
                this.actionTarget = depositTarget.actionTarget;
                this.pathTarget = depositTarget.pathTarget;
                this.action = Action.DEPOSITING;
                return true;
            }
            if (this.canDoHoeing() && (hoeTarget = this.findTarget(Action.HOEING)) != null) {
                this.actionTarget = hoeTarget.actionTarget;
                this.pathTarget = hoeTarget.pathTarget;
                this.action = Action.HOEING;
                return true;
            }
            if (this.canDoPlanting() && (plantTarget = this.findTarget(Action.PLANTING)) != null) {
                this.actionTarget = plantTarget.actionTarget;
                this.pathTarget = plantTarget.pathTarget;
                this.action = Action.PLANTING;
                return true;
            }
            if (this.canDoHarvesting() && (harvestTarget = this.findTarget(Action.HARVESTING)) != null) {
                this.actionTarget = harvestTarget.actionTarget;
                this.pathTarget = harvestTarget.pathTarget;
                this.action = Action.HARVESTING;
                return true;
            }
            if (this.canDoBonemealing() && (bonemealTarget = this.findTarget(Action.BONEMEALING)) != null) {
                this.actionTarget = bonemealTarget.actionTarget;
                this.pathTarget = bonemealTarget.pathTarget;
                this.action = Action.BONEMEALING;
                return true;
            }
            if (this.canDoCollecting() && (collectTarget = this.findTarget(Action.COLLECTING)) != null) {
                this.actionTarget = collectTarget.actionTarget;
                this.pathTarget = collectTarget.pathTarget;
                this.action = Action.COLLECTING;
                return true;
            }
        }
        return false;
    }

    private boolean isFarmingGrapes() {
        IPlantable seed = this.getSeedsToPlant();
        return seed.getPlant((IBlockAccess)this.theWorld, -1, -1, -1) instanceof LOTRBlockGrapevine;
    }

    private boolean canDoHoeing() {
        return true;
    }

    private boolean canDoPlanting() {
        if (this.theEntity.hiredNPCInfo.isActive) {
            ItemStack invSeeds = this.getInventorySeeds();
            return invSeeds != null && invSeeds.field_77994_a > 1;
        }
        return true;
    }

    private boolean canDoHarvesting() {
        if (this.theEntity.hiredNPCInfo.isActive) {
            return this.getInventorySeeds() != null && this.hasSpaceForCrops() && this.getCropForSeed(this.getSeedsToPlant()) != null;
        }
        return false;
    }

    private boolean canDoDepositing() {
        if (this.theEntity.hiredNPCInfo.isActive) {
            for (int l = 1; l <= 2; ++l) {
                ItemStack itemstack = this.theEntity.hiredNPCInfo.getHiredInventory().func_70301_a(l);
                if (itemstack == null || itemstack.field_77994_a < 16) continue;
                return true;
            }
        }
        return false;
    }

    private boolean canDoBonemealing() {
        if (this.theEntity.hiredNPCInfo.isActive) {
            ItemStack invBmeal = this.getInventoryBonemeal();
            return invBmeal != null;
        }
        return false;
    }

    private boolean canDoCollecting() {
        if (this.theEntity.hiredNPCInfo.isActive) {
            ItemStack seeds = this.getInventorySeeds();
            if (seeds != null && seeds.field_77994_a <= 16) {
                return true;
            }
            ItemStack bonemeal = this.getInventoryBonemeal();
            if (bonemeal == null || bonemeal != null && bonemeal.field_77994_a <= 16) {
                return true;
            }
        }
        return false;
    }

    private ItemStack getInventorySeeds() {
        IPlantable iplantable;
        Item item;
        if (this.theEntity.hiredNPCInfo.getHiredInventory() == null) {
            return null;
        }
        ItemStack itemstack = this.theEntity.hiredNPCInfo.getHiredInventory().func_70301_a(0);
        if (itemstack != null && (item = itemstack.func_77973_b()) instanceof IPlantable && (iplantable = (IPlantable)item).getPlantType((IBlockAccess)this.theWorld, -1, -1, -1) == EnumPlantType.Crop) {
            return itemstack;
        }
        return null;
    }

    private IPlantable getSeedsToPlant() {
        ItemStack invSeeds;
        if (this.theEntity.hiredNPCInfo.isActive && (invSeeds = this.getInventorySeeds()) != null) {
            return (IPlantable)invSeeds.func_77973_b();
        }
        return this.theEntityFarmer.getUnhiredSeeds();
    }

    private boolean hasSpaceForCrops() {
        if (this.theEntity.hiredNPCInfo.getHiredInventory() == null) {
            return false;
        }
        for (int l = 1; l <= 2; ++l) {
            ItemStack itemstack = this.theEntity.hiredNPCInfo.getHiredInventory().func_70301_a(l);
            if (itemstack != null && (itemstack.field_77994_a >= itemstack.func_77976_d() || !itemstack.func_77969_a(this.getCropForSeed(this.getSeedsToPlant())))) continue;
            return true;
        }
        return false;
    }

    private ItemStack getInventoryBonemeal() {
        if (this.theEntity.hiredNPCInfo.getHiredInventory() == null) {
            return null;
        }
        ItemStack itemstack = this.theEntity.hiredNPCInfo.getHiredInventory().func_70301_a(3);
        if (itemstack != null && itemstack.func_77973_b() == Items.field_151100_aR && itemstack.func_77960_j() == 15) {
            return itemstack;
        }
        return null;
    }

    private ItemStack getCropForSeed(IPlantable seed) {
        Block block = seed.getPlant((IBlockAccess)this.theWorld, -1, -1, -1);
        if (block instanceof BlockCrops) {
            return new ItemStack(LOTRReflection.getCropItem((BlockCrops)block));
        }
        if (block instanceof BlockStem) {
            return new ItemStack(LOTRReflection.getStemFruitBlock((BlockStem)block).func_149650_a(0, this.theWorld.field_73012_v, 0), 1, 0);
        }
        if (block instanceof LOTRBlockCorn) {
            return new ItemStack(LOTRMod.corn);
        }
        if (block instanceof LOTRBlockGrapevine) {
            return new ItemStack(((LOTRBlockGrapevine)block).getGrapeItem());
        }
        return null;
    }

    public void func_75249_e() {
        super.func_75249_e();
        this.setAppropriateHomeRange(this.action);
    }

    private void setAppropriateHomeRange(Action targetAction) {
        if (this.theEntity.hiredNPCInfo.isActive) {
            int hRange = this.theEntity.hiredNPCInfo.getGuardRange();
            ChunkCoordinates home = this.theEntity.func_110172_bL();
            if (targetAction != null && (targetAction == Action.DEPOSITING || targetAction == Action.COLLECTING) && hRange < 24) {
                hRange = 24;
            }
            this.theEntity.func_110171_b(home.field_71574_a, home.field_71572_b, home.field_71573_c, hRange);
        }
    }

    public boolean func_75253_b() {
        if (this.theEntity.hiredNPCInfo.isActive && !this.theEntity.hiredNPCInfo.isGuardMode()) {
            return false;
        }
        if (this.theEntity.func_70661_as().func_75500_f()) {
            return false;
        }
        if (this.pathingTick < 200) {
            if (this.action == Action.HOEING) {
                return this.canDoHoeing() && this.isSuitableForHoeing(this.actionTarget);
            }
            if (this.action == Action.PLANTING) {
                return this.canDoPlanting() && this.isSuitableForPlanting(this.actionTarget);
            }
            if (this.action == Action.HARVESTING) {
                return this.canDoHarvesting() && this.isSuitableForHarvesting(this.actionTarget);
            }
            if (this.action == Action.DEPOSITING) {
                return this.canDoDepositing() && this.isSuitableForDepositing(this.actionTarget);
            }
            if (this.action == Action.BONEMEALING) {
                return this.canDoBonemealing() && this.isSuitableForBonemealing(this.actionTarget);
            }
            if (this.action == Action.COLLECTING) {
                return this.canDoCollecting() && this.isSuitableForCollecting(this.actionTarget);
            }
        }
        return false;
    }

    public void func_75251_c() {
        this.action = null;
        this.setAppropriateHomeRange(this.action);
        this.actionTarget = null;
        this.pathTarget = null;
        this.pathingTick = 0;
        this.rePathDelay = 0;
        this.harvestingSolidBlock = false;
    }

    /*
     * WARNING - void declaration
     */
    public void func_75246_d() {
        boolean canCollect;
        boolean canDoAction = false;
        double distSq = this.theEntity.func_70092_e((double)this.pathTarget.field_71574_a + 0.5, this.pathTarget.field_71572_b, (double)this.pathTarget.field_71573_c + 0.5);
        if (this.action == Action.HOEING || this.action == Action.PLANTING) {
            int i = MathHelper.func_76128_c((double)this.theEntity.field_70165_t);
            int j = MathHelper.func_76128_c((double)this.theEntity.field_70121_D.field_72338_b);
            int k = MathHelper.func_76128_c((double)this.theEntity.field_70161_v);
            canDoAction = i == this.pathTarget.field_71574_a && j == this.pathTarget.field_71572_b && k == this.pathTarget.field_71573_c;
        } else {
            boolean bl = canDoAction = distSq < 9.0;
        }
        if (!canDoAction) {
            this.theEntity.func_70671_ap().func_75650_a((double)this.actionTarget.field_71574_a + 0.5, (double)this.actionTarget.field_71572_b + 0.5, (double)this.actionTarget.field_71573_c + 0.5, 10.0f, (float)this.theEntity.func_70646_bf());
            --this.rePathDelay;
            if (this.rePathDelay <= 0) {
                this.rePathDelay = 10;
                this.theEntity.func_70661_as().func_75492_a((double)this.pathTarget.field_71574_a + 0.5, (double)this.pathTarget.field_71572_b, (double)this.pathTarget.field_71573_c + 0.5, this.moveSpeed);
            }
            ++this.pathingTick;
        } else if (this.action == Action.HOEING) {
            boolean canHoe = this.isSuitableForHoeing(this.actionTarget);
            if (canHoe) {
                this.theEntity.func_71038_i();
                ItemStack proxyHoe = new ItemStack(Items.field_151019_K);
                int hoeRange = 1;
                for (int i1 = -hoeRange; i1 <= hoeRange; ++i1) {
                    for (int k1 = -hoeRange; k1 <= hoeRange; ++k1) {
                        boolean bl;
                        if (Math.abs(i1) + Math.abs(k1) > hoeRange) continue;
                        int x = this.actionTarget.field_71574_a + i1;
                        int z = this.actionTarget.field_71573_c + k1;
                        int y = this.actionTarget.field_71572_b;
                        boolean bl2 = bl = i1 == 0 && k1 == 0;
                        if (!bl && !this.isSuitableForHoeing(x, y, z)) continue;
                        if (this.isReplaceable(x, y + 1, z)) {
                            this.theWorld.func_147468_f(x, y + 1, z);
                        }
                        proxyHoe.func_77943_a((EntityPlayer)this.fakePlayer, this.theWorld, x, y, z, 1, 0.5f, 0.5f, 0.5f);
                    }
                }
            }
        } else if (this.action == Action.PLANTING) {
            boolean canPlant = this.isSuitableForPlanting(this.actionTarget.field_71574_a, this.actionTarget.field_71572_b, this.actionTarget.field_71573_c);
            if (canPlant) {
                this.theEntity.func_71038_i();
                IPlantable seed = this.getSeedsToPlant();
                Block plant = seed.getPlant((IBlockAccess)this.theWorld, this.actionTarget.field_71574_a, this.actionTarget.field_71572_b, this.actionTarget.field_71573_c);
                int meta = seed.getPlantMetadata((IBlockAccess)this.theWorld, this.actionTarget.field_71574_a, this.actionTarget.field_71572_b, this.actionTarget.field_71573_c);
                this.theWorld.func_147465_d(this.actionTarget.field_71574_a, this.actionTarget.field_71572_b, this.actionTarget.field_71573_c, plant, meta, 3);
                if (this.theEntity.hiredNPCInfo.isActive) {
                    this.theEntity.hiredNPCInfo.getHiredInventory().func_70298_a(0, 1);
                }
            }
        } else if (this.action == Action.HARVESTING) {
            boolean canHarvest = this.isSuitableForHarvesting(this.actionTarget.field_71574_a, this.actionTarget.field_71572_b, this.actionTarget.field_71573_c);
            if (canHarvest) {
                int meta;
                this.theEntity.func_71038_i();
                Block block = this.theWorld.func_147439_a(this.actionTarget.field_71574_a, this.actionTarget.field_71572_b, this.actionTarget.field_71573_c);
                ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
                if (block instanceof LOTRBlockCorn) {
                    int x = this.actionTarget.field_71574_a;
                    int z = this.actionTarget.field_71573_c;
                    for (int j1 = 0; j1 <= LOTRBlockCorn.MAX_GROW_HEIGHT - 1; ++j1) {
                        int y = this.actionTarget.field_71572_b + j1;
                        if (this.theWorld.func_147439_a(x, y, z) != block || !LOTRBlockCorn.hasCorn(this.theWorld, x, y, z)) continue;
                        int meta2 = this.theWorld.func_72805_g(x, y, z);
                        drops.addAll(((LOTRBlockCorn)block).getCornDrops(this.theWorld, x, y, z, meta2));
                        LOTRBlockCorn.setHasCorn(this.theWorld, x, y, z, false);
                    }
                } else if (block instanceof LOTRBlockGrapevine) {
                    meta = this.theWorld.func_72805_g(this.actionTarget.field_71574_a, this.actionTarget.field_71572_b, this.actionTarget.field_71573_c);
                    drops.addAll(block.getDrops(this.theWorld, this.actionTarget.field_71574_a, this.actionTarget.field_71572_b, this.actionTarget.field_71573_c, meta, 0));
                    block.removedByPlayer(this.theWorld, (EntityPlayer)this.fakePlayer, this.actionTarget.field_71574_a, this.actionTarget.field_71572_b, this.actionTarget.field_71573_c, true);
                } else {
                    meta = this.theWorld.func_72805_g(this.actionTarget.field_71574_a, this.actionTarget.field_71572_b, this.actionTarget.field_71573_c);
                    drops.addAll(block.getDrops(this.theWorld, this.actionTarget.field_71574_a, this.actionTarget.field_71572_b, this.actionTarget.field_71573_c, meta, 0));
                    this.theWorld.func_147468_f(this.actionTarget.field_71574_a, this.actionTarget.field_71572_b, this.actionTarget.field_71573_c);
                }
                Block.SoundType cropSound = block.field_149762_H;
                this.theWorld.func_72908_a((double)this.actionTarget.field_71574_a + 0.5, (double)this.actionTarget.field_71572_b + 0.5, (double)this.actionTarget.field_71573_c + 0.5, cropSound.func_150495_a(), (cropSound.func_150497_c() + 1.0f) / 2.0f, cropSound.func_150494_d() * 0.8f);
                ItemStack seedItem = this.theEntity.hiredNPCInfo.getHiredInventory().func_70301_a(0);
                ItemStack cropItem = this.getCropForSeed(this.getSeedsToPlant());
                boolean addedOneCropSeed = false;
                block3: for (Object e : drops) {
                    ItemStack itemstack;
                    ItemStack drop = (ItemStack)e;
                    if (drop.func_77969_a(cropItem)) {
                        if (drop.func_77969_a(seedItem) && !addedOneCropSeed) {
                            addedOneCropSeed = true;
                            ItemStack itemstack2 = this.theEntity.hiredNPCInfo.getHiredInventory().func_70301_a(0);
                            if (itemstack2.field_77994_a + drop.field_77994_a <= itemstack2.func_77976_d()) {
                                ++itemstack2.field_77994_a;
                                this.theEntity.hiredNPCInfo.getHiredInventory().func_70299_a(0, itemstack2);
                                continue;
                            }
                        }
                        for (int l = 1; l <= 2; ++l) {
                            ItemStack itemstack3 = this.theEntity.hiredNPCInfo.getHiredInventory().func_70301_a(l);
                            if (itemstack3 == null) {
                                this.theEntity.hiredNPCInfo.getHiredInventory().func_70299_a(l, drop);
                                continue block3;
                            }
                            if (itemstack3.field_77994_a + drop.field_77994_a > itemstack3.func_77976_d() || !itemstack3.func_77969_a(cropItem)) continue;
                            ++itemstack3.field_77994_a;
                            this.theEntity.hiredNPCInfo.getHiredInventory().func_70299_a(l, itemstack3);
                            continue block3;
                        }
                        continue;
                    }
                    if (!drop.func_77969_a(seedItem) || itemstack.field_77994_a + drop.field_77994_a > (itemstack = this.theEntity.hiredNPCInfo.getHiredInventory().func_70301_a(0)).func_77976_d()) continue;
                    ++itemstack.field_77994_a;
                    this.theEntity.hiredNPCInfo.getHiredInventory().func_70299_a(0, itemstack);
                }
            }
        } else if (this.action == Action.DEPOSITING) {
            boolean canDeposit = this.isSuitableForDepositing(this.actionTarget.field_71574_a, this.actionTarget.field_71572_b, this.actionTarget.field_71573_c);
            if (canDeposit) {
                this.theEntity.func_71038_i();
                TileEntity te = this.theWorld.func_147438_o(this.actionTarget.field_71574_a, this.actionTarget.field_71572_b, this.actionTarget.field_71573_c);
                if (te instanceof TileEntityChest) {
                    TileEntityChest chest = (TileEntityChest)te;
                    block5: for (int l = 1; l <= 2; ++l) {
                        ItemStack itemstack = this.theEntity.hiredNPCInfo.getHiredInventory().func_70301_a(l);
                        if (itemstack == null) continue;
                        for (int slot = 0; slot < chest.func_70302_i_(); ++slot) {
                            ItemStack chestItem = chest.func_70301_a(slot);
                            if (chestItem != null && (!chestItem.func_77969_a(itemstack) || !ItemStack.func_77970_a((ItemStack)chestItem, (ItemStack)itemstack) || chestItem.field_77994_a >= chestItem.func_77976_d())) continue;
                            if (chestItem == null) {
                                chestItem = itemstack.func_77946_l();
                                chestItem.field_77994_a = 0;
                            }
                            while (itemstack.field_77994_a > 0 && chestItem.field_77994_a < chestItem.func_77976_d()) {
                                ++chestItem.field_77994_a;
                                --itemstack.field_77994_a;
                            }
                            chest.func_70299_a(slot, chestItem);
                            if (itemstack.field_77994_a > 0) continue;
                            this.theEntity.hiredNPCInfo.getHiredInventory().func_70299_a(l, null);
                            continue block5;
                        }
                    }
                    this.theWorld.func_72908_a((double)this.actionTarget.field_71574_a + 0.5, (double)this.actionTarget.field_71572_b + 0.5, (double)this.actionTarget.field_71573_c + 0.5, "random.chestclosed", 0.5f, this.theWorld.field_73012_v.nextFloat() * 0.1f + 0.9f);
                }
            }
        } else if (this.action == Action.BONEMEALING) {
            boolean canBonemeal = this.isSuitableForBonemealing(this.actionTarget.field_71574_a, this.actionTarget.field_71572_b, this.actionTarget.field_71573_c);
            if (canBonemeal) {
                this.theEntity.func_71038_i();
                ItemStack bonemeal = this.getInventoryBonemeal();
                if (ItemDye.applyBonemeal((ItemStack)this.getInventoryBonemeal(), (World)this.theWorld, (int)this.actionTarget.field_71574_a, (int)this.actionTarget.field_71572_b, (int)this.actionTarget.field_71573_c, (EntityPlayer)this.fakePlayer)) {
                    this.theWorld.func_72926_e(2005, this.actionTarget.field_71574_a, this.actionTarget.field_71572_b, this.actionTarget.field_71573_c, 0);
                }
                if (bonemeal.field_77994_a <= 0) {
                    bonemeal = null;
                }
                this.theEntity.hiredNPCInfo.getHiredInventory().func_70299_a(3, bonemeal);
            }
        } else if (this.action == Action.COLLECTING && (canCollect = this.isSuitableForCollecting(this.actionTarget.field_71574_a, this.actionTarget.field_71572_b, this.actionTarget.field_71573_c))) {
            this.theEntity.func_71038_i();
            TileEntity te = this.theWorld.func_147438_o(this.actionTarget.field_71574_a, this.actionTarget.field_71572_b, this.actionTarget.field_71573_c);
            if (te instanceof TileEntityChest) {
                int[] invSlots;
                TileEntityChest chest = (TileEntityChest)te;
                block8: for (int l : invSlots = new int[]{0, 3}) {
                    void var12_45;
                    ItemStack itemStack = this.theEntity.hiredNPCInfo.getHiredInventory().func_70301_a(l);
                    if (itemStack == null && l == 3) {
                        ItemStack itemStack2 = new ItemStack(Items.field_151100_aR, 0, 15);
                    }
                    if (var12_45 == null) continue;
                    for (int slot = 0; slot < chest.func_70302_i_(); ++slot) {
                        void var12_42;
                        ItemStack chestItem = chest.func_70301_a(slot);
                        if (chestItem == null || !chestItem.func_77969_a((ItemStack)var12_42) || !ItemStack.func_77970_a((ItemStack)chestItem, (ItemStack)var12_42) || chestItem.field_77994_a <= 0) continue;
                        while (var12_42.field_77994_a < var12_42.func_77976_d() && chestItem.field_77994_a > 0) {
                            --chestItem.field_77994_a;
                            ++var12_42.field_77994_a;
                        }
                        if (var12_42.field_77994_a <= 0) {
                            Object var12_46 = null;
                        }
                        if (chestItem.field_77994_a <= 0) {
                            chestItem = null;
                        }
                        this.theEntity.hiredNPCInfo.getHiredInventory().func_70299_a(l, (ItemStack)var12_42);
                        chest.func_70299_a(slot, chestItem);
                        if (var12_42.field_77994_a >= var12_42.func_77976_d()) continue block8;
                    }
                }
                this.theWorld.func_72908_a((double)this.actionTarget.field_71574_a + 0.5, (double)this.actionTarget.field_71572_b + 0.5, (double)this.actionTarget.field_71573_c + 0.5, "random.chestopen", 0.5f, this.theWorld.field_73012_v.nextFloat() * 0.1f + 0.9f);
            }
        }
    }

    private TargetPair findTarget(Action targetAction) {
        this.setAppropriateHomeRange(targetAction);
        Random rand = this.theEntity.func_70681_au();
        boolean isChestAction = targetAction == Action.DEPOSITING || targetAction == Action.COLLECTING;
        List<Object> chests = new ArrayList();
        if (isChestAction) {
            chests = this.gatherNearbyChests();
        }
        for (int l = 0; l < 32; ++l) {
            int i = 0;
            int j = 0;
            int k = 0;
            boolean suitable = false;
            if (isChestAction) {
                if (!chests.isEmpty()) {
                    TileEntityChest chest = (TileEntityChest)chests.get(rand.nextInt(chests.size()));
                    i = chest.field_145851_c;
                    j = chest.field_145848_d;
                    k = chest.field_145849_e;
                    if (targetAction == Action.DEPOSITING) {
                        suitable = this.isSuitableForDepositing(i, j, k);
                    } else if (targetAction == Action.COLLECTING) {
                        suitable = this.isSuitableForCollecting(i, j, k);
                    }
                } else {
                    suitable = false;
                }
            } else {
                i = MathHelper.func_76128_c((double)this.theEntity.field_70165_t) + MathHelper.func_76136_a((Random)rand, (int)-8, (int)8);
                j = MathHelper.func_76128_c((double)this.theEntity.field_70121_D.field_72338_b) + MathHelper.func_76136_a((Random)rand, (int)-4, (int)4);
                k = MathHelper.func_76128_c((double)this.theEntity.field_70161_v) + MathHelper.func_76136_a((Random)rand, (int)-8, (int)8);
                if (targetAction == Action.HOEING) {
                    suitable = this.isSuitableForHoeing(i, j, k);
                } else if (targetAction == Action.PLANTING) {
                    suitable = this.isSuitableForPlanting(i, j, k);
                } else if (targetAction == Action.HARVESTING) {
                    suitable = this.isSuitableForHarvesting(i, j, k);
                } else if (targetAction == Action.BONEMEALING) {
                    suitable = this.isSuitableForBonemealing(i, j, k);
                }
            }
            if (!suitable || !this.theEntity.func_110176_b(i, j, k)) continue;
            ChunkCoordinates target = new ChunkCoordinates(i, j, k);
            ChunkCoordinates path = this.getPathTarget(i, j, k, targetAction);
            PathEntity pathCheck = this.theEntity.func_70661_as().func_75488_a((double)path.field_71574_a, (double)path.field_71572_b, (double)path.field_71573_c);
            if (pathCheck == null) continue;
            return new TargetPair(target, path);
        }
        return null;
    }

    private List<TileEntityChest> gatherNearbyChests() {
        int x = MathHelper.func_76128_c((double)this.theEntity.field_70165_t);
        int y = MathHelper.func_76128_c((double)this.theEntity.field_70121_D.field_72338_b);
        int z = MathHelper.func_76128_c((double)this.theEntity.field_70161_v);
        int searchRange = (int)this.theEntity.func_110174_bM();
        int chunkX = x >> 4;
        int chunkZ = z >> 4;
        int chunkRange = (searchRange >> 4) + 1;
        ArrayList<TileEntityChest> nearbyChests = new ArrayList<TileEntityChest>();
        for (int i = -chunkRange; i <= chunkRange; ++i) {
            for (int k = -chunkRange; k <= chunkRange; ++k) {
                int nearChunkX = chunkX + i;
                int nearChunkZ = chunkZ + k;
                if (!this.theWorld.func_72863_F().func_73149_a(nearChunkX, nearChunkZ)) continue;
                Chunk chunk = this.theWorld.func_72964_e(nearChunkX, nearChunkZ);
                for (Object obj : chunk.field_150816_i.values()) {
                    TileEntity te = (TileEntity)obj;
                    if (!(te instanceof TileEntityChest) || te.func_145837_r()) continue;
                    TileEntityChest chest = (TileEntityChest)te;
                    if (!this.theEntity.func_110176_b(chest.field_145851_c, chest.field_145848_d, chest.field_145849_e)) continue;
                    nearbyChests.add(chest);
                }
            }
        }
        return nearbyChests;
    }

    private ChunkCoordinates getPathTarget(int i, int j, int k, Action targetAction) {
        if (targetAction == Action.HOEING) {
            if (this.isReplaceable(i, j + 1, k)) {
                return new ChunkCoordinates(i, j + 1, k);
            }
            return this.getAdjacentSolidOpenWalkTarget(i, j + 1, k);
        }
        if (targetAction == Action.PLANTING || targetAction == Action.HARVESTING || targetAction == Action.BONEMEALING) {
            if (this.harvestingSolidBlock) {
                return new ChunkCoordinates(i, j + 1, k);
            }
            if (this.isFarmingGrapes()) {
                int groundY = j;
                for (int j1 = 1; j1 <= 2; ++j1) {
                    if (this.theWorld.func_147439_a(i, j - j1 - 1, k) instanceof LOTRBlockGrapevine) continue;
                    groundY = j - j1 - 1;
                    break;
                }
                return this.getAdjacentSolidOpenWalkTarget(i, groundY + 1, k);
            }
            return new ChunkCoordinates(i, j, k);
        }
        if (targetAction == Action.DEPOSITING || targetAction == Action.COLLECTING) {
            return this.getAdjacentSolidOpenWalkTarget(i, j, k);
        }
        return new ChunkCoordinates(i, j, k);
    }

    private boolean isSolidOpenWalkTarget(int i, int j, int k) {
        Block below = this.theWorld.func_147439_a(i, j - 1, k);
        if (below.func_149662_c() || below.canSustainPlant((IBlockAccess)this.theWorld, i, j - 1, k, ForgeDirection.UP, (IPlantable)Blocks.field_150464_aj)) {
            ArrayList bounds = new ArrayList();
            AxisAlignedBB aabb = AxisAlignedBB.func_72330_a((double)i, (double)j, (double)k, (double)(i + 1), (double)(j + 2), (double)(k + 1));
            for (int j1 = j; j1 <= j + 1; ++j1) {
                this.theWorld.func_147439_a(i, j1, k).func_149743_a(this.theWorld, i, j1, k, aabb, bounds, (Entity)this.theEntity);
            }
            if (bounds.isEmpty()) {
                return this.theEntity.func_70661_as().func_75488_a((double)i, (double)j, (double)k) != null;
            }
        }
        return false;
    }

    private ChunkCoordinates getAdjacentSolidOpenWalkTarget(int i, int j, int k) {
        ArrayList<ChunkCoordinates> possibleCoords = new ArrayList<ChunkCoordinates>();
        for (int i1 = -1; i1 <= 1; ++i1) {
            for (int k1 = -1; k1 <= 1; ++k1) {
                int i2 = i + i1;
                int k2 = k + k1;
                for (int j1 = 1; j1 >= -1; --j1) {
                    int j2 = j + j1;
                    if (!this.isSolidOpenWalkTarget(i2, j2, k2)) continue;
                    possibleCoords.add(new ChunkCoordinates(i2, j2, k2));
                }
            }
        }
        if (!possibleCoords.isEmpty()) {
            return (ChunkCoordinates)possibleCoords.get(0);
        }
        return new ChunkCoordinates(i, j, k);
    }

    private boolean isSuitableForHoeing(ChunkCoordinates pos) {
        return this.isSuitableForHoeing(pos.field_71574_a, pos.field_71572_b, pos.field_71573_c);
    }

    private boolean isSuitableForHoeing(int i, int j, int k) {
        this.harvestingSolidBlock = false;
        Block block = this.theWorld.func_147439_a(i, j, k);
        boolean isGrassDirt = block.canSustainPlant((IBlockAccess)this.theWorld, i, j, k, ForgeDirection.UP, (IPlantable)Blocks.field_150329_H);
        boolean isFarmland = block.canSustainPlant((IBlockAccess)this.theWorld, i, j, k, ForgeDirection.UP, (IPlantable)Blocks.field_150464_aj);
        if (isGrassDirt && !isFarmland && (this.isReplaceable(i, j + 1, k) || this.theWorld.func_147439_a(i, j + 1, k) == LOTRMod.grapevine)) {
            Block below = this.theWorld.func_147439_a(i, j - 1, k);
            if (below == Blocks.field_150354_m) {
                return false;
            }
            boolean waterNearby = false;
            int range = 4;
            block0: for (int i1 = i - range; i1 <= i + range; ++i1) {
                for (int k1 = k - range; k1 <= k + range; ++k1) {
                    if (this.theWorld.func_147439_a(i1, j, k1).func_149688_o() != Material.field_151586_h) continue;
                    waterNearby = true;
                    break block0;
                }
            }
            return waterNearby;
        }
        return false;
    }

    private boolean isSuitableForPlanting(ChunkCoordinates pos) {
        return this.isSuitableForPlanting(pos.field_71574_a, pos.field_71572_b, pos.field_71573_c);
    }

    private boolean isSuitableForPlanting(int i, int j, int k) {
        this.harvestingSolidBlock = false;
        if (this.isFarmingGrapes()) {
            return this.theWorld.func_147439_a(i, j, k) == LOTRMod.grapevine && LOTRBlockGrapevine.canPlantGrapesAt(this.theWorld, i, j, k, this.getSeedsToPlant());
        }
        return this.theWorld.func_147439_a(i, j - 1, k).isFertile(this.theWorld, i, j - 1, k) && this.isReplaceable(i, j, k);
    }

    private boolean isSuitableForHarvesting(ChunkCoordinates pos) {
        return this.isSuitableForHarvesting(pos.field_71574_a, pos.field_71572_b, pos.field_71573_c);
    }

    private boolean isSuitableForHarvesting(int i, int j, int k) {
        this.harvestingSolidBlock = false;
        IPlantable seed = this.getSeedsToPlant();
        Block plantBlock = seed.getPlant((IBlockAccess)this.theWorld, i, j, k);
        if (plantBlock instanceof BlockCrops) {
            this.harvestingSolidBlock = false;
            return this.theWorld.func_147439_a(i, j, k) == plantBlock && this.theWorld.func_72805_g(i, j, k) >= 7;
        }
        if (plantBlock instanceof BlockStem) {
            this.harvestingSolidBlock = true;
            return this.theWorld.func_147439_a(i, j, k) == LOTRReflection.getStemFruitBlock((BlockStem)plantBlock);
        }
        if (plantBlock instanceof LOTRBlockCorn) {
            this.harvestingSolidBlock = false;
            if (this.theWorld.func_147439_a(i, j, k) == plantBlock) {
                for (int j1 = 0; j1 <= LOTRBlockCorn.MAX_GROW_HEIGHT - 1; ++j1) {
                    int j2 = j + j1;
                    if (this.theWorld.func_147439_a(i, j2, k) != plantBlock || !LOTRBlockCorn.hasCorn(this.theWorld, i, j2, k)) continue;
                    return true;
                }
            }
        } else if (plantBlock instanceof LOTRBlockGrapevine) {
            this.harvestingSolidBlock = false;
            return this.theWorld.func_147439_a(i, j, k) == seed.getPlant((IBlockAccess)this.theWorld, i, j, k) && this.theWorld.func_72805_g(i, j, k) >= 7;
        }
        return false;
    }

    private boolean isSuitableForDepositing(ChunkCoordinates pos) {
        return this.isSuitableForDepositing(pos.field_71574_a, pos.field_71572_b, pos.field_71573_c);
    }

    private boolean isSuitableForDepositing(int i, int j, int k) {
        this.harvestingSolidBlock = false;
        TileEntityChest chest = this.getSuitableChest(i, j, k);
        if (chest != null) {
            for (int l = 1; l <= 2; ++l) {
                ItemStack depositItem = this.theEntity.hiredNPCInfo.getHiredInventory().func_70301_a(l);
                if (depositItem == null) continue;
                for (int slot = 0; slot < chest.func_70302_i_(); ++slot) {
                    ItemStack chestItem = chest.func_70301_a(slot);
                    if (chestItem != null && (!chestItem.func_77969_a(depositItem) || !ItemStack.func_77970_a((ItemStack)chestItem, (ItemStack)depositItem) || chestItem.field_77994_a >= chestItem.func_77976_d())) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private boolean isSuitableForBonemealing(ChunkCoordinates pos) {
        return this.isSuitableForBonemealing(pos.field_71574_a, pos.field_71572_b, pos.field_71573_c);
    }

    private boolean isSuitableForBonemealing(int i, int j, int k) {
        IGrowable growableBlock;
        this.harvestingSolidBlock = false;
        IPlantable seed = this.getSeedsToPlant();
        Block plantBlock = seed.getPlant((IBlockAccess)this.theWorld, i, j, k);
        if (plantBlock instanceof IGrowable && this.theWorld.func_147439_a(i, j, k) == plantBlock && (growableBlock = (IGrowable)plantBlock).func_149851_a(this.theWorld, i, j, k, this.theWorld.field_72995_K)) {
            this.harvestingSolidBlock = plantBlock.func_149662_c();
            return true;
        }
        return false;
    }

    private boolean isSuitableForCollecting(ChunkCoordinates pos) {
        return this.isSuitableForCollecting(pos.field_71574_a, pos.field_71572_b, pos.field_71573_c);
    }

    private boolean isSuitableForCollecting(int i, int j, int k) {
        this.harvestingSolidBlock = false;
        TileEntityChest chest = this.getSuitableChest(i, j, k);
        if (chest != null) {
            int[] invSlots;
            for (int l : invSlots = new int[]{0, 3}) {
                ItemStack collectMatch = this.theEntity.hiredNPCInfo.getHiredInventory().func_70301_a(l);
                if (collectMatch == null && l == 3) {
                    collectMatch = new ItemStack(Items.field_151100_aR, 0, 15);
                }
                if (collectMatch == null || collectMatch.field_77994_a > 16) continue;
                for (int slot = 0; slot < chest.func_70302_i_(); ++slot) {
                    ItemStack chestItem = chest.func_70301_a(slot);
                    if (chestItem == null || !chestItem.func_77969_a(collectMatch) || !ItemStack.func_77970_a((ItemStack)chestItem, (ItemStack)collectMatch) || chestItem.field_77994_a <= 0) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private TileEntityChest getSuitableChest(int i, int j, int k) {
        TileEntity te;
        Block block = this.theWorld.func_147439_a(i, j, k);
        int meta = this.theWorld.func_72805_g(i, j, k);
        TileEntityChest suitableChest = null;
        if (block.hasTileEntity(meta) && (te = this.theWorld.func_147438_o(i, j, k)) instanceof TileEntityChest) {
            TileEntityChest chest = (TileEntityChest)te;
            boolean flag = false;
            if (this.isFarmhandMarked(chest)) {
                flag = true;
            } else if (chest.field_145991_k != null && this.isFarmhandMarked(chest.field_145991_k)) {
                flag = true;
            } else if (chest.field_145990_j != null && this.isFarmhandMarked(chest.field_145990_j)) {
                flag = true;
            } else if (chest.field_145992_i != null && this.isFarmhandMarked(chest.field_145992_i)) {
                flag = true;
            } else if (chest.field_145988_l != null && this.isFarmhandMarked(chest.field_145988_l)) {
                flag = true;
            }
            if (flag) {
                suitableChest = chest;
            }
        }
        return suitableChest;
    }

    private boolean isFarmhandMarked(TileEntityChest chest) {
        int i = chest.field_145851_c;
        int j = chest.field_145848_d;
        int k = chest.field_145849_e;
        AxisAlignedBB chestBB = AxisAlignedBB.func_72330_a((double)i, (double)j, (double)k, (double)(i + 1), (double)(j + 1), (double)(k + 1));
        List entities = this.theWorld.func_72872_a(EntityItemFrame.class, chestBB.func_72314_b(2.0, 2.0, 2.0));
        for (Object obj : entities) {
            ItemStack frameItem;
            EntityItemFrame frame = (EntityItemFrame)obj;
            if (frame.field_146063_b != i || frame.field_146064_c != j || frame.field_146062_d != k || (frameItem = frame.func_82335_i()) == null || !(frameItem.func_77973_b() instanceof ItemHoe)) continue;
            return true;
        }
        return false;
    }

    private boolean isReplaceable(int i, int j, int k) {
        Block block = this.theWorld.func_147439_a(i, j, k);
        return !block.func_149688_o().func_76224_d() && block.isReplaceable((IBlockAccess)this.theWorld, i, j, k);
    }

    public static class TargetPair {
        public final ChunkCoordinates actionTarget;
        public final ChunkCoordinates pathTarget;

        public TargetPair(ChunkCoordinates action, ChunkCoordinates path) {
            this.actionTarget = action;
            this.pathTarget = path;
        }
    }

    public static enum Action {
        HOEING,
        PLANTING,
        HARVESTING,
        DEPOSITING,
        BONEMEALING,
        COLLECTING;

    }
}

