/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.entity.ai;

import java.util.ArrayList;
import java.util.List;
import lotr.common.LOTRMod;
import lotr.common.entity.npc.LOTRBannerBearer;
import lotr.common.entity.npc.LOTREntityNPC;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.player.EntityPlayer;

public class LOTREntityAIFollowHiringPlayer
extends EntityAIBase {
    private LOTREntityNPC theNPC;
    private final boolean isBannerBearer;
    private EntityPlayer theHiringPlayer;
    private double moveSpeed;
    private int followTick;
    private float maxNearDist;
    private float minFollowDist;
    private boolean avoidsWater;
    private EntityLiving bannerBearerTarget;

    public LOTREntityAIFollowHiringPlayer(LOTREntityNPC entity) {
        this.theNPC = entity;
        this.isBannerBearer = entity instanceof LOTRBannerBearer;
        double entityMoveSpeed = entity.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e();
        this.moveSpeed = 1.0 / entityMoveSpeed * 0.37;
        this.minFollowDist = 8.0f;
        this.maxNearDist = 6.0f;
        this.func_75248_a(3);
    }

    public boolean func_75250_a() {
        if (!this.theNPC.hiredNPCInfo.isActive) {
            return false;
        }
        EntityPlayer entityplayer = this.theNPC.hiredNPCInfo.getHiringPlayer();
        if (entityplayer == null) {
            return false;
        }
        this.theHiringPlayer = entityplayer;
        if (!this.theNPC.hiredNPCInfo.shouldFollowPlayer()) {
            return false;
        }
        if (this.isBannerBearer) {
            ArrayList<EntityLiving> alliesToFollow = new ArrayList<EntityLiving>();
            List nearbyEntities = this.theNPC.field_70170_p.func_72872_a(EntityLiving.class, this.theNPC.field_70121_D.func_72314_b(16.0, 16.0, 16.0));
            for (int i = 0; i < nearbyEntities.size(); ++i) {
                EntityLiving entity = (EntityLiving)nearbyEntities.get(i);
                if (entity == this.theNPC || LOTRMod.getNPCFaction((Entity)entity) != this.theNPC.getFaction()) continue;
                if (entity instanceof LOTREntityNPC) {
                    LOTREntityNPC npc = (LOTREntityNPC)entity;
                    if (!npc.hiredNPCInfo.isActive || npc.hiredNPCInfo.getHiringPlayer() != entityplayer) continue;
                }
                alliesToFollow.add(entity);
            }
            EntityLiving entityToFollow = null;
            double d = Double.MAX_VALUE;
            for (int i = 0; i < alliesToFollow.size(); ++i) {
                EntityLiving entity = (EntityLiving)alliesToFollow.get(i);
                double dist = this.theNPC.func_70068_e((Entity)entity);
                if (!(dist < d) || !(dist > (double)(this.minFollowDist * this.minFollowDist))) continue;
                d = dist;
                entityToFollow = entity;
            }
            if (entityToFollow != null) {
                this.bannerBearerTarget = entityToFollow;
                return true;
            }
        }
        return !(this.theNPC.func_70068_e((Entity)entityplayer) < (double)(this.minFollowDist * this.minFollowDist));
    }

    public boolean func_75253_b() {
        if (this.theNPC.hiredNPCInfo.isActive && this.theNPC.hiredNPCInfo.getHiringPlayer() != null && this.theNPC.hiredNPCInfo.shouldFollowPlayer() && !this.theNPC.func_70661_as().func_75500_f()) {
            EntityLiving target = this.bannerBearerTarget != null ? this.bannerBearerTarget : this.theHiringPlayer;
            return this.theNPC.func_70068_e((Entity)target) > (double)(this.maxNearDist * this.maxNearDist);
        }
        return false;
    }

    public void func_75249_e() {
        this.followTick = 0;
        this.avoidsWater = this.theNPC.func_70661_as().func_75486_a();
        this.theNPC.func_70661_as().func_75491_a(false);
    }

    public void func_75251_c() {
        this.theHiringPlayer = null;
        this.bannerBearerTarget = null;
        this.theNPC.func_70661_as().func_75499_g();
        this.theNPC.func_70661_as().func_75491_a(this.avoidsWater);
    }

    public void func_75246_d() {
        EntityLiving target = this.bannerBearerTarget != null ? this.bannerBearerTarget : this.theHiringPlayer;
        this.theNPC.func_70671_ap().func_75651_a((Entity)target, 10.0f, (float)this.theNPC.func_70646_bf());
        if (this.theNPC.hiredNPCInfo.shouldFollowPlayer() && --this.followTick <= 0) {
            this.followTick = 10;
            if (!this.theNPC.func_70661_as().func_75497_a((Entity)target, this.moveSpeed) && this.theNPC.hiredNPCInfo.teleportAutomatically) {
                double d = this.theNPC.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111126_e();
                d = Math.max(d, 24.0);
                if (this.theNPC.func_70068_e((Entity)this.theHiringPlayer) > d * d) {
                    this.theNPC.hiredNPCInfo.tryTeleportToHiringPlayer(false);
                }
            }
        }
    }
}

