/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.entity.npc;

import lotr.common.LOTRAchievement;
import lotr.common.LOTRFoods;
import lotr.common.LOTRMod;
import lotr.common.entity.ai.LOTREntityAIAttackOnCollide;
import lotr.common.entity.ai.LOTREntityAIDrink;
import lotr.common.entity.ai.LOTREntityAIEat;
import lotr.common.entity.ai.LOTREntityAIFollowHiringPlayer;
import lotr.common.entity.ai.LOTREntityAIHiredRemainStill;
import lotr.common.entity.animal.LOTREntityHorse;
import lotr.common.entity.npc.LOTREntityMan;
import lotr.common.entity.npc.LOTREntityNPC;
import lotr.common.entity.npc.LOTRNPCMount;
import lotr.common.entity.npc.LOTRNames;
import lotr.common.fac.LOTRFaction;
import lotr.common.quest.LOTRMiniQuest;
import lotr.common.quest.LOTRMiniQuestFactory;
import lotr.common.world.structure.LOTRChestContents;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIOpenDoor;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.EntityAIWatchClosest2;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MathHelper;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;

public class LOTREntityDunedain
extends LOTREntityMan {
    private static ItemStack[] weapons = new ItemStack[]{new ItemStack(LOTRMod.daggerBarrow), new ItemStack(LOTRMod.daggerIron), new ItemStack(LOTRMod.daggerBronze), new ItemStack(Items.field_151036_c), new ItemStack(LOTRMod.axeBronze), new ItemStack(Items.field_151049_t)};

    public LOTREntityDunedain(World world) {
        super(world);
        this.func_70105_a(0.6f, 1.8f);
        this.func_70661_as().func_75491_a(true);
        this.func_70661_as().func_75498_b(true);
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new LOTREntityAIHiredRemainStill(this));
        this.field_70714_bg.func_75776_a(2, this.createDunedainAttackAI());
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new LOTREntityAIFollowHiringPlayer(this));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIOpenDoor((EntityLiving)this, true));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new LOTREntityAIEat(this, this.getDunedainFoods(), 8000));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new LOTREntityAIDrink(this, this.getDunedainDrinks(), 8000));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWatchClosest2((EntityLiving)this, EntityPlayer.class, 8.0f, 0.02f));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWatchClosest2((EntityLiving)this, LOTREntityNPC.class, 5.0f, 0.02f));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityLiving.class, 8.0f, 0.02f));
        this.field_70714_bg.func_75776_a(9, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.addTargetTasks(true);
    }

    protected EntityAIBase createDunedainAttackAI() {
        return new LOTREntityAIAttackOnCollide(this, 1.4, false);
    }

    protected LOTRFoods getDunedainFoods() {
        return LOTRFoods.RANGER;
    }

    protected LOTRFoods getDunedainDrinks() {
        return LOTRFoods.RANGER_DRINK;
    }

    @Override
    public LOTRNPCMount createMountToRide() {
        LOTREntityHorse horse = (LOTREntityHorse)super.createMountToRide();
        horse.setMountArmor(new ItemStack(LOTRMod.horseArmorIron));
        return horse;
    }

    @Override
    public void setupNPCGender() {
        this.familyInfo.setMale(this.field_70146_Z.nextBoolean());
    }

    @Override
    public void setupNPCName() {
        this.familyInfo.setName(LOTRNames.getGondorName(this.field_70146_Z, this.familyInfo.isMale()));
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(20.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.2);
    }

    @Override
    public IEntityLivingData func_110161_a(IEntityLivingData data) {
        data = super.func_110161_a(data);
        int i = this.field_70146_Z.nextInt(weapons.length);
        this.npcItemsInv.setMeleeWeapon(weapons[i].func_77946_l());
        this.npcItemsInv.setIdleItem(null);
        return data;
    }

    @Override
    public LOTRFaction getFaction() {
        return LOTRFaction.RANGER_NORTH;
    }

    @Override
    public String getNPCName() {
        return this.familyInfo.getName();
    }

    @Override
    public String getNPCFormattedName(String npcName, String entityName) {
        if (this.getClass() == LOTREntityDunedain.class) {
            return StatCollector.func_74837_a((String)"entity.lotr.Dunedain.entityName", (Object[])new Object[]{npcName});
        }
        return super.getNPCFormattedName(npcName, entityName);
    }

    @Override
    protected void onAttackModeChange(LOTREntityNPC.AttackMode mode, boolean mounted) {
        if (mode == LOTREntityNPC.AttackMode.IDLE) {
            this.func_70062_b(0, this.npcItemsInv.getIdleItem());
        } else {
            this.func_70062_b(0, this.npcItemsInv.getMeleeWeapon());
        }
    }

    @Override
    protected void func_70628_a(boolean flag, int i) {
        super.func_70628_a(flag, i);
        int bones = this.field_70146_Z.nextInt(2) + this.field_70146_Z.nextInt(i + 1);
        for (int l = 0; l < bones; ++l) {
            this.func_145779_a(Items.field_151103_aS, 1);
        }
        this.dropDunedainItems(flag, i);
    }

    protected void dropDunedainItems(boolean flag, int i) {
        if (this.field_70146_Z.nextInt(6) == 0) {
            this.dropChestContents(LOTRChestContents.RANGER_HOUSE, 1, 2 + i);
        }
    }

    @Override
    protected LOTRAchievement getKillAchievement() {
        return LOTRAchievement.killDunedain;
    }

    @Override
    public float getAlignmentBonus() {
        return 1.0f;
    }

    @Override
    public boolean func_70601_bi() {
        if (super.func_70601_bi()) {
            if (this.liftSpawnRestrictions) {
                return true;
            }
            int i = MathHelper.func_76128_c((double)this.field_70165_t);
            int j = MathHelper.func_76128_c((double)this.field_70121_D.field_72338_b);
            int k = MathHelper.func_76128_c((double)this.field_70161_v);
            Block block = this.field_70170_p.func_147439_a(i, j - 1, k);
            BiomeGenBase biome = this.field_70170_p.func_72807_a(i, k);
            if (j > 62 && (block == biome.field_76752_A || block == Blocks.field_150349_c || block == Blocks.field_150354_m)) {
                return true;
            }
        }
        return false;
    }

    @Override
    public float func_70783_a(int i, int j, int k) {
        float f = 0.0f;
        BiomeGenBase biome = this.field_70170_p.func_72807_a(i, k);
        return f += 20.0f;
    }

    @Override
    public String getSpeechBank(EntityPlayer entityplayer) {
        if (this.isDrunkard()) {
            return "rangerNorth/drunkard/neutral";
        }
        if (this.isFriendlyAndAligned(entityplayer)) {
            return "rangerNorth/man/friendly";
        }
        return "rangerNorth/man/hostile";
    }

    @Override
    public LOTRMiniQuest createMiniQuest() {
        if (this.field_70146_Z.nextInt(8) == 0) {
            return LOTRMiniQuestFactory.RANGER_NORTH_ARNOR_RELIC.createQuest(this);
        }
        return LOTRMiniQuestFactory.RANGER_NORTH.createQuest(this);
    }

    @Override
    public LOTRMiniQuestFactory getBountyHelpSpeechDir() {
        return LOTRMiniQuestFactory.RANGER_NORTH;
    }
}

