/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.entity.npc;

import lotr.common.LOTRAchievement;
import lotr.common.LOTRMod;
import lotr.common.entity.animal.LOTREntityHorse;
import lotr.common.entity.npc.LOTREntityHighElfBase;
import lotr.common.entity.npc.LOTRNPCMount;
import lotr.common.quest.LOTRMiniQuest;
import lotr.common.quest.LOTRMiniQuestFactory;
import lotr.common.world.biome.LOTRBiomeGenLindon;
import lotr.common.world.structure.LOTRChestContents;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;

public class LOTREntityHighElf
extends LOTREntityHighElfBase {
    public LOTREntityHighElf(World world) {
        super(world);
    }

    @Override
    public LOTRNPCMount createMountToRide() {
        LOTREntityHorse horse = (LOTREntityHorse)super.createMountToRide();
        horse.setMountArmor(new ItemStack(LOTRMod.horseArmorHighElven));
        return horse;
    }

    @Override
    public IEntityLivingData func_110161_a(IEntityLivingData data) {
        data = super.func_110161_a(data);
        this.npcItemsInv.setMeleeWeapon(new ItemStack(LOTRMod.daggerHighElven));
        this.npcItemsInv.setRangedWeapon(new ItemStack(LOTRMod.highElvenBow));
        this.npcItemsInv.setIdleItem(null);
        return data;
    }

    @Override
    protected LOTRAchievement getKillAchievement() {
        return LOTRAchievement.killHighElf;
    }

    @Override
    protected void dropElfItems(boolean flag, int i) {
        super.dropElfItems(flag, i);
        if (this.field_70146_Z.nextInt(6) == 0) {
            this.dropChestContents(LOTRChestContents.HIGH_ELVEN_HALL, 1, 1 + i);
        }
    }

    @Override
    public float func_70783_a(int i, int j, int k) {
        float f = 0.0f;
        BiomeGenBase biome = this.field_70170_p.func_72807_a(i, k);
        if (biome instanceof LOTRBiomeGenLindon) {
            f += 20.0f;
        }
        return f;
    }

    @Override
    public String getSpeechBank(EntityPlayer entityplayer) {
        if (this.isFriendlyAndAligned(entityplayer)) {
            if (this.hiredNPCInfo.getHiringPlayer() == entityplayer) {
                return "highElf/elf/hired";
            }
            return "highElf/elf/friendly";
        }
        return "highElf/elf/hostile";
    }

    @Override
    public LOTRMiniQuest createMiniQuest() {
        return LOTRMiniQuestFactory.HIGH_ELF.createQuest(this);
    }

    @Override
    public LOTRMiniQuestFactory getBountyHelpSpeechDir() {
        return LOTRMiniQuestFactory.HIGH_ELF;
    }
}

