/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.entity.npc;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Random;
import lotr.common.LOTRAchievement;
import lotr.common.LOTRMod;
import lotr.common.entity.ai.LOTREntityAIAttackOnCollide;
import lotr.common.entity.ai.LOTREntityAIBossJumpAttack;
import lotr.common.entity.ai.LOTREntityAIRangedAttack;
import lotr.common.entity.npc.LOTRBoss;
import lotr.common.entity.npc.LOTREntityEnt;
import lotr.common.entity.npc.LOTREntityHuorn;
import lotr.common.entity.npc.LOTREntityNPC;
import lotr.common.entity.npc.LOTREntityTree;
import lotr.common.entity.projectile.LOTREntityMallornLeafBomb;
import lotr.common.item.LOTRItemBossTrophy;
import lotr.common.network.LOTRPacketHandler;
import lotr.common.network.LOTRPacketMallornEntHeal;
import lotr.common.network.LOTRPacketMallornEntSummon;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFire;
import net.minecraft.block.BlockLeavesBase;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.EntityAIWatchClosest2;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.server.management.PlayerManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;

public class LOTREntityMallornEnt
extends LOTREntityEnt
implements LOTRBoss {
    public static float BOSS_SCALE = 1.5f;
    private static int SPAWN_TIME = 150;
    private static int MAX_LEAF_HEALINGS = 5;
    private LeafHealInfo[] leafHealings;
    private EntityAIBase meleeAttackAI = new LOTREntityAIAttackOnCollide(this, 2.0, false);
    private EntityAIBase rangedAttackAI = new LOTREntityAIRangedAttack(this, 1.5, 30, 50, 24.0f);

    public LOTREntityMallornEnt(World world) {
        super(world);
        this.func_70105_a(this.npcWidth * BOSS_SCALE, this.npcHeight * BOSS_SCALE);
        this.field_70714_bg.field_75782_a.clear();
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new LOTREntityAIBossJumpAttack(this, 1.5, 0.02f));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIWatchClosest2((EntityLiving)this, EntityPlayer.class, 12.0f, 0.02f));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIWatchClosest2((EntityLiving)this, LOTREntityNPC.class, 8.0f, 0.02f));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityLiving.class, 10.0f, 0.02f));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.resetLeafHealings();
    }

    private void resetLeafHealings() {
        this.leafHealings = new LeafHealInfo[MAX_LEAF_HEALINGS];
        for (int i = 0; i < MAX_LEAF_HEALINGS; ++i) {
            this.leafHealings[i] = new LeafHealInfo(this, i);
        }
    }

    @Override
    public void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(22, (Object)0);
        this.field_70180_af.func_75682_a(23, (Object)0);
    }

    public int getEntSpawnTick() {
        return this.field_70180_af.func_75693_b(22);
    }

    public void setEntSpawnTick(int i) {
        this.field_70180_af.func_75692_b(22, (Object)((short)i));
    }

    public boolean hasWeaponShield() {
        return this.field_70180_af.func_75683_a(23) == 1;
    }

    public void setHasWeaponShield(boolean flag) {
        this.field_70180_af.func_75692_b(23, (Object)(flag ? (byte)1 : 0));
    }

    public boolean isWeaponShieldActive() {
        return this.hasWeaponShield() && !this.func_70027_ad();
    }

    public float getSpawningOffset(float f) {
        float f1 = ((float)this.getEntSpawnTick() + f) / (float)SPAWN_TIME;
        f1 = Math.min(f1, 1.0f);
        return (1.0f - f1) * -5.0f;
    }

    @Override
    public boolean shouldBurningPanic() {
        return false;
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(300.0);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(32.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.2);
        this.func_110148_a(npcAttackDamage).func_111128_a(8.0);
    }

    @Override
    public int getExtraHeadBranches() {
        if (this.hasWeaponShield()) {
            return 0;
        }
        int max = 8;
        float healthR = this.func_110143_aJ() / this.func_110138_aP();
        int branches = MathHelper.func_76123_f((float)(healthR * (float)max));
        branches = MathHelper.func_76125_a((int)branches, (int)1, (int)max);
        return branches;
    }

    @Override
    public float getBaseChanceModifier() {
        return this.bossInfo.getHealthChanceModifier();
    }

    public void sendEntBossSpeech(String speechBank) {
        List players = this.field_70170_p.field_73010_i;
        double range = 64.0;
        for (Object obj : players) {
            EntityPlayer entityplayer = (EntityPlayer)obj;
            if (!(this.func_70068_e((Entity)entityplayer) <= range * range)) continue;
            this.sendSpeechBank(entityplayer, "ent/mallornEnt/" + speechBank);
        }
    }

    @Override
    public void onAttackModeChange(LOTREntityNPC.AttackMode mode, boolean mounted) {
        if (mode == LOTREntityNPC.AttackMode.IDLE) {
            this.field_70714_bg.func_85156_a(this.meleeAttackAI);
            this.field_70714_bg.func_85156_a(this.rangedAttackAI);
            this.field_70714_bg.func_75776_a(1, this.meleeAttackAI);
        }
        if (mode == LOTREntityNPC.AttackMode.MELEE) {
            this.field_70714_bg.func_85156_a(this.meleeAttackAI);
            this.field_70714_bg.func_85156_a(this.rangedAttackAI);
            this.field_70714_bg.func_75776_a(1, this.meleeAttackAI);
        }
        if (mode == LOTREntityNPC.AttackMode.RANGED) {
            this.field_70714_bg.func_85156_a(this.meleeAttackAI);
            this.field_70714_bg.func_85156_a(this.rangedAttackAI);
            this.field_70714_bg.func_75776_a(1, this.rangedAttackAI);
        }
    }

    @Override
    public double getMeleeRange() {
        return 12.0;
    }

    @Override
    public void func_82196_d(EntityLivingBase target, float f) {
        LOTREntityMallornLeafBomb leaves = new LOTREntityMallornLeafBomb(this.field_70170_p, (EntityLivingBase)this, target);
        leaves.leavesDamage = 6.0f;
        this.field_70170_p.func_72838_d((Entity)leaves);
        this.func_85030_a("lotr:ent.mallorn.leafAttack", this.func_70599_aP(), this.func_70647_i());
        this.func_71038_i();
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (this.getEntSpawnTick() < SPAWN_TIME) {
            if (!this.field_70170_p.field_72995_K) {
                this.setEntSpawnTick(this.getEntSpawnTick() + 1);
                if (this.getEntSpawnTick() == SPAWN_TIME) {
                    this.bossInfo.doJumpAttack(1.5);
                }
            } else {
                for (int l = 0; l < 16; ++l) {
                    double d = this.field_70165_t + this.field_70146_Z.nextGaussian() * (double)this.field_70130_N * 0.5;
                    double d1 = this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.field_70131_O + (double)this.getSpawningOffset(0.0f);
                    double d2 = this.field_70161_v + this.field_70146_Z.nextGaussian() * (double)this.field_70130_N * 0.5;
                    LOTRMod.proxy.spawnParticle("mEntSpawn", d, d1, d2, 0.0, 0.0, 0.0);
                }
                int leaves = 8;
                for (int l = 0; l < leaves; ++l) {
                    float leafR = (float)l / (float)leaves;
                    float argBase = (float)this.getEntSpawnTick() + leafR;
                    double r = 3.5;
                    double up = 0.5;
                    for (float extra : new float[]{0.0f, (float)Math.PI}) {
                        float arg = argBase + extra;
                        double x = this.field_70165_t + r * (double)MathHelper.func_76134_b((float)arg);
                        double z = this.field_70161_v + r * (double)MathHelper.func_76126_a((float)arg);
                        double y = this.field_70163_u + (double)leafR * up;
                        LOTRMod.proxy.spawnParticle("leafGold_40", x, y, z, 0.0, up, 0.0);
                    }
                }
            }
        }
        if (!this.field_70170_p.field_72995_K) {
            float f = this.getBaseChanceModifier();
            f *= 0.05f;
            if (this.field_70146_Z.nextFloat() < f) {
                this.bossInfo.doTargetedJumpAttack(1.5);
            }
        }
        if (!this.field_70170_p.field_72995_K && this.func_110143_aJ() < this.func_110138_aP()) {
            block3: for (LeafHealInfo healing : this.leafHealings) {
                if (healing.active) continue;
                float f = this.getBaseChanceModifier();
                f *= 0.02f;
                if (!(this.field_70146_Z.nextFloat() < f)) continue;
                int range = 16;
                int i = MathHelper.func_76128_c((double)this.field_70165_t);
                int j = MathHelper.func_76128_c((double)this.field_70163_u);
                int k = MathHelper.func_76128_c((double)this.field_70161_v);
                for (int l = 0; l < 30; ++l) {
                    int k1;
                    int j1;
                    int i1 = i + MathHelper.func_76136_a((Random)this.field_70146_Z, (int)(-range), (int)range);
                    Block block = this.field_70170_p.func_147439_a(i1, j1 = j + MathHelper.func_76136_a((Random)this.field_70146_Z, (int)(-range), (int)range), k1 = k + MathHelper.func_76136_a((Random)this.field_70146_Z, (int)(-range), (int)range));
                    if (!(block instanceof BlockLeavesBase)) continue;
                    healing.active = true;
                    healing.leafX = i1;
                    healing.leafY = j1;
                    healing.leafZ = k1;
                    healing.healTime = 15 + this.field_70146_Z.nextInt(15);
                    this.sendHealInfoToWatchers(healing);
                    continue block3;
                }
            }
        }
        for (LeafHealInfo healing : this.leafHealings) {
            if (!healing.active) continue;
            int leafX = healing.leafX;
            int leafY = healing.leafY;
            int leafZ = healing.leafZ;
            Block block = this.field_70170_p.func_147439_a(leafX, leafY, leafZ);
            int meta = this.field_70170_p.func_72805_g(leafX, leafY, leafZ);
            if (block instanceof BlockLeavesBase) {
                if (!this.field_70170_p.field_72995_K) {
                    if (this.field_70173_aa % 20 != 0) continue;
                    this.func_70691_i(2.0f);
                    healing.healTime--;
                    if (!(this.func_110143_aJ() >= this.func_110138_aP()) && healing.healTime > 0) continue;
                    healing.active = false;
                    this.sendHealInfoToWatchers(healing);
                    continue;
                }
                double d = (float)leafX + 0.5f;
                double d1 = (float)leafY + 0.5f;
                double d2 = (float)leafZ + 0.5f;
                double d3 = this.field_70165_t - d;
                double d4 = this.field_70163_u + (double)this.field_70131_O * 0.9 - d1;
                double d5 = this.field_70161_v - d2;
                LOTRMod.proxy.spawnParticle("mEntHeal_" + Block.func_149682_b((Block)block) + "_" + meta, d, d1, d2, d3 /= 25.0, d4 /= 25.0, d5 /= 25.0);
                continue;
            }
            if (this.field_70170_p.field_72995_K) continue;
            healing.active = false;
            this.sendHealInfoToWatchers(healing);
        }
        if (!this.field_70170_p.field_72995_K) {
            if (this.func_110143_aJ() < this.func_110138_aP() && this.field_70146_Z.nextInt(50) == 0) {
                this.trySummonEnts();
            }
        } else if (this.getEntSpawnTick() >= SPAWN_TIME) {
            for (int i = 0; i < 2; ++i) {
                double d = this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N;
                double d1 = this.field_70163_u + (double)this.field_70131_O + this.field_70146_Z.nextDouble() * (double)this.field_70131_O * 0.5;
                double d2 = this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N;
                double d3 = MathHelper.func_82716_a((Random)this.field_70146_Z, (double)-0.2, (double)0.2);
                double d4 = MathHelper.func_82716_a((Random)this.field_70146_Z, (double)-0.2, (double)0.0);
                double d5 = MathHelper.func_82716_a((Random)this.field_70146_Z, (double)-0.2, (double)0.2);
                int time = 30 + this.field_70146_Z.nextInt(30);
                LOTRMod.proxy.spawnParticle("leafGold_" + time, d, d1, d2, d3, d4, d5);
            }
        }
    }

    private void trySummonEnts() {
        float f = this.getBaseChanceModifier();
        f *= 0.5f;
        List nearbyTrees = this.field_70170_p.func_72872_a(LOTREntityTree.class, this.field_70121_D.func_72314_b(24.0, 8.0, 24.0));
        int maxNearbyTrees = 6;
        float nearbyModifier = (float)(maxNearbyTrees - nearbyTrees.size()) / (float)maxNearbyTrees;
        f *= nearbyModifier;
        if (this.field_70146_Z.nextFloat() < f) {
            LOTREntityTree tree = this.field_70146_Z.nextInt(3) == 0 ? new LOTREntityHuorn(this.field_70170_p) : new LOTREntityEnt(this.field_70170_p);
            int range = 12;
            int i = MathHelper.func_76128_c((double)this.field_70165_t);
            int j = MathHelper.func_76128_c((double)this.field_70163_u);
            int k = MathHelper.func_76128_c((double)this.field_70161_v);
            for (int l = 0; l < 30; ++l) {
                int k1;
                int j1;
                int i1 = i + MathHelper.func_76136_a((Random)this.field_70146_Z, (int)(-range), (int)range);
                if (!this.field_70170_p.func_147439_a(i1, (j1 = j + MathHelper.func_76136_a((Random)this.field_70146_Z, (int)(-range), (int)range)) - 1, k1 = k + MathHelper.func_76136_a((Random)this.field_70146_Z, (int)(-range), (int)range)).func_149721_r() || this.field_70170_p.func_147439_a(i1, j1, k1).func_149721_r() || this.field_70170_p.func_147439_a(i1, j1 + 1, k1).func_149721_r()) continue;
                tree.func_70012_b((double)i1 + 0.5, j1, (double)k1 + 0.5, this.field_70146_Z.nextFloat() * 360.0f, 0.0f);
                tree.liftSpawnRestrictions = true;
                if (!tree.func_70601_bi()) continue;
                tree.liftSpawnRestrictions = false;
                tree.func_110161_a(null);
                this.field_70170_p.func_72838_d((Entity)tree);
                this.sendEntSummon(tree);
                this.field_70170_p.func_72956_a((Entity)tree, "lotr:ent.mallorn.summonEnt", this.func_70599_aP(), this.func_70647_i());
                break;
            }
        }
    }

    private void sendEntSummon(LOTREntityTree tree) {
        LOTRPacketMallornEntSummon packet = new LOTRPacketMallornEntSummon(this.func_145782_y(), tree.func_145782_y());
        LOTRPacketHandler.networkWrapper.sendToAllAround((IMessage)packet, LOTRPacketHandler.nearEntity((Entity)tree, 64.0));
    }

    @Override
    public void onPlayerStartTracking(EntityPlayerMP entityplayer) {
        super.onPlayerStartTracking(entityplayer);
        for (LeafHealInfo healing : this.leafHealings) {
            healing.sendData(entityplayer);
        }
    }

    private void sendHealInfoToWatchers(LeafHealInfo healing) {
        int x = MathHelper.func_76128_c((double)this.field_70165_t) >> 4;
        int z = MathHelper.func_76128_c((double)this.field_70161_v) >> 4;
        PlayerManager playermanager = ((WorldServer)this.field_70170_p).func_73040_p();
        List players = this.field_70170_p.field_73010_i;
        for (Object obj : players) {
            EntityPlayerMP entityplayer = (EntityPlayerMP)obj;
            if (!playermanager.func_72694_a(entityplayer, x, z)) continue;
            healing.sendData(entityplayer);
        }
    }

    public void receiveClientHealing(NBTTagCompound data) {
        LeafHealInfo healing = new LeafHealInfo(this, 0);
        healing.receiveData(data);
        this.leafHealings[((LeafHealInfo)healing).slot] = healing;
    }

    public void spawnEntSummonParticles(LOTREntityTree tree) {
        int l;
        int type = tree.getTreeType();
        Block leafBlock = LOTREntityTree.LEAF_BLOCKS[type];
        int leafMeta = LOTREntityTree.LEAF_META[type];
        int particles = 60;
        for (l = 0; l < particles; ++l) {
            float t = (float)l / (float)particles;
            LOTRMod.proxy.spawnParticle("mEntSummon_" + this.func_145782_y() + "_" + tree.func_145782_y() + "_" + t + "_" + Block.func_149682_b((Block)leafBlock) + "_" + leafMeta, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        }
        for (l = 0; l < 120; ++l) {
            double d = tree.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)tree.field_70130_N;
            double d1 = tree.field_70163_u + (double)tree.field_70131_O * 0.5;
            double d2 = tree.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)tree.field_70130_N;
            double d3 = MathHelper.func_82716_a((Random)this.field_70146_Z, (double)-0.4, (double)0.4);
            double d4 = MathHelper.func_82716_a((Random)this.field_70146_Z, (double)-0.4, (double)0.4);
            double d5 = MathHelper.func_82716_a((Random)this.field_70146_Z, (double)-0.4, (double)0.4);
            LOTRMod.proxy.spawnParticle("mEntHeal_" + Block.func_149682_b((Block)leafBlock) + "_" + leafMeta, d, d1, d2, d3, d4, d5);
        }
    }

    protected boolean func_70610_aX() {
        if (this.getEntSpawnTick() < SPAWN_TIME) {
            return true;
        }
        return super.func_70610_aX();
    }

    @Override
    public void onJumpAttackFall() {
        this.field_70170_p.func_72960_a((Entity)this, (byte)20);
        this.func_85030_a("lotr:troll.rockSmash", 1.5f, 0.75f);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70103_a(byte b) {
        int i;
        if (b == 20) {
            for (i = 0; i < 360; i += 2) {
                float angle = (float)Math.toRadians(i);
                double distance = 2.0;
                double d = distance * (double)MathHelper.func_76126_a((float)angle);
                double d1 = distance * (double)MathHelper.func_76134_b((float)angle);
                LOTRMod.proxy.spawnParticle("mEntJumpSmash", this.field_70165_t + d, this.field_70121_D.field_72338_b + 0.1, this.field_70161_v + d1, d * 0.2, 0.2, d1 * 0.2);
            }
        }
        if (b == 21) {
            for (i = 0; i < 200; ++i) {
                double d = this.field_70165_t;
                double d1 = this.field_70163_u + (double)(this.field_70131_O * 0.5f);
                double d2 = this.field_70161_v;
                double d3 = MathHelper.func_82716_a((Random)this.field_70146_Z, (double)-0.1, (double)0.1);
                double d4 = MathHelper.func_82716_a((Random)this.field_70146_Z, (double)-0.1, (double)0.1);
                double d5 = MathHelper.func_82716_a((Random)this.field_70146_Z, (double)-0.1, (double)0.1);
                int time = 40 + this.field_70146_Z.nextInt(30);
                LOTRMod.proxy.spawnParticle("leafGold_" + time, d, d1, d2, d3, d4, d5);
            }
        } else {
            super.func_70103_a(b);
        }
    }

    @Override
    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        NBTTagList leafHealingTags = new NBTTagList();
        for (int i = 0; i < this.leafHealings.length; ++i) {
            LeafHealInfo healing = this.leafHealings[i];
            NBTTagCompound healTag = new NBTTagCompound();
            healing.writeToNBT(healTag);
            leafHealingTags.func_74742_a((NBTBase)healTag);
        }
        nbt.func_74782_a("LeafHealings", (NBTBase)leafHealingTags);
        nbt.func_74768_a("EntSpawnTick", this.getEntSpawnTick());
        nbt.func_74757_a("EntWeaponShield", this.hasWeaponShield());
    }

    @Override
    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        this.resetLeafHealings();
        NBTTagList leafHealingTags = nbt.func_150295_c("LeafHealings", 10);
        for (int i = 0; i < leafHealingTags.func_74745_c(); ++i) {
            NBTTagCompound healTag = leafHealingTags.func_150305_b(i);
            byte slot = healTag.func_74771_c("Slot");
            if (slot < 0 || slot >= this.leafHealings.length) continue;
            LeafHealInfo healing = this.leafHealings[slot];
            healing.readFromNBT(healTag);
        }
        this.setEntSpawnTick(nbt.func_74762_e("EntSpawnTick"));
        this.setHasWeaponShield(nbt.func_74767_n("EntWeaponShield"));
    }

    @Override
    public boolean func_70097_a(DamageSource damagesource, float f) {
        if (this.getEntSpawnTick() < SPAWN_TIME) {
            return false;
        }
        if (LOTRMod.getDamagingPlayerIncludingUnits(damagesource) == null && f > 1.0f) {
            f = 1.0f;
        }
        if (!this.isTreeEffectiveDamage(damagesource)) {
            f *= 0.5f;
        }
        if (this.isWeaponShieldActive() && !damagesource.func_76347_k()) {
            f = 0.0f;
        }
        boolean flag = super.func_70097_a(damagesource, f);
        return flag;
    }

    @Override
    protected boolean doTreeDamageCalculation() {
        return false;
    }

    @Override
    protected void func_70665_d(DamageSource damagesource, float f) {
        super.func_70665_d(damagesource, f);
        if (!this.field_70170_p.field_72995_K && !this.hasWeaponShield() && this.func_110143_aJ() <= 0.0f) {
            this.setHasWeaponShield(true);
            this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(300.0);
            this.func_70606_j(this.func_110138_aP());
            this.sendEntBossSpeech("shield");
        }
    }

    @Override
    public void func_70645_a(DamageSource damagesource) {
        if (!this.field_70170_p.field_72995_K) {
            this.field_70170_p.func_72960_a((Entity)this, (byte)21);
            int fireRange = 12;
            int i = MathHelper.func_76128_c((double)this.field_70165_t);
            int j = MathHelper.func_76128_c((double)this.field_70163_u);
            int k = MathHelper.func_76128_c((double)this.field_70161_v);
            for (int i1 = i - fireRange; i1 <= i + fireRange; ++i1) {
                for (int j1 = j - fireRange; j1 <= j + fireRange; ++j1) {
                    for (int k1 = k - fireRange; k1 <= k + fireRange; ++k1) {
                        Block block = this.field_70170_p.func_147439_a(i1, j1, k1);
                        if (!(block instanceof BlockFire)) continue;
                        this.field_70170_p.func_147468_f(i1, j1, k1);
                    }
                }
            }
        }
        super.func_70645_a(damagesource);
    }

    @Override
    public void func_70628_a(boolean flag, int i) {
        int dropped;
        int dropped2;
        super.func_70628_a(flag, i);
        for (int wood = MathHelper.func_76136_a((Random)this.field_70146_Z, (int)20, (int)(30 + i * 20)); wood > 0; wood -= dropped2) {
            dropped2 = Math.min(20, wood);
            this.func_70099_a(new ItemStack(LOTRMod.wood, dropped2, 1), 0.0f);
        }
        for (int sticks = MathHelper.func_76136_a((Random)this.field_70146_Z, (int)30, (int)(40 + i * 20)); sticks > 0; sticks -= dropped) {
            dropped = Math.min(20, sticks);
            this.func_70099_a(new ItemStack(LOTRMod.mallornStick, dropped), 0.0f);
        }
        this.func_70099_a(new ItemStack(LOTRMod.bossTrophy, 1, LOTRItemBossTrophy.TrophyType.MALLORN_ENT.trophyID), 0.0f);
        float maceChance = 0.3f;
        maceChance += (float)i * 0.1f;
        if (this.field_70146_Z.nextFloat() < maceChance) {
            this.func_145779_a(LOTRMod.maceMallornCharred, 1);
        }
    }

    @Override
    public LOTRAchievement getBossKillAchievement() {
        return LOTRAchievement.killMallornEnt;
    }

    @Override
    public float getAlignmentBonus() {
        return 50.0f;
    }

    @Override
    protected int func_70693_a(EntityPlayer entityplayer) {
        return 100;
    }

    @Override
    protected LOTRAchievement getTalkAchievement() {
        return null;
    }

    @Override
    public String getSpeechBank(EntityPlayer entityplayer) {
        return null;
    }

    private static class LeafHealInfo {
        private LOTREntityMallornEnt theEnt;
        private int slot;
        private boolean active;
        private int leafX;
        private int leafY;
        private int leafZ;
        private int healTime;

        public LeafHealInfo(LOTREntityMallornEnt ent, int i) {
            this.theEnt = ent;
            this.slot = i;
        }

        public void writeToNBT(NBTTagCompound nbt) {
            nbt.func_74774_a("Slot", (byte)this.slot);
            nbt.func_74757_a("Active", this.active);
            nbt.func_74768_a("X", this.leafX);
            nbt.func_74768_a("Y", this.leafY);
            nbt.func_74768_a("Z", this.leafZ);
            nbt.func_74777_a("Time", (short)this.healTime);
        }

        public void readFromNBT(NBTTagCompound nbt) {
            this.slot = nbt.func_74771_c("Slot");
            this.active = nbt.func_74767_n("Active");
            this.leafX = nbt.func_74762_e("X");
            this.leafY = nbt.func_74762_e("Y");
            this.leafZ = nbt.func_74762_e("Z");
            this.healTime = nbt.func_74765_d("healTime");
        }

        public void sendData(EntityPlayerMP entityplayer) {
            NBTTagCompound nbt = new NBTTagCompound();
            this.writeToNBT(nbt);
            LOTRPacketMallornEntHeal packet = new LOTRPacketMallornEntHeal(this.theEnt.func_145782_y(), nbt);
            LOTRPacketHandler.networkWrapper.sendTo((IMessage)packet, entityplayer);
        }

        public void receiveData(NBTTagCompound nbt) {
            this.readFromNBT(nbt);
        }
    }
}

