/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.entity.npc;

import lotr.common.LOTRAchievement;
import lotr.common.LOTRCapes;
import lotr.common.LOTRLevelData;
import lotr.common.LOTRMod;
import lotr.common.entity.ai.LOTREntityAIAttackOnCollide;
import lotr.common.entity.npc.LOTREntityNearHaradrimWarrior;
import lotr.common.entity.npc.LOTRUnitTradeEntries;
import lotr.common.entity.npc.LOTRUnitTradeable;
import lotr.common.world.spawning.LOTRInvasions;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class LOTREntityNearHaradrimWarlord
extends LOTREntityNearHaradrimWarrior
implements LOTRUnitTradeable {
    public LOTREntityNearHaradrimWarlord(World world) {
        super(world);
        this.addTargetTasks(false);
        this.npcCape = LOTRCapes.NEAR_HARAD;
    }

    @Override
    public EntityAIBase createHaradrimAttackAI() {
        return new LOTREntityAIAttackOnCollide(this, 1.6, false);
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(25.0);
    }

    @Override
    public IEntityLivingData func_110161_a(IEntityLivingData data) {
        data = super.func_110161_a(data);
        this.npcItemsInv.setMeleeWeapon(new ItemStack(LOTRMod.poleaxeNearHarad));
        this.npcItemsInv.setIdleItem(this.npcItemsInv.getMeleeWeapon());
        this.func_70062_b(4, new ItemStack(LOTRMod.helmetNearHaradWarlord));
        return data;
    }

    @Override
    public float getAlignmentBonus() {
        return 5.0f;
    }

    @Override
    public LOTRUnitTradeEntries getUnits() {
        return LOTRUnitTradeEntries.NEAR_HARADRIM_WARLORD;
    }

    @Override
    public LOTRInvasions getWarhorn() {
        return LOTRInvasions.NEAR_HARAD_COAST;
    }

    @Override
    public boolean canTradeWith(EntityPlayer entityplayer) {
        return LOTRLevelData.getData(entityplayer).getAlignment(this.getFaction()) >= 150.0f && this.isFriendlyAndAligned(entityplayer);
    }

    @Override
    public void onUnitTrade(EntityPlayer entityplayer) {
        LOTRLevelData.getData(entityplayer).addAchievement(LOTRAchievement.tradeNearHaradWarlord);
    }

    @Override
    public String getSpeechBank(EntityPlayer entityplayer) {
        if (this.isFriendlyAndAligned(entityplayer)) {
            if (this.canTradeWith(entityplayer)) {
                return "nearHarad/coast/warlord/friendly";
            }
            return "nearHarad/coast/warlord/neutral";
        }
        return "nearHarad/coast/warrior/hostile";
    }
}

