/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.entity.npc;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import lotr.common.LOTRConfig;
import lotr.common.LOTRLevelData;
import lotr.common.LOTRMod;
import lotr.common.LOTRPlayerData;
import lotr.common.entity.LOTRMountFunctions;
import lotr.common.entity.npc.LOTREntityNPC;
import lotr.common.entity.npc.LOTRNPCMount;
import lotr.common.entity.npc.LOTRUnitTradeEntry;
import lotr.common.fac.LOTRFaction;
import lotr.common.inventory.LOTRInventoryNPC;
import lotr.common.network.LOTRPacketHandler;
import lotr.common.network.LOTRPacketHiredGui;
import lotr.common.network.LOTRPacketHiredInfo;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.item.EntityFireworkRocket;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.server.management.PlayerManager;
import net.minecraft.server.management.PreYggdrasilConverter;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MathHelper;
import net.minecraft.util.StatCollector;
import net.minecraft.util.StringUtils;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.util.ForgeDirection;

public class LOTRHiredNPCInfo {
    private LOTREntityNPC theEntity;
    private UUID hiringPlayerUUID;
    public boolean isActive;
    public float alignmentRequiredToCommand;
    public LOTRUnitTradeEntry.PledgeType pledgeType = LOTRUnitTradeEntry.PledgeType.NONE;
    private Task hiredTask = Task.WARRIOR;
    private boolean canMove = true;
    public boolean teleportAutomatically = true;
    public int mobKills;
    public int xp = 0;
    public int xpLevel = 1;
    public static final int XP_COLOR = 0xFF5500;
    private static final float LEVEL_UP_HEALTH_GAIN = 1.0f;
    private String hiredSquadron;
    public boolean guardMode;
    public static int GUARD_RANGE_MIN = 1;
    public static int GUARD_RANGE_DEFAULT = 8;
    public static int GUARD_RANGE_MAX = 64;
    private int guardRange = GUARD_RANGE_DEFAULT;
    private LOTRInventoryNPC hiredInventory;
    public boolean inCombat;
    private boolean prevInCombat;
    public boolean isGuiOpen;
    private boolean targetFromCommandSword;
    public boolean wasAttackCommanded = false;
    private boolean doneFirstUpdate = false;
    private boolean resendBasicData = true;

    public LOTRHiredNPCInfo(LOTREntityNPC npc) {
        this.theEntity = npc;
    }

    public void hireUnit(EntityPlayer entityplayer, boolean setLocation, LOTRFaction hiringFaction, LOTRUnitTradeEntry tradeEntry, String squadron, Entity mount) {
        float alignment = tradeEntry.alignmentRequired;
        LOTRUnitTradeEntry.PledgeType pledge = tradeEntry.getPledgeType();
        Task task = tradeEntry.task;
        if (setLocation) {
            this.theEntity.func_70012_b(entityplayer.field_70165_t, entityplayer.field_70121_D.field_72338_b, entityplayer.field_70161_v, entityplayer.field_70177_z + 180.0f, 0.0f);
        }
        this.isActive = true;
        this.alignmentRequiredToCommand = alignment;
        this.pledgeType = pledge;
        this.setHiringPlayer(entityplayer);
        this.setTask(task);
        this.setSquadron(squadron);
        if (hiringFaction != null && hiringFaction.isPlayableAlignmentFaction()) {
            LOTRLevelData.getData(entityplayer).getFactionData(hiringFaction).addHire();
        }
        if (mount != null) {
            mount.func_70012_b(this.theEntity.field_70165_t, this.theEntity.field_70121_D.field_72338_b, this.theEntity.field_70161_v, this.theEntity.field_70177_z, 0.0f);
            if (mount instanceof LOTREntityNPC) {
                LOTREntityNPC hiredMountNPC = (LOTREntityNPC)mount;
                hiredMountNPC.hiredNPCInfo.hireUnit(entityplayer, setLocation, hiringFaction, tradeEntry, squadron, null);
            }
            this.theEntity.func_70078_a(mount);
            if (mount instanceof LOTRNPCMount && !(mount instanceof LOTREntityNPC)) {
                this.theEntity.setRidingHorse(true);
                LOTRNPCMount hiredHorse = (LOTRNPCMount)mount;
                hiredHorse.setBelongsToNPC(true);
                LOTRMountFunctions.setNavigatorRangeFromNPC(hiredHorse, this.theEntity);
            }
        }
    }

    public void setHiringPlayer(EntityPlayer entityplayer) {
        this.hiringPlayerUUID = entityplayer == null ? null : entityplayer.func_110124_au();
        this.markDirty();
    }

    public EntityPlayer getHiringPlayer() {
        if (this.hiringPlayerUUID == null) {
            return null;
        }
        return this.theEntity.field_70170_p.func_152378_a(this.hiringPlayerUUID);
    }

    public UUID getHiringPlayerUUID() {
        return this.hiringPlayerUUID;
    }

    public Task getTask() {
        return this.hiredTask;
    }

    public void setTask(Task t) {
        if (t != this.hiredTask) {
            this.hiredTask = t;
            this.markDirty();
        }
        if (this.hiredTask == Task.FARMER) {
            this.hiredInventory = new LOTRInventoryNPC("HiredInventory", this.theEntity, 4);
        }
    }

    public LOTRInventoryNPC getHiredInventory() {
        return this.hiredInventory;
    }

    private void markDirty() {
        if (!this.theEntity.field_70170_p.field_72995_K) {
            if (this.theEntity.field_70173_aa > 0) {
                this.resendBasicData = true;
            } else {
                this.sendBasicDataToAllWatchers();
            }
        }
    }

    public boolean hasHiringRequirements() {
        return this.theEntity.getHiringFaction().isPlayableAlignmentFaction() && this.alignmentRequiredToCommand >= 0.0f;
    }

    public void onUpdate() {
        if (!this.theEntity.field_70170_p.field_72995_K) {
            EntityPlayer entityplayer;
            if (!this.doneFirstUpdate) {
                this.doneFirstUpdate = true;
            }
            if (this.resendBasicData) {
                this.sendBasicDataToAllWatchers();
                this.resendBasicData = false;
            }
            if (this.hasHiringRequirements() && this.isActive && (entityplayer = this.getHiringPlayer()) != null) {
                LOTRFaction fac = this.theEntity.getHiringFaction();
                LOTRPlayerData pd = LOTRLevelData.getData(entityplayer);
                boolean canCommand = true;
                if (pd.getAlignment(fac) < this.alignmentRequiredToCommand) {
                    canCommand = false;
                }
                if (!this.pledgeType.canAcceptPlayer(entityplayer, fac)) {
                    canCommand = false;
                }
                if (!canCommand) {
                    this.dismissUnit(true);
                }
            }
            boolean bl = this.inCombat = this.theEntity.func_70638_az() != null;
            if (this.inCombat != this.prevInCombat) {
                this.sendClientPacket(false);
            }
            this.prevInCombat = this.inCombat;
            if (this.getTask() == Task.WARRIOR && !this.inCombat && this.shouldFollowPlayer() && this.theEntity.func_70681_au().nextInt(4000) == 0) {
                String speechBank;
                EntityPlayer hiringPlayer = this.getHiringPlayer();
                double range = 16.0;
                if (hiringPlayer != null && this.theEntity.func_70068_e((Entity)hiringPlayer) < range * range && (speechBank = this.theEntity.getSpeechBank(hiringPlayer)) != null) {
                    this.theEntity.sendSpeechBank(hiringPlayer, speechBank);
                }
            }
        }
    }

    public void dismissUnit(boolean isDesertion) {
        if (isDesertion) {
            this.getHiringPlayer().func_145747_a((IChatComponent)new ChatComponentTranslation("lotr.hiredNPC.desert", new Object[]{this.theEntity.func_70005_c_()}));
        } else {
            this.getHiringPlayer().func_145747_a((IChatComponent)new ChatComponentTranslation("lotr.hiredNPC.dismiss", new Object[]{this.theEntity.func_70005_c_()}));
        }
        if (this.hiredTask == Task.FARMER && this.hiredInventory != null) {
            this.hiredInventory.dropAllItems();
        }
        this.isActive = false;
        this.canMove = true;
        this.sendClientPacket(false);
        this.setHiringPlayer(null);
    }

    public void onDeath(DamageSource damagesource) {
        EntityPlayer hiringPlayer;
        if (!this.theEntity.field_70170_p.field_72995_K && this.isActive && this.getHiringPlayer() != null && LOTRLevelData.getData(hiringPlayer = this.getHiringPlayer()).getEnableHiredDeathMessages()) {
            hiringPlayer.func_145747_a((IChatComponent)new ChatComponentTranslation("lotr.hiredNPC.death", new Object[]{this.theEntity.func_110142_aN().func_151521_b()}));
        }
        if (!this.theEntity.field_70170_p.field_72995_K && this.hiredInventory != null) {
            this.hiredInventory.dropAllItems();
        }
    }

    public void halt() {
        this.canMove = false;
        this.theEntity.func_70624_b(null);
        this.sendClientPacket(false);
    }

    public void ready() {
        this.canMove = true;
        this.sendClientPacket(false);
    }

    public boolean isHalted() {
        return !this.guardMode && !this.canMove;
    }

    public boolean shouldFollowPlayer() {
        return !this.guardMode && this.canMove;
    }

    public boolean getObeyHornHaltReady() {
        if (this.hiredTask != Task.WARRIOR) {
            return false;
        }
        return !this.guardMode;
    }

    public boolean getObeyHornSummon() {
        if (this.hiredTask != Task.WARRIOR) {
            return false;
        }
        return !this.guardMode;
    }

    public boolean getObeyCommandSword() {
        if (this.hiredTask != Task.WARRIOR) {
            return false;
        }
        return !this.guardMode;
    }

    public boolean isGuardMode() {
        return this.guardMode;
    }

    public void setGuardMode(boolean flag) {
        this.guardMode = flag;
        if (flag) {
            int i = MathHelper.func_76128_c((double)this.theEntity.field_70165_t);
            int j = MathHelper.func_76128_c((double)this.theEntity.field_70163_u);
            int k = MathHelper.func_76128_c((double)this.theEntity.field_70161_v);
            this.theEntity.func_110171_b(i, j, k, this.guardRange);
        } else {
            this.theEntity.func_110177_bN();
        }
    }

    public int getGuardRange() {
        return this.guardRange;
    }

    public void setGuardRange(int range) {
        this.guardRange = MathHelper.func_76125_a((int)range, (int)GUARD_RANGE_MIN, (int)GUARD_RANGE_MAX);
        if (this.guardMode) {
            int i = MathHelper.func_76128_c((double)this.theEntity.field_70165_t);
            int j = MathHelper.func_76128_c((double)this.theEntity.field_70163_u);
            int k = MathHelper.func_76128_c((double)this.theEntity.field_70161_v);
            this.theEntity.func_110171_b(i, j, k, this.guardRange);
        }
    }

    public String getSquadron() {
        return this.hiredSquadron;
    }

    public void setSquadron(String s) {
        this.hiredSquadron = s;
        this.markDirty();
    }

    public String getStatusString() {
        String status = "";
        if (this.hiredTask == Task.WARRIOR) {
            status = this.inCombat ? StatCollector.func_74838_a((String)"lotr.hiredNPC.status.combat") : (this.isHalted() ? StatCollector.func_74838_a((String)"lotr.hiredNPC.status.halted") : (this.guardMode ? StatCollector.func_74838_a((String)"lotr.hiredNPC.status.guard") : StatCollector.func_74838_a((String)"lotr.hiredNPC.status.ready")));
        } else if (this.hiredTask == Task.FARMER) {
            status = this.guardMode ? StatCollector.func_74838_a((String)"lotr.hiredNPC.status.farming") : StatCollector.func_74838_a((String)"lotr.hiredNPC.status.following");
        }
        String s = StatCollector.func_74837_a((String)"lotr.hiredNPC.status", (Object[])new Object[]{status});
        return s;
    }

    public void onSetTarget(EntityLivingBase newTarget, EntityLivingBase prevTarget) {
        if (newTarget == null || newTarget != prevTarget) {
            this.targetFromCommandSword = false;
            this.wasAttackCommanded = false;
        }
    }

    public void commandSwordAttack(EntityLivingBase target) {
        if (target != null && LOTRMod.canNPCAttackEntity(this.theEntity, target, true)) {
            this.theEntity.func_70661_as().func_75499_g();
            this.theEntity.func_70604_c(target);
            this.theEntity.func_70624_b(target);
            this.targetFromCommandSword = true;
        }
    }

    public void commandSwordCancel() {
        if (this.targetFromCommandSword) {
            this.theEntity.func_70661_as().func_75499_g();
            this.theEntity.func_70604_c(null);
            this.theEntity.func_70624_b(null);
            this.targetFromCommandSword = false;
        }
    }

    public void onKillEntity(EntityLivingBase target) {
        if (!this.theEntity.field_70170_p.field_72995_K && this.isActive) {
            ++this.mobKills;
            this.sendClientPacket(false);
            if (this.getTask() == Task.WARRIOR) {
                boolean wasEnemy = false;
                int addXP = 0;
                LOTRFaction unitFaction = this.theEntity.getHiringFaction();
                if (target instanceof EntityPlayer) {
                    wasEnemy = LOTRLevelData.getData((EntityPlayer)target).getAlignment(unitFaction) < 0.0f;
                } else {
                    LOTRFaction targetFaction = LOTRMod.getNPCFaction((Entity)target);
                    if (targetFaction.isBadRelation(unitFaction) || unitFaction == LOTRFaction.RUFFIAN && targetFaction != LOTRFaction.UNALIGNED && targetFaction != LOTRFaction.RUFFIAN) {
                        wasEnemy = true;
                        addXP = 1;
                    }
                }
                if (wasEnemy && this.theEntity.func_70681_au().nextInt(3) == 0) {
                    String speechBank;
                    EntityPlayer hiringPlayer = this.getHiringPlayer();
                    double range = 16.0;
                    if (hiringPlayer != null && this.theEntity.func_70068_e((Entity)hiringPlayer) < 256.0 && (speechBank = this.theEntity.getSpeechBank(hiringPlayer)) != null) {
                        this.theEntity.sendSpeechBank(hiringPlayer, speechBank);
                    }
                }
                if (addXP > 0 && LOTRConfig.enableUnitLevelling) {
                    this.addExperience(addXP);
                }
            }
        }
    }

    private void addExperience(int xpAdd) {
        this.addExperience(xpAdd, true);
    }

    private void addExperience(int xpAdd, boolean passToRiderOrMount) {
        this.xp += xpAdd;
        while (this.xp >= LOTRHiredNPCInfo.totalXPForLevel(this.xpLevel + 1)) {
            ++this.xpLevel;
            this.markDirty();
            this.onLevelUp();
        }
        this.sendClientPacket(false);
        if (passToRiderOrMount) {
            this.addExperienceIfApplicable(this.theEntity.field_70153_n, xpAdd);
            this.addExperienceIfApplicable(this.theEntity.field_70154_o, xpAdd);
        }
    }

    private void addExperienceIfApplicable(Entity maybeNPC, int xpAdd) {
        if (maybeNPC instanceof LOTREntityNPC) {
            LOTREntityNPC otherNPC = (LOTREntityNPC)maybeNPC;
            if (otherNPC.hiredNPCInfo.isActive && this.getHiringPlayerUUID().equals(otherNPC.hiredNPCInfo.getHiringPlayerUUID())) {
                otherNPC.hiredNPCInfo.addExperience(xpAdd, false);
            }
        }
    }

    public static int totalXPForLevel(int lvl) {
        if (lvl <= 1) {
            return 0;
        }
        double d = 3.0 * (double)(lvl - 1) * Math.pow(1.08, lvl - 2);
        return MathHelper.func_76128_c((double)d);
    }

    public float getProgressToNextLevel() {
        int cap = LOTRHiredNPCInfo.totalXPForLevel(this.xpLevel + 1);
        int start = LOTRHiredNPCInfo.totalXPForLevel(this.xpLevel);
        return (float)(this.xp - start) / (float)(cap - start);
    }

    private void onLevelUp() {
        EntityPlayer hirer;
        this.addLevelUpHealthGain((EntityLivingBase)this.theEntity);
        Entity mount = this.theEntity.field_70154_o;
        if (mount instanceof EntityLivingBase && !(mount instanceof LOTREntityNPC)) {
            this.addLevelUpHealthGain((EntityLivingBase)mount);
        }
        if ((hirer = this.getHiringPlayer()) != null) {
            hirer.func_145747_a((IChatComponent)new ChatComponentTranslation("lotr.hiredNPC.levelUp", new Object[]{this.theEntity.func_70005_c_(), this.xpLevel}));
        }
        this.spawnLevelUpFireworks();
    }

    private void addLevelUpHealthGain(EntityLivingBase gainingEntity) {
        float healthBoost = 1.0f;
        IAttributeInstance attrHealth = gainingEntity.func_110148_a(SharedMonsterAttributes.field_111267_a);
        attrHealth.func_111128_a(attrHealth.func_111125_b() + (double)healthBoost);
        gainingEntity.func_70691_i(healthBoost);
    }

    private void spawnLevelUpFireworks() {
        boolean bigLvlUp = this.xpLevel % 5 == 0;
        World world = this.theEntity.field_70170_p;
        ItemStack itemstack = new ItemStack(Items.field_151152_bP);
        NBTTagCompound itemData = new NBTTagCompound();
        NBTTagCompound fireworkData = new NBTTagCompound();
        NBTTagList explosionsList = new NBTTagList();
        int explosions = 1;
        for (int l = 0; l < explosions; ++l) {
            NBTTagCompound explosionData = new NBTTagCompound();
            explosionData.func_74757_a("Flicker", true);
            explosionData.func_74757_a("Trail", bigLvlUp);
            int[] colors = new int[]{0xFF5500, this.theEntity.getFaction().getFactionColor()};
            explosionData.func_74783_a("Colors", colors);
            boolean effectType = bigLvlUp;
            explosionData.func_74774_a("Type", (byte)(effectType ? 1 : 0));
            explosionsList.func_74742_a((NBTBase)explosionData);
        }
        fireworkData.func_74782_a("Explosions", (NBTBase)explosionsList);
        itemData.func_74782_a("Fireworks", (NBTBase)fireworkData);
        itemstack.func_77982_d(itemData);
        EntityFireworkRocket firework = new EntityFireworkRocket(world, this.theEntity.field_70165_t, this.theEntity.field_70121_D.field_72338_b + (double)this.theEntity.field_70131_O, this.theEntity.field_70161_v, itemstack);
        NBTTagCompound fireworkNBT = new NBTTagCompound();
        firework.func_70014_b(fireworkNBT);
        fireworkNBT.func_74768_a("LifeTime", bigLvlUp ? 20 : 15);
        firework.func_70037_a(fireworkNBT);
        world.func_72838_d((Entity)firework);
    }

    public boolean tryTeleportToHiringPlayer(boolean failsafe) {
        World world = this.theEntity.field_70170_p;
        if (!world.field_72995_K) {
            EntityPlayer entityplayer = this.getHiringPlayer();
            if (this.isActive && entityplayer != null && this.theEntity.field_70153_n == null) {
                int i = MathHelper.func_76128_c((double)entityplayer.field_70165_t);
                int j = MathHelper.func_76128_c((double)entityplayer.field_70121_D.field_72338_b);
                int k = MathHelper.func_76128_c((double)entityplayer.field_70161_v);
                float minDist = 3.0f;
                float maxDist = 6.0f;
                float extraDist = this.theEntity.field_70130_N / 2.0f;
                if (this.theEntity.field_70154_o instanceof EntityLiving) {
                    extraDist = Math.max(this.theEntity.field_70130_N, this.theEntity.field_70154_o.field_70130_N) / 2.0f;
                }
                minDist += extraDist;
                maxDist += extraDist;
                int attempts = 120;
                for (int l = 0; l < attempts; ++l) {
                    float height;
                    double d2;
                    float yExtra;
                    float angle = world.field_73012_v.nextFloat() * (float)Math.PI * 2.0f;
                    float sin = MathHelper.func_76126_a((float)angle);
                    float cos = MathHelper.func_76134_b((float)angle);
                    float r = MathHelper.func_151240_a((Random)world.field_73012_v, (float)minDist, (float)maxDist);
                    int i1 = MathHelper.func_76128_c((double)((double)i + 0.5 + (double)(cos * r)));
                    int k1 = MathHelper.func_76128_c((double)((double)k + 0.5 + (double)(sin * r)));
                    double d = (double)i1 + 0.5;
                    float halfWidth = this.theEntity.field_70130_N / 2.0f;
                    int j1 = MathHelper.func_76136_a((Random)world.field_73012_v, (int)(j - 4), (int)(j + 4));
                    double d1 = j1;
                    AxisAlignedBB npcBB = AxisAlignedBB.func_72330_a((double)(d - (double)halfWidth), (double)(d1 + (double)(yExtra = -this.theEntity.field_70129_M + this.theEntity.field_70139_V)), (double)((d2 = (double)k1 + 0.5) - (double)halfWidth), (double)(d + (double)halfWidth), (double)(d1 + (double)yExtra + (double)(height = this.theEntity.field_70131_O)), (double)(d2 + (double)halfWidth));
                    if (!world.func_147461_a(npcBB).isEmpty() || !world.func_147439_a(i1, j1 - 1, k1).isSideSolid((IBlockAccess)world, i1, j1 - 1, k1, ForgeDirection.UP)) continue;
                    if (this.theEntity.field_70154_o instanceof EntityLiving) {
                        EntityLiving mount = (EntityLiving)this.theEntity.field_70154_o;
                        float mHalfWidth = mount.field_70130_N / 2.0f;
                        float mYExtra = -mount.field_70129_M + mount.field_70139_V;
                        float mHeight = mount.field_70131_O;
                        AxisAlignedBB mountBB = AxisAlignedBB.func_72330_a((double)(d - (double)mHalfWidth), (double)(d1 + (double)mYExtra), (double)(d2 - (double)mHalfWidth), (double)(d + (double)mHalfWidth), (double)(d1 + (double)mYExtra + (double)mHeight), (double)(d2 + (double)mHalfWidth));
                        if (!world.func_147461_a(mountBB).isEmpty()) continue;
                        mount.func_70012_b(d, d1, d2, this.theEntity.field_70177_z, this.theEntity.field_70125_A);
                        mount.field_70143_R = 0.0f;
                        mount.func_70661_as().func_75499_g();
                        mount.func_70624_b(null);
                        this.theEntity.field_70143_R = 0.0f;
                        this.theEntity.func_70661_as().func_75499_g();
                        this.theEntity.func_70624_b(null);
                        return true;
                    }
                    this.theEntity.func_70012_b(d, d1, d2, this.theEntity.field_70177_z, this.theEntity.field_70125_A);
                    this.theEntity.field_70143_R = 0.0f;
                    this.theEntity.func_70661_as().func_75499_g();
                    this.theEntity.func_70624_b(null);
                    return true;
                }
                if (failsafe) {
                    double d = (double)i + 0.5;
                    double d1 = j;
                    double d2 = (double)k + 0.5;
                    if (world.func_147439_a(i, j - 1, k).isSideSolid((IBlockAccess)world, i, j - 1, k, ForgeDirection.UP)) {
                        if (this.theEntity.field_70154_o instanceof EntityLiving) {
                            EntityLiving mount = (EntityLiving)this.theEntity.field_70154_o;
                            mount.func_70012_b(d, d1, d2, this.theEntity.field_70177_z, this.theEntity.field_70125_A);
                            mount.field_70143_R = 0.0f;
                            mount.func_70661_as().func_75499_g();
                            mount.func_70624_b(null);
                            this.theEntity.field_70143_R = 0.0f;
                            this.theEntity.func_70661_as().func_75499_g();
                            this.theEntity.func_70624_b(null);
                            return true;
                        }
                        this.theEntity.func_70012_b(d, d1, d2, this.theEntity.field_70177_z, this.theEntity.field_70125_A);
                        this.theEntity.field_70143_R = 0.0f;
                        this.theEntity.func_70661_as().func_75499_g();
                        this.theEntity.func_70624_b(null);
                        return true;
                    }
                }
            }
        }
        return false;
    }

    public void writeToNBT(NBTTagCompound nbt) {
        NBTTagCompound data = new NBTTagCompound();
        data.func_74757_a("IsActive", this.isActive);
        if (this.hiringPlayerUUID != null) {
            data.func_74778_a("HiringPlayerUUID", this.hiringPlayerUUID.toString());
        }
        data.func_74776_a("AlignReqF", this.alignmentRequiredToCommand);
        data.func_74774_a("PledgeType", (byte)this.pledgeType.typeID);
        data.func_74757_a("CanMove", this.canMove);
        data.func_74757_a("TeleportAutomatically", this.teleportAutomatically);
        data.func_74768_a("MobKills", this.mobKills);
        data.func_74757_a("GuardMode", this.guardMode);
        data.func_74768_a("GuardRange", this.guardRange);
        data.func_74768_a("Task", this.hiredTask.ordinal());
        data.func_74768_a("Xp", this.xp);
        data.func_74768_a("XpLevel", this.xpLevel);
        if (!StringUtils.func_151246_b((String)this.hiredSquadron)) {
            data.func_74778_a("Squadron", this.hiredSquadron);
        }
        if (this.hiredInventory != null) {
            this.hiredInventory.writeToNBT(data);
        }
        nbt.func_74782_a("HiredNPCInfo", (NBTBase)data);
    }

    public void readFromNBT(NBTTagCompound nbt) {
        NBTTagCompound data = nbt.func_74775_l("HiredNPCInfo");
        if (data != null) {
            String savedUUID;
            if (data.func_74764_b("HiringPlayerName")) {
                String name = data.func_74779_i("HiringPlayerName");
                this.hiringPlayerUUID = UUID.fromString(PreYggdrasilConverter.func_152719_a((String)name));
            } else if (data.func_74764_b("HiringPlayerUUID") && !StringUtils.func_151246_b((String)(savedUUID = data.func_74779_i("HiringPlayerUUID")))) {
                this.hiringPlayerUUID = UUID.fromString(savedUUID);
            }
            this.isActive = data.func_74767_n("IsActive");
            this.alignmentRequiredToCommand = data.func_74764_b("AlignmentRequired") ? (float)data.func_74762_e("AlignmentRequired") : data.func_74760_g("AlignReqF");
            if (data.func_74764_b("PledgeType")) {
                byte pledgeID = data.func_74771_c("PledgeType");
                this.pledgeType = LOTRUnitTradeEntry.PledgeType.forID(pledgeID);
            }
            this.canMove = data.func_74767_n("CanMove");
            if (data.func_74764_b("TeleportAutomatically")) {
                this.teleportAutomatically = data.func_74767_n("TeleportAutomatically");
                this.mobKills = data.func_74762_e("MobKills");
                this.setGuardMode(data.func_74767_n("GuardMode"));
                this.setGuardRange(data.func_74762_e("GuardRange"));
            }
            this.setTask(Task.forID(data.func_74762_e("Task")));
            if (data.func_74764_b("Xp")) {
                this.xp = data.func_74762_e("Xp");
            }
            if (data.func_74764_b("XpLevel")) {
                this.xpLevel = data.func_74762_e("XpLevel");
            } else if (data.func_74764_b("XpLvl")) {
                this.xpLevel = data.func_74762_e("XpLvl");
                this.correctOutdatedLevelUpHealthGain();
            }
            if (data.func_74764_b("Squadron")) {
                this.hiredSquadron = data.func_74779_i("Squadron");
            }
            if (this.hiredInventory != null) {
                this.hiredInventory.readFromNBT(data);
            }
        }
    }

    private void correctOutdatedLevelUpHealthGain() {
        int levelsGained = this.xpLevel - 1;
        if (levelsGained > 0) {
            float oldHealthGain = 2.0f;
            float newHealthGain = 1.0f;
            float healthCorrectionReduction = (oldHealthGain - newHealthGain) * (float)levelsGained;
            IAttributeInstance attrHealth = this.theEntity.func_110148_a(SharedMonsterAttributes.field_111267_a);
            attrHealth.func_111128_a(attrHealth.func_111125_b() - (double)healthCorrectionReduction);
            this.theEntity.func_70606_j(this.theEntity.func_110143_aJ());
        }
    }

    public void sendBasicData(EntityPlayerMP entityplayer) {
        LOTRPacketHiredInfo packet = new LOTRPacketHiredInfo(this.theEntity.func_145782_y(), this.hiringPlayerUUID, this.hiredTask, this.getSquadron(), this.xpLevel);
        LOTRPacketHandler.networkWrapper.sendTo((IMessage)packet, entityplayer);
    }

    private void sendBasicDataToAllWatchers() {
        int x = MathHelper.func_76128_c((double)this.theEntity.field_70165_t) >> 4;
        int z = MathHelper.func_76128_c((double)this.theEntity.field_70161_v) >> 4;
        PlayerManager playermanager = ((WorldServer)this.theEntity.field_70170_p).func_73040_p();
        List players = this.theEntity.field_70170_p.field_73010_i;
        for (Object obj : players) {
            EntityPlayerMP entityplayer = (EntityPlayerMP)obj;
            if (!playermanager.func_72694_a(entityplayer, x, z)) continue;
            this.sendBasicData(entityplayer);
        }
    }

    public void receiveBasicData(LOTRPacketHiredInfo packet) {
        this.hiringPlayerUUID = packet.hiringPlayer;
        this.setTask(packet.task);
        this.setSquadron(packet.squadron);
        this.xpLevel = packet.xpLvl;
    }

    public void sendClientPacket(boolean shouldOpenGui) {
        if (this.theEntity.field_70170_p.field_72995_K || this.getHiringPlayer() == null) {
            return;
        }
        LOTRPacketHiredGui packet = new LOTRPacketHiredGui(this.theEntity.func_145782_y(), shouldOpenGui);
        packet.isActive = this.isActive;
        packet.canMove = this.canMove;
        packet.teleportAutomatically = this.teleportAutomatically;
        packet.mobKills = this.mobKills;
        packet.xp = this.xp;
        packet.alignmentRequired = this.alignmentRequiredToCommand;
        packet.pledgeType = this.pledgeType;
        packet.inCombat = this.inCombat;
        packet.guardMode = this.guardMode;
        packet.guardRange = this.guardRange;
        LOTRPacketHandler.networkWrapper.sendTo((IMessage)packet, (EntityPlayerMP)this.getHiringPlayer());
        if (shouldOpenGui) {
            this.isGuiOpen = true;
        }
    }

    public void receiveClientPacket(LOTRPacketHiredGui packet) {
        this.isActive = packet.isActive;
        this.canMove = packet.canMove;
        this.teleportAutomatically = packet.teleportAutomatically;
        this.mobKills = packet.mobKills;
        this.xp = packet.xp;
        this.alignmentRequiredToCommand = packet.alignmentRequired;
        this.pledgeType = packet.pledgeType;
        this.inCombat = packet.inCombat;
        this.guardMode = packet.guardMode;
        this.guardRange = packet.guardRange;
    }

    public static enum Task {
        WARRIOR(true),
        FARMER(false);

        public final boolean displayXpLevel;

        private Task(boolean displayLvl) {
            this.displayXpLevel = displayLvl;
        }

        public static Task forID(int id) {
            for (Task task : Task.values()) {
                if (task.ordinal() != id) continue;
                return task;
            }
            return WARRIOR;
        }
    }
}

