/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.entity.projectile;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import lotr.common.LOTRMod;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFishFood;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MathHelper;
import net.minecraft.util.WeightedRandom;
import net.minecraftforge.common.FishingHooks;

public class LOTRFishing {
    private static List<FishingItem> fish = new ArrayList<FishingItem>();
    private static List<FishingItem> junk = new ArrayList<FishingItem>();
    private static List<FishingItem> treasure = new ArrayList<FishingItem>();

    public static FishResult getFishResult(Random rand, float chance, int luck, int speed, boolean allowJunkTreasure) {
        float junkChance = 0.1f - (float)luck * 0.025f - (float)speed * 0.01f;
        float treasureChance = 0.2f + (float)luck * 0.01f - (float)speed * 0.01f;
        junkChance = MathHelper.func_76131_a((float)junkChance, (float)0.0f, (float)1.0f);
        treasureChance = MathHelper.func_76131_a((float)treasureChance, (float)0.0f, (float)1.0f);
        if (allowJunkTreasure) {
            if (chance < junkChance) {
                ItemStack result = ((FishingItem)WeightedRandom.func_76271_a((Random)rand, junk)).getRandomResult(rand);
                return new FishResult(FishingHooks.FishableCategory.JUNK, result);
            }
            if ((chance -= junkChance) < treasureChance) {
                ItemStack result = ((FishingItem)WeightedRandom.func_76271_a((Random)rand, treasure)).getRandomResult(rand);
                return new FishResult(FishingHooks.FishableCategory.TREASURE, result);
            }
        }
        ItemStack result = ((FishingItem)WeightedRandom.func_76271_a((Random)rand, fish)).getRandomResult(rand);
        return new FishResult(FishingHooks.FishableCategory.FISH, result);
    }

    static {
        fish.add(new FishingItem(new ItemStack(Items.field_151115_aP, 1, ItemFishFood.FishType.COD.func_150976_a()), 60));
        fish.add(new FishingItem(new ItemStack(Items.field_151115_aP, 1, ItemFishFood.FishType.SALMON.func_150976_a()), 25));
        fish.add(new FishingItem(new ItemStack(Items.field_151115_aP, 1, ItemFishFood.FishType.CLOWNFISH.func_150976_a()), 2));
        fish.add(new FishingItem(new ItemStack(Items.field_151115_aP, 1, ItemFishFood.FishType.PUFFERFISH.func_150976_a()), 13));
        junk.add(new FishingItem(new ItemStack((Item)Items.field_151112_aM), 5).setMaxDurability(0.1f));
        junk.add(new FishingItem(new ItemStack(Items.field_151041_m), 2).setMaxDurability(0.5f));
        junk.add(new FishingItem(new ItemStack(Items.field_151053_p), 2).setMaxDurability(0.5f));
        junk.add(new FishingItem(new ItemStack(Items.field_151039_o), 2).setMaxDurability(0.5f));
        junk.add(new FishingItem(new ItemStack(Items.field_151038_n), 2).setMaxDurability(0.5f));
        junk.add(new FishingItem(new ItemStack(Items.field_151017_I), 2).setMaxDurability(0.5f));
        junk.add(new FishingItem(new ItemStack(LOTRMod.leatherHat), 10));
        junk.add(new FishingItem(new ItemStack((Item)Items.field_151024_Q), 5).setMaxDurability(0.5f));
        junk.add(new FishingItem(new ItemStack((Item)Items.field_151021_T), 5).setMaxDurability(0.5f));
        junk.add(new FishingItem(new ItemStack(LOTRMod.helmetBone), 2).setMaxDurability(0.5f));
        junk.add(new FishingItem(new ItemStack(LOTRMod.bootsBone), 2).setMaxDurability(0.5f));
        junk.add(new FishingItem(new ItemStack(Items.field_151144_bL, 1, 0), 5));
        junk.add(new FishingItem(new ItemStack(Items.field_151103_aS), 20));
        junk.add(new FishingItem(new ItemStack(LOTRMod.orcBone), 10));
        junk.add(new FishingItem(new ItemStack(LOTRMod.elfBone), 2));
        junk.add(new FishingItem(new ItemStack(LOTRMod.dwarfBone), 2));
        junk.add(new FishingItem(new ItemStack(LOTRMod.hobbitBone), 1));
        junk.add(new FishingItem(new ItemStack(LOTRMod.rottenLog, 1, 0), 10));
        junk.add(new FishingItem(new ItemStack(Items.field_151116_aA), 10));
        junk.add(new FishingItem(new ItemStack(Items.field_151007_F), 10));
        junk.add(new FishingItem(new ItemStack(Items.field_151054_z), 10));
        junk.add(new FishingItem(new ItemStack(LOTRMod.mug), 10));
        junk.add(new FishingItem(new ItemStack(Items.field_151122_aG), 5));
        junk.add(new FishingItem(new ItemStack(Items.field_151055_y), 10));
        junk.add(new FishingItem(new ItemStack(Items.field_151008_G), 10));
        junk.add(new FishingItem(new ItemStack(Items.field_151100_aR, 1, 0), 5));
        junk.add(new FishingItem(new ItemStack(Items.field_151078_bh), 5));
        junk.add(new FishingItem(new ItemStack(LOTRMod.saltedFlesh), 5));
        junk.add(new FishingItem(new ItemStack(LOTRMod.maggotyBread), 5));
        junk.add(new FishingItem(new ItemStack(LOTRMod.manFlesh), 5));
        junk.add(new FishingItem(new ItemStack(Blocks.field_150392_bi), 15));
        treasure.add(new FishingItem(new ItemStack(LOTRMod.pearl), 200));
        treasure.add(new FishingItem(new ItemStack((Item)Items.field_151031_f), 20).setMaxDurability(0.75f));
        treasure.add(new FishingItem(new ItemStack((Item)Items.field_151112_aM), 20).setMaxDurability(0.75f));
        treasure.add(new FishingItem(new ItemStack(LOTRMod.daggerIron), 20).setMaxDurability(0.75f));
        treasure.add(new FishingItem(new ItemStack(LOTRMod.daggerBronze), 20).setMaxDurability(0.75f));
        treasure.add(new FishingItem(new ItemStack(LOTRMod.silverCoin, 1, 0), 100));
        treasure.add(new FishingItem(new ItemStack(LOTRMod.silverCoin, 1, 1), 10));
        treasure.add(new FishingItem(new ItemStack(LOTRMod.silverCoin, 1, 2), 1));
        treasure.add(new FishingItem(new ItemStack(LOTRMod.pouch, 1, 0), 20));
        treasure.add(new FishingItem(new ItemStack(LOTRMod.pouch, 1, 1), 10));
        treasure.add(new FishingItem(new ItemStack(LOTRMod.pouch, 1, 2), 5));
        treasure.add(new FishingItem(new ItemStack(Items.field_151042_j), 20));
        treasure.add(new FishingItem(new ItemStack(LOTRMod.ironNugget), 10));
        treasure.add(new FishingItem(new ItemStack(LOTRMod.bronze), 10));
        treasure.add(new FishingItem(new ItemStack(LOTRMod.copper), 10));
        treasure.add(new FishingItem(new ItemStack(LOTRMod.tin), 10));
        treasure.add(new FishingItem(new ItemStack(Items.field_151074_bl), 50));
        treasure.add(new FishingItem(new ItemStack(Items.field_151043_k), 5));
        treasure.add(new FishingItem(new ItemStack(LOTRMod.silverNugget), 50));
        treasure.add(new FishingItem(new ItemStack(LOTRMod.silver), 5));
        treasure.add(new FishingItem(new ItemStack(LOTRMod.mithrilNugget), 5));
        treasure.add(new FishingItem(new ItemStack(LOTRMod.silverRing), 10));
        treasure.add(new FishingItem(new ItemStack(LOTRMod.goldRing), 5));
        treasure.add(new FishingItem(new ItemStack(LOTRMod.mithrilRing), 1));
    }

    public static class FishResult {
        public final FishingHooks.FishableCategory category;
        public final ItemStack fishedItem;

        public FishResult(FishingHooks.FishableCategory c, ItemStack item) {
            this.category = c;
            this.fishedItem = item;
        }
    }

    private static class FishingItem
    extends WeightedRandom.Item {
        private final ItemStack theItem;
        private float maxDurability = 0.0f;

        private FishingItem(ItemStack item, int weight) {
            super(weight);
            this.theItem = item;
        }

        public FishingItem setMaxDurability(float f) {
            this.maxDurability = f;
            return this;
        }

        public ItemStack getRandomResult(Random rand) {
            ItemStack result = this.theItem.func_77946_l();
            if (this.maxDurability > 0.0f) {
                float damageF = 1.0f - rand.nextFloat() * this.maxDurability;
                int damage = (int)(damageF * (float)result.func_77958_k());
                damage = Math.min(damage, result.func_77958_k());
                damage = Math.max(damage, 1);
                result.func_77964_b(damage);
            }
            return result;
        }
    }
}

